/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.contents.item;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tictim.paraglider.config.Cfg;

public class ParagliderItem
extends Item {
    public ParagliderItem(Item.Properties p) {
        super(p.durability(100));
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        if (stack.isDamaged() && stack.getMaxDamage() <= stack.getDamageValue()) {
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.paraglider.paraglider_broken").setStyle(Style.EMPTY.withColor(ChatFormatting.RED)));
        }
    }

    public int getMaxDamage(@NotNull ItemStack stack) {
        return Math.max(1, Cfg.get().paragliderDurability());
    }

    public <T extends LivingEntity> int damageItem(@NotNull ItemStack stack, int amount, @Nullable T entity, @NotNull Consumer<Item> onBroken) {
        return Cfg.get().paragliderDurability() > 0 ? amount : 0;
    }

    public boolean canGrindstoneRepair(@NotNull ItemStack stack) {
        return false;
    }

    public boolean isValidRepairItem(@NotNull ItemStack stack, @NotNull ItemStack repairCandidate) {
        return repairCandidate.is(Tags.Items.LEATHERS);
    }

    public boolean shouldCauseReequipAnimation(@NotNull ItemStack oldStack, @NotNull ItemStack newStack, boolean slotChanged) {
        return slotChanged || super.shouldCauseBlockBreakReset(oldStack, newStack);
    }
}

