/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.contents.item;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import tictim.paraglider.ParagliderUtils;
import tictim.paraglider.api.vessel.VesselContainer;
import tictim.paraglider.contents.Contents;

public class AntiVesselItem
extends Item {
    public AntiVesselItem(@NotNull Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!level.isClientSide) {
            VesselContainer vessels = VesselContainer.get(player);
            int heartContainersTaken = vessels.takeHeartContainers(Integer.MAX_VALUE, false, true);
            int staminaVesselsTaken = vessels.takeStaminaVessels(Integer.MAX_VALUE, false, true);
            if (heartContainersTaken > 0 || staminaVesselsTaken > 0) {
                if (heartContainersTaken > 0) {
                    ParagliderUtils.giveItem(player, new ItemStack((ItemLike)Contents.get().heartContainer(), heartContainersTaken));
                }
                if (staminaVesselsTaken > 0) {
                    ParagliderUtils.giveItem(player, new ItemStack((ItemLike)Contents.get().staminaVessel(), staminaVesselsTaken));
                }
                stack.shrink(1);
                return InteractionResultHolder.consume((Object)stack);
            }
        }
        return InteractionResultHolder.success((Object)stack);
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.paraglider.anti_vessel.0").setStyle(Style.EMPTY.withColor(ChatFormatting.GREEN)));
    }

    public boolean isFoil(@NotNull ItemStack stack) {
        return true;
    }
}

