/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.contents;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.function.Function;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import org.jetbrains.annotations.NotNull;
import tictim.paraglider.ParagliderMod;
import tictim.paraglider.config.FeatureCfg;

public final class ParagliderVillageStructures {
    private ParagliderVillageStructures() {
    }

    public static void addVillageStructures(RegistryAccess registryAccess) {
        if (!FeatureCfg.get().enableVillageStructures()) {
            return;
        }
        Registry reg = registryAccess.registryOrThrow(Registries.TEMPLATE_POOL);
        ParagliderMod.LOGGER.debug("Start adding village structures");
        ParagliderVillageStructures.appendPool((Registry<StructureTemplatePool>)reg, ResourceLocation.withDefaultNamespace((String)"village/desert/houses"), Pair.of((Object)StructurePoolElement.legacy((String)"paraglider:gerudo_village_goddess_statue"), (Object)1), Pair.of((Object)StructurePoolElement.legacy((String)"paraglider:desert_village_horned_statue"), (Object)1));
        ParagliderVillageStructures.appendPool((Registry<StructureTemplatePool>)reg, ResourceLocation.withDefaultNamespace((String)"village/plains/houses"), Pair.of((Object)StructurePoolElement.legacy((String)"paraglider:hateno_village_goddess_statue"), (Object)1), Pair.of((Object)StructurePoolElement.legacy((String)"paraglider:plains_village_horned_statue"), (Object)1));
        ParagliderVillageStructures.appendPool((Registry<StructureTemplatePool>)reg, ResourceLocation.withDefaultNamespace((String)"village/savanna/houses"), Pair.of((Object)StructurePoolElement.legacy((String)"paraglider:rito_village_goddess_statue"), (Object)3), Pair.of((Object)StructurePoolElement.legacy((String)"paraglider:savanna_village_horned_statue"), (Object)1));
        ParagliderVillageStructures.appendPool((Registry<StructureTemplatePool>)reg, ResourceLocation.withDefaultNamespace((String)"village/snowy/houses"), Pair.of((Object)StructurePoolElement.legacy((String)"paraglider:snowy_village_horned_statue"), (Object)1));
        ParagliderVillageStructures.appendPool((Registry<StructureTemplatePool>)reg, ResourceLocation.withDefaultNamespace((String)"village/taiga/houses"), Pair.of((Object)StructurePoolElement.legacy((String)"paraglider:kakariko_village_goddess_statue"), (Object)3), Pair.of((Object)StructurePoolElement.legacy((String)"paraglider:taiga_village_horned_statue"), (Object)1));
        ParagliderMod.LOGGER.debug("Finished adding village structures");
    }

    @SafeVarargs
    private static void appendPool(Registry<StructureTemplatePool> templatePoolRegistry, ResourceLocation id, Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer> ... elementToWeight) {
        StructureTemplatePool pool = (StructureTemplatePool)templatePoolRegistry.get(id);
        if (pool == null) {
            ParagliderMod.LOGGER.warn("Template pool '{}' doesn't exist", (Object)id);
            return;
        }
        if (elementToWeight.length == 0) {
            return;
        }
        ArrayList<Pair> newWeightedPool = new ArrayList<Pair>(pool.rawTemplates.size() + elementToWeight.length);
        newWeightedPool.addAll(pool.rawTemplates);
        for (Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer> p : elementToWeight) {
            newWeightedPool.add(Pair.of((Object)((StructurePoolElement)((Function)p.getFirst()).apply(StructureTemplatePool.Projection.RIGID)), (Object)((Integer)p.getSecond())));
        }
        pool.rawTemplates = newWeightedPool;
        pool.templates.clear();
        for (Pair pair : pool.rawTemplates) {
            StructurePoolElement structurepoolelement = (StructurePoolElement)pair.getFirst();
            for (int i = 0; i < (Integer)pair.getSecond(); ++i) {
                pool.templates.add((Object)structurepoolelement);
            }
        }
        ParagliderMod.LOGGER.debug("Added {} elements to template pool '{}'", (Object)elementToWeight.length, (Object)id);
    }

    public static final class ReloadListener
    extends SimplePreparableReloadListener<Void> {
        private final RegistryAccess registryAccess;

        public ReloadListener(RegistryAccess registryAccess) {
            this.registryAccess = registryAccess;
        }

        @NotNull
        protected Void prepare(@NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profiler) {
            return null;
        }

        protected void apply(@NotNull Void object, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profiler) {
            ParagliderVillageStructures.addVillageStructures(this.registryAccess);
        }
    }
}

