/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.contents;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.crafting.IngredientType;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.jetbrains.annotations.NotNull;
import tictim.paraglider.ParagliderMod;
import tictim.paraglider.api.ParagliderAPI;
import tictim.paraglider.api.StaminaEfficiencyAttribute;
import tictim.paraglider.api.bargain.Bargain;
import tictim.paraglider.api.bargain.BargainPreview;
import tictim.paraglider.contents.CommonContents;
import tictim.paraglider.contents.ParagliderConfigCondition;
import tictim.paraglider.contents.ParaglidingFlag;
import tictim.paraglider.contents.block.GoddessStatueBlock;
import tictim.paraglider.contents.block.HornedStatueBlock;
import tictim.paraglider.contents.item.AntiVesselItem;
import tictim.paraglider.contents.item.BaseElixirItem;
import tictim.paraglider.contents.item.EssenceItem;
import tictim.paraglider.contents.item.HeartContainerItem;
import tictim.paraglider.contents.item.ParagliderItem;
import tictim.paraglider.contents.item.SpiritOrbItem;
import tictim.paraglider.contents.item.StaminaVesselItem;
import tictim.paraglider.contents.item.TooltipBlockItem;
import tictim.paraglider.contents.loot.ConfigurableSpiritOrbLoot;
import tictim.paraglider.contents.loot.ParagliderLoot;
import tictim.paraglider.contents.loot.ParagliderLootConditions;
import tictim.paraglider.contents.loot.SpiritOrbLoot;
import tictim.paraglider.contents.loot.VesselLoot;
import tictim.paraglider.contents.mobeffect.StaminaEfficiencyMobEffect;
import tictim.paraglider.contents.recipe.CosmeticRecipe;
import tictim.paraglider.contents.recipe.SimpleBargain;
import tictim.paraglider.contents.recipe.SimpleBargainSerializer;
import tictim.paraglider.contents.recipe.WaterBottleIngredientType;
import tictim.paraglider.contents.recipe.preview.IngredientPreview;
import tictim.paraglider.contents.recipe.preview.ItemPreview;
import tictim.paraglider.contents.recipe.preview.VesselPreview;
import tictim.paraglider.contents.worldgen.NetherHornedStatue;
import tictim.paraglider.contents.worldgen.TarreyTownGoddessStatue;
import tictim.paraglider.contents.worldgen.UndergroundHornedStatue;
import tictim.paraglider.impl.AttachmentProvider;
import tictim.paraglider.impl.MovementState;
import tictim.paraglider.impl.SimpleVesselContainer;
import tictim.paraglider.impl.movement.PlayerMovement;
import tictim.paraglider.impl.stamina.BotWStaminaData;

public class Contents {
    public final DeferredRegister<Block> blocks = DeferredRegister.create((ResourceKey)Registries.BLOCK, (String)"paraglider");
    public final DeferredRegister<Item> items = DeferredRegister.create((ResourceKey)Registries.ITEM, (String)"paraglider");
    public final DeferredRegister<Attribute> attributes = DeferredRegister.create((ResourceKey)Registries.ATTRIBUTE, (String)"paraglider");
    public final DeferredRegister<DataComponentType<?>> dataComponents = DeferredRegister.create((ResourceKey)Registries.DATA_COMPONENT_TYPE, (String)"paraglider");
    public final DeferredRegister<RecipeSerializer<?>> recipeSerializers = DeferredRegister.create((ResourceKey)Registries.RECIPE_SERIALIZER, (String)"paraglider");
    public final DeferredRegister<RecipeType<?>> recipeTypes = DeferredRegister.create((ResourceKey)Registries.RECIPE_TYPE, (String)"paraglider");
    public final DeferredRegister<MapCodec<? extends IGlobalLootModifier>> loots = DeferredRegister.create((Registry)NeoForgeRegistries.GLOBAL_LOOT_MODIFIER_SERIALIZERS, (String)"paraglider");
    public final DeferredRegister<LootItemConditionType> lootConditions = DeferredRegister.create((ResourceKey)Registries.LOOT_CONDITION_TYPE, (String)"paraglider");
    public final DeferredRegister<MobEffect> mobEffects = DeferredRegister.create((ResourceKey)Registries.MOB_EFFECT, (String)"paraglider");
    public final DeferredRegister<StructureType<?>> structureTypes = DeferredRegister.create((ResourceKey)Registries.STRUCTURE_TYPE, (String)"paraglider");
    public final DeferredRegister<StructurePieceType> pieces = DeferredRegister.create((ResourceKey)Registries.STRUCTURE_PIECE, (String)"paraglider");
    public final DeferredRegister<CreativeModeTab> creativeTabs = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"paraglider");
    public final DeferredRegister<AttachmentType<?>> attachmentTypes = DeferredRegister.create((Registry)NeoForgeRegistries.ATTACHMENT_TYPES, (String)"paraglider");
    public final DeferredRegister<MapCodec<? extends ICondition>> conditionSerializers = DeferredRegister.create((Registry)NeoForgeRegistries.CONDITION_SERIALIZERS, (String)"paraglider");
    public final DeferredRegister<IngredientType<?>> ingredientTypes = DeferredRegister.create((Registry)NeoForgeRegistries.INGREDIENT_TYPES, (String)"paraglider");
    public final DeferredRegister<BargainPreview.Type<?>> bargainPreviewTypes = DeferredRegister.create(BargainPreview.TYPE_REGISTRY_KEY, (String)"paraglider");
    public final DeferredHolder<Block, Block> goddessStatue = this.blocks.register("goddess_statue", id -> new GoddessStatueBlock(CommonContents.statueBlock()));
    public final DeferredHolder<Block, Block> kakarikoGoddessStatue = this.blocks.register("kakariko_goddess_statue", id -> new GoddessStatueBlock(CommonContents.statueBlock()));
    public final DeferredHolder<Block, Block> goronGoddessStatue = this.blocks.register("goron_goddess_statue", id -> new GoddessStatueBlock(CommonContents.statueBlock().lightLevel(value -> 15)));
    public final DeferredHolder<Block, Block> ritoGoddessStatue = this.blocks.register("rito_goddess_statue", id -> new GoddessStatueBlock(CommonContents.statueBlock()));
    public final DeferredHolder<Block, Block> hornedStatue = this.blocks.register("horned_statue", id -> new HornedStatueBlock(CommonContents.statueBlock()));
    public final DeferredHolder<Attribute, Attribute> maxStamina = this.attributes.register("max_stamina", () -> new RangedAttribute("attribute.paraglider.max_stamina", 0.0, 0.0, Double.MAX_VALUE).setSyncable(true));
    public final DeferredHolder<Attribute, Attribute> staminaEfficiency = this.attributes.register("stamina_efficiency", () -> new StaminaEfficiencyAttribute("attribute.paraglider.stamina_efficiency"));
    public final DeferredHolder<Attribute, Attribute> staminaRecovery = this.attributes.register("stamina_recovery", () -> new StaminaEfficiencyAttribute("attribute.paraglider.stamina_recovery"));
    public final DeferredHolder<Attribute, Attribute> paraglidingStaminaEfficiency = this.attributes.register("paragliding_stamina_efficiency", () -> new StaminaEfficiencyAttribute("attribute.paraglider.paragliding_stamina_efficiency"));
    public final DeferredHolder<Attribute, Attribute> runningStaminaEfficiency = this.attributes.register("running_stamina_efficiency", () -> new StaminaEfficiencyAttribute("attribute.paraglider.running_stamina_efficiency"));
    public final DeferredHolder<Attribute, Attribute> swimmingStaminaEfficiency = this.attributes.register("swimming_stamina_efficiency", () -> new StaminaEfficiencyAttribute("attribute.paraglider.swimming_stamina_efficiency"));
    public final DeferredHolder<DataComponentType<?>, DataComponentType<ParaglidingFlag>> paraglidingFlagComponent = this.dataComponents.register("paragliding", () -> DataComponentType.builder().persistent(Codec.unit((Object)((Object)ParaglidingFlag.INSTANCE))).networkSynchronized(StreamCodec.unit((Object)((Object)ParaglidingFlag.INSTANCE))).build());
    public final DeferredHolder<Item, Item> paraglider = this.items.register("paraglider", id -> new ParagliderItem(CommonContents.p().stacksTo(1)));
    public final DeferredHolder<Item, Item> dekuLeaf = this.items.register("deku_leaf", id -> new ParagliderItem(CommonContents.p().stacksTo(1)));
    public final DeferredHolder<Item, Item> heartContainer = this.items.register("heart_container", id -> new HeartContainerItem(CommonContents.p().rarity(Rarity.RARE).fireResistant()));
    public final DeferredHolder<Item, Item> staminaVessel = this.items.register("stamina_vessel", id -> new StaminaVesselItem(CommonContents.p().rarity(Rarity.RARE).fireResistant()));
    public final DeferredHolder<Item, Item> spiritOrb = this.items.register("spirit_orb", id -> new SpiritOrbItem(CommonContents.p().rarity(Rarity.UNCOMMON).fireResistant()));
    public final DeferredHolder<Item, Item> antiVessel = this.items.register("anti_vessel", id -> new AntiVesselItem(CommonContents.p().rarity(Rarity.EPIC).fireResistant()));
    public final DeferredHolder<Item, Item> essence = this.items.register("essence", id -> new EssenceItem(CommonContents.p().rarity(Rarity.RARE).fireResistant()));
    public final DeferredHolder<Item, Item> energizingElixir1 = this.items.register("energizing_elixir_1", id -> new BaseElixirItem.Energizing(CommonContents.staminaPotion(), 1000.0));
    public final DeferredHolder<Item, Item> energizingElixir2 = this.items.register("energizing_elixir_2", id -> new BaseElixirItem.Energizing(CommonContents.staminaPotion(), 2000.0, 0, 1200));
    public final DeferredHolder<Item, Item> energizingElixir3 = this.items.register("energizing_elixir_3", id -> new BaseElixirItem.Energizing(CommonContents.staminaPotion(), 3000.0, 1, 2400));
    public final DeferredHolder<Item, Item> enduringElixir1 = this.items.register("enduring_elixir_1", id -> new BaseElixirItem.Enduring(CommonContents.staminaPotion(), 500.0));
    public final DeferredHolder<Item, Item> enduringElixir2 = this.items.register("enduring_elixir_2", id -> new BaseElixirItem.Enduring(CommonContents.staminaPotion(), 1000.0));
    public final DeferredHolder<Item, Item> enduringElixir3 = this.items.register("enduring_elixir_3", id -> new BaseElixirItem.Enduring(CommonContents.staminaPotion(), 2000.0));
    public final DeferredHolder<Item, Item> energizingMixture = this.items.register("energizing_mixture", id -> new Item(CommonContents.p().stacksTo(1)));
    public final DeferredHolder<Item, Item> enduringMixture = this.items.register("enduring_mixture", id -> new Item(CommonContents.p().stacksTo(1)));
    public final DeferredHolder<Item, BlockItem> goddessStatueItem = this.items.register("goddess_statue", id -> new BlockItem(this.goddessStatue(), CommonContents.p().rarity(Rarity.RARE)));
    public final DeferredHolder<Item, BlockItem> kakarikoGoddessStatueItem = this.items.register("kakariko_goddess_statue", id -> new TooltipBlockItem(this.kakarikoGoddessStatue(), CommonContents.p().rarity(Rarity.RARE), CommonContents.kakarikoStatueTooltip()));
    public final DeferredHolder<Item, BlockItem> goronGoddessStatueItem = this.items.register("goron_goddess_statue", id -> new TooltipBlockItem(this.goronGoddessStatue(), CommonContents.p().rarity(Rarity.RARE), CommonContents.goronStatueTooltip()));
    public final DeferredHolder<Item, BlockItem> ritoGoddessStatueItem = this.items.register("rito_goddess_statue", id -> new TooltipBlockItem(this.ritoGoddessStatue(), CommonContents.p().rarity(Rarity.RARE), CommonContents.ritoStatueTooltip()));
    public final DeferredHolder<Item, BlockItem> hornedStatueItem = this.items.register("horned_statue", id -> new TooltipBlockItem(this.hornedStatue(), CommonContents.p().rarity(Rarity.EPIC), (Component)Component.translatable((String)"tooltip.paraglider.horned_statue.0").setStyle(Style.EMPTY.withColor(ChatFormatting.GRAY))));
    public final DeferredHolder<RecipeSerializer<?>, CosmeticRecipe.Serializer> cosmeticRecipe = this.recipeSerializers.register("cosmetic", CosmeticRecipe.Serializer::new);
    public final DeferredHolder<RecipeSerializer<?>, SimpleBargainSerializer> bargainRecipe = this.recipeSerializers.register("statue_bargain", SimpleBargainSerializer::new);
    public final DeferredHolder<RecipeType<?>, RecipeType<Bargain>> bargainRecipeType = this.recipeTypes.register("bargain", () -> RecipeType.simple((ResourceLocation)ParagliderAPI.id("bargain")));
    public final DeferredHolder<MapCodec<? extends IGlobalLootModifier>, MapCodec<ParagliderLoot>> paragliderLoot = this.loots.register("paraglider", () -> ParagliderLoot.CODEC);
    public final DeferredHolder<MapCodec<? extends IGlobalLootModifier>, MapCodec<SpiritOrbLoot>> spiritOrbLoot = this.loots.register("spirit_orb", () -> SpiritOrbLoot.CODEC);
    public final DeferredHolder<MapCodec<? extends IGlobalLootModifier>, MapCodec<VesselLoot>> vesselLoot = this.loots.register("vessel", () -> VesselLoot.CODEC);
    public final DeferredHolder<MapCodec<? extends IGlobalLootModifier>, MapCodec<ConfigurableSpiritOrbLoot>> configurableSpiritOrbLoot = this.loots.register("configurable_spirit_orb", () -> ConfigurableSpiritOrbLoot.CODEC);
    public final DeferredHolder<MobEffect, MobEffect> staminaEfficiencyEffect = this.mobEffects.register("stamina_efficiency", StaminaEfficiencyMobEffect::new);
    public final DeferredHolder<StructureType<?>, StructureType<TarreyTownGoddessStatue>> tarreyTownGoddessStatue = this.structureType("tarrey_town_goddess_statue", TarreyTownGoddessStatue.CODEC);
    public final DeferredHolder<StructureType<?>, StructureType<NetherHornedStatue>> netherHornedStatue = this.structureType("nether_horned_statue", NetherHornedStatue.CODEC);
    public final DeferredHolder<StructureType<?>, StructureType<UndergroundHornedStatue>> undergroundHornedStatue = this.structureType("underground_horned_statue", UndergroundHornedStatue.CODEC);
    public final DeferredHolder<StructurePieceType, StructurePieceType> tarreyTownGoddessStatuePiece = this.pieces.register("tarrey_town_goddess_statue", TarreyTownGoddessStatue::pieceType);
    public final DeferredHolder<StructurePieceType, StructurePieceType> netherHornedStatuePiece = this.pieces.register("nether_horned_statue", NetherHornedStatue::pieceType);
    public final DeferredHolder<StructurePieceType, StructurePieceType> undergroundHornedStatuePiece = this.pieces.register("underground_horned_statue", UndergroundHornedStatue::pieceType);
    public final DeferredHolder<CreativeModeTab, CreativeModeTab> tab = this.creativeTabs.register("paraglider", () -> CreativeModeTab.builder().icon(() -> new ItemStack((ItemLike)this.paraglider.get())).title((Component)Component.translatable((String)"itemGroup.paraglider")).displayItems((features, out) -> {
        out.accept((ItemLike)this.paraglider());
        out.accept((ItemLike)this.dekuLeaf());
        out.accept((ItemLike)this.heartContainer());
        out.accept((ItemLike)this.staminaVessel());
        out.accept((ItemLike)this.spiritOrb());
        out.accept((ItemLike)this.antiVessel());
        out.accept((ItemLike)this.essence());
        out.accept((ItemLike)this.energizingElixir1());
        out.accept((ItemLike)this.energizingElixir2());
        out.accept((ItemLike)this.energizingElixir3());
        out.accept((ItemLike)this.enduringElixir1());
        out.accept((ItemLike)this.enduringElixir2());
        out.accept((ItemLike)this.enduringElixir3());
        out.accept((ItemLike)this.energizingMixture());
        out.accept((ItemLike)this.enduringMixture());
        out.accept((ItemLike)this.goddessStatue());
        out.accept((ItemLike)this.kakarikoGoddessStatue());
        out.accept((ItemLike)this.goronGoddessStatue());
        out.accept((ItemLike)this.ritoGoddessStatue());
        out.accept((ItemLike)this.hornedStatue());
    }).build());
    public final DeferredHolder<AttachmentType<?>, AttachmentType<PlayerMovement>> playerMovement = this.attachmentTypes.register("player_movement", () -> AttachmentType.builder(h -> {
        if (h instanceof Player) {
            Player p = (Player)h;
            return AttachmentProvider.createPlayerMovement(p);
        }
        throw new IllegalArgumentException("Cannot create player movement data attachment for non-player holder");
    }).build());
    public final DeferredHolder<AttachmentType<?>, AttachmentType<BotWStaminaData>> botwStaminaData = this.attachmentTypes.register("botw_stamina", () -> AttachmentType.builder(h -> new BotWStaminaData()).serialize(BotWStaminaData.CODEC).build());
    public final DeferredHolder<AttachmentType<?>, AttachmentType<SimpleVesselContainer>> vesselContainer = this.attachmentTypes.register("vessel_container", () -> AttachmentType.builder(h -> new SimpleVesselContainer()).serialize(SimpleVesselContainer.CODEC).copyOnDeath().build());
    public final DeferredHolder<AttachmentType<?>, AttachmentType<MovementState>> movementState = this.attachmentTypes.register("movement_state", () -> AttachmentType.builder(h -> new MovementState()).serialize(MovementState.CODEC).build());
    public final DeferredHolder<AttachmentType<?>, AttachmentType<Boolean>> movementInitialized = this.attachmentTypes.register("movement_init", () -> AttachmentType.builder(h -> false).serialize((Codec)Codec.BOOL).build());
    public final DeferredHolder<IngredientType<?>, IngredientType<?>> waterBottle = this.ingredientTypes.register("water_bottle", WaterBottleIngredientType.INSTANCE::getType);
    public final DeferredHolder<BargainPreview.Type<?>, BargainPreview.Type<ItemPreview>> itemPreviewType = this.bargainPreviewTypes.register("item", () -> ItemPreview.TYPE);
    public final DeferredHolder<BargainPreview.Type<?>, BargainPreview.Type<IngredientPreview>> ingredientPreviewType = this.bargainPreviewTypes.register("ingredient", () -> IngredientPreview.TYPE);
    public final DeferredHolder<BargainPreview.Type<?>, BargainPreview.Type<VesselPreview>> vesselPreviewType = this.bargainPreviewTypes.register("vessel", () -> VesselPreview.TYPE);

    @NotNull
    public static Contents get() {
        return ParagliderMod.instance().getContents();
    }

    private <T extends Structure> DeferredHolder<StructureType<?>, StructureType<T>> structureType(String id, MapCodec<T> codec) {
        return this.structureTypes.register(id, () -> () -> codec);
    }

    public Contents(IEventBus eventBus) {
        this.blocks.register(eventBus);
        this.items.register(eventBus);
        this.attributes.register(eventBus);
        this.dataComponents.register(eventBus);
        this.loots.register(eventBus);
        this.lootConditions.register(eventBus);
        this.mobEffects.register(eventBus);
        this.recipeSerializers.register(eventBus);
        this.recipeTypes.register(eventBus);
        this.structureTypes.register(eventBus);
        this.pieces.register(eventBus);
        this.creativeTabs.register(eventBus);
        this.attachmentTypes.register(eventBus);
        this.conditionSerializers.register(eventBus);
        this.ingredientTypes.register(eventBus);
        this.bargainPreviewTypes.register(eventBus);
        ParagliderLootConditions.register(this.lootConditions);
        ParagliderConfigCondition.register(this.conditionSerializers);
    }

    @NotNull
    public Item paraglider() {
        return (Item)this.paraglider.get();
    }

    @NotNull
    public Item dekuLeaf() {
        return (Item)this.dekuLeaf.get();
    }

    @NotNull
    public Item heartContainer() {
        return (Item)this.heartContainer.get();
    }

    @NotNull
    public Item staminaVessel() {
        return (Item)this.staminaVessel.get();
    }

    @NotNull
    public Item spiritOrb() {
        return (Item)this.spiritOrb.get();
    }

    @NotNull
    public Item antiVessel() {
        return (Item)this.antiVessel.get();
    }

    @NotNull
    public Item essence() {
        return (Item)this.essence.get();
    }

    @NotNull
    public Item energizingElixir1() {
        return (Item)this.energizingElixir1.get();
    }

    @NotNull
    public Item energizingElixir2() {
        return (Item)this.energizingElixir2.get();
    }

    @NotNull
    public Item energizingElixir3() {
        return (Item)this.energizingElixir3.get();
    }

    @NotNull
    public Item enduringElixir1() {
        return (Item)this.enduringElixir1.get();
    }

    @NotNull
    public Item enduringElixir2() {
        return (Item)this.enduringElixir2.get();
    }

    @NotNull
    public Item enduringElixir3() {
        return (Item)this.enduringElixir3.get();
    }

    @NotNull
    public Item energizingMixture() {
        return (Item)this.energizingMixture.get();
    }

    @NotNull
    public Item enduringMixture() {
        return (Item)this.enduringMixture.get();
    }

    @NotNull
    public Block goddessStatue() {
        return (Block)this.goddessStatue.get();
    }

    @NotNull
    public Block kakarikoGoddessStatue() {
        return (Block)this.kakarikoGoddessStatue.get();
    }

    @NotNull
    public Block goronGoddessStatue() {
        return (Block)this.goronGoddessStatue.get();
    }

    @NotNull
    public Block ritoGoddessStatue() {
        return (Block)this.ritoGoddessStatue.get();
    }

    @NotNull
    public Block hornedStatue() {
        return (Block)this.hornedStatue.get();
    }

    @NotNull
    public BlockItem goddessStatueItem() {
        return (BlockItem)this.goddessStatueItem.get();
    }

    @NotNull
    public BlockItem kakarikoGoddessStatueItem() {
        return (BlockItem)this.kakarikoGoddessStatueItem.get();
    }

    @NotNull
    public BlockItem goronGoddessStatueItem() {
        return (BlockItem)this.goronGoddessStatueItem.get();
    }

    @NotNull
    public BlockItem ritoGoddessStatueItem() {
        return (BlockItem)this.ritoGoddessStatueItem.get();
    }

    @NotNull
    public BlockItem hornedStatueItem() {
        return (BlockItem)this.hornedStatueItem.get();
    }

    @NotNull
    public Holder<Attribute> maxStamina() {
        return this.maxStamina;
    }

    @NotNull
    public Holder<Attribute> staminaEfficiency() {
        return this.staminaEfficiency;
    }

    @NotNull
    public Holder<Attribute> staminaRecovery() {
        return this.staminaRecovery;
    }

    @NotNull
    public Holder<Attribute> paraglidingStaminaEfficiency() {
        return this.paraglidingStaminaEfficiency;
    }

    @NotNull
    public Holder<Attribute> runningStaminaEfficiency() {
        return this.runningStaminaEfficiency;
    }

    @NotNull
    public Holder<Attribute> swimmingStaminaEfficiency() {
        return this.swimmingStaminaEfficiency;
    }

    @NotNull
    public DataComponentType<ParaglidingFlag> paraglidingFlagComponent() {
        return (DataComponentType)this.paraglidingFlagComponent.get();
    }

    @NotNull
    public CosmeticRecipe.Serializer cosmeticRecipeSerializer() {
        return (CosmeticRecipe.Serializer)this.cosmeticRecipe.get();
    }

    @NotNull
    public RecipeSerializer<SimpleBargain> bargainRecipeSerializer() {
        return (RecipeSerializer)this.bargainRecipe.get();
    }

    @NotNull
    public RecipeType<Bargain> bargainRecipeType() {
        return (RecipeType)this.bargainRecipeType.get();
    }

    @NotNull
    public StructureType<TarreyTownGoddessStatue> tarreyTownGoddessStatue() {
        return (StructureType)this.tarreyTownGoddessStatue.get();
    }

    @NotNull
    public StructureType<NetherHornedStatue> netherHornedStatue() {
        return (StructureType)this.netherHornedStatue.get();
    }

    @NotNull
    public StructureType<UndergroundHornedStatue> undergroundHornedStatue() {
        return (StructureType)this.undergroundHornedStatue.get();
    }

    @NotNull
    public StructurePieceType tarreyTownGoddessStatuePiece() {
        return (StructurePieceType)this.tarreyTownGoddessStatuePiece.get();
    }

    @NotNull
    public StructurePieceType netherHornedStatuePiece() {
        return (StructurePieceType)this.netherHornedStatuePiece.get();
    }

    @NotNull
    public StructurePieceType undergroundHornedStatuePiece() {
        return (StructurePieceType)this.undergroundHornedStatuePiece.get();
    }

    @NotNull
    public AttachmentType<PlayerMovement> playerMovement() {
        return (AttachmentType)this.playerMovement.get();
    }

    @NotNull
    public AttachmentType<BotWStaminaData> botwStaminaData() {
        return (AttachmentType)this.botwStaminaData.get();
    }

    @NotNull
    public AttachmentType<SimpleVesselContainer> vesselContainer() {
        return (AttachmentType)this.vesselContainer.get();
    }

    @NotNull
    public AttachmentType<MovementState> movementState() {
        return (AttachmentType)this.movementState.get();
    }

    @NotNull
    public AttachmentType<Boolean> movementInitialized() {
        return (AttachmentType)this.movementInitialized.get();
    }
}

