/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.config;

import net.neoforged.neoforge.common.ModConfigSpec;
import tictim.paraglider.config.DebugCfg;
import tictim.paraglider.config.FeatureCfg;

public class CommonConfig
implements FeatureCfg,
DebugCfg {
    public final ModConfigSpec spec;
    private final ModConfigSpec.BooleanValue enableSpiritOrbGens;
    private final ModConfigSpec.BooleanValue enableHeartContainers;
    private final ModConfigSpec.BooleanValue enableStaminaVessels;
    private final ModConfigSpec.BooleanValue enableVillageStructures;
    private final ModConfigSpec.BooleanValue debugPlayerMovement;
    private final ModConfigSpec.BooleanValue traceMovementPacket;
    private final ModConfigSpec.BooleanValue traceVesselPacket;
    private final ModConfigSpec.BooleanValue traceBargainPacket;
    private final ModConfigSpec.BooleanValue traceWindPacket;
    private final ModConfigSpec.BooleanValue verboseWindSourceLoading;

    public CommonConfig() {
        ModConfigSpec.Builder b = new ModConfigSpec.Builder();
        b.comment("Easy to access switches to toggle side features on and off.\nMost of them requires server restart or datapack reload. All of them, actually.").push("features");
        this.enableSpiritOrbGens = b.comment("For those who wants to remove Spirit Orbs generated in the world, more specifically...\n  * Spirit Orbs generated in various chests\n  * Spirit Orbs dropped by spawners and such\nNote that bargain recipe for Heart Containers/Stamina Vessels will persist, even if this option is disabled.").define("spiritOrbGens", true);
        this.enableHeartContainers = b.comment("For those who wants to remove entirety of Heart Containers from the game, more specifically...\n  * Heart Containers obtained by \"challenges\" (i.e. Killing dragon, wither, raid)\n  * Bargains using Heart Containers (custom recipes won't be affected)\nNote that if this option is disabled while staminaVessels is enabled, \"challenges\" will drop Stamina Vessels instead.").define("heartContainers", true);
        this.enableStaminaVessels = b.comment("For those who wants to remove entirety of Stamina Vessels from the game, more specifically...\n  * Bargains using Stamina Vessels (custom recipes won't be affected)").define("staminaVessels", true);
        this.enableVillageStructures = b.comment("For those who wants to remove village structures added by this mod. Requires datapack reload.\nNote that the structures generated in other places are NOT disabled by this option, and requires a datapack to remove.").define("villageStructures", true);
        b.pop();
        b.push("debug");
        this.debugPlayerMovement = b.define("debugPlayerMovement", false);
        this.traceMovementPacket = b.define("traceMovementPacket", false);
        this.traceVesselPacket = b.define("traceVesselPacket", false);
        this.traceBargainPacket = b.define("traceBargainPacket", false);
        this.traceWindPacket = b.define("traceWindPacket", false);
        this.verboseWindSourceLoading = b.define("verboseWindSourceLoading", false);
        b.pop();
        this.spec = b.build();
    }

    @Override
    public boolean enableSpiritOrbGens() {
        return (Boolean)this.enableSpiritOrbGens.get();
    }

    @Override
    public boolean enableHeartContainers() {
        return (Boolean)this.enableHeartContainers.get();
    }

    @Override
    public boolean enableStaminaVessels() {
        return (Boolean)this.enableStaminaVessels.get();
    }

    @Override
    public boolean enableVillageStructures() {
        return (Boolean)this.enableVillageStructures.get();
    }

    @Override
    public boolean debugPlayerMovement() {
        return (Boolean)this.debugPlayerMovement.get();
    }

    @Override
    public boolean traceMovementPacket() {
        return (Boolean)this.traceMovementPacket.get();
    }

    @Override
    public boolean traceVesselPacket() {
        return (Boolean)this.traceVesselPacket.get();
    }

    @Override
    public boolean traceBargainPacket() {
        return (Boolean)this.traceBargainPacket.get();
    }

    @Override
    public boolean traceWindPacket() {
        return (Boolean)this.traceWindPacket.get();
    }

    @Override
    public boolean verboseWindSourceLoading() {
        return (Boolean)this.verboseWindSourceLoading.get();
    }
}

