/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.config;

import org.jetbrains.annotations.NotNull;
import tictim.paraglider.ParagliderMod;

public interface Cfg {
    @NotNull
    public static Cfg get() {
        return ParagliderMod.instance().getConfig();
    }

    public boolean updraft();

    public double paraglidingSpeed();

    public int paragliderDurability();

    public boolean enderDragonDropsVessel();

    public boolean witherDropsVessel();

    public boolean raidGivesVessel();

    public boolean elderGuardianDropsSpiritOrb();

    public double spawnerSpiritOrbDrops();

    public double trialSpiritOrbDrops();

    public double ominousTrialSpiritOrbDrops();

    public boolean spiritOrbLoots();

    public int startingHearts();

    public int maxHeartContainers();

    public int startingStamina();

    public int maxStaminaVessels();

    public int staminaIncreasePerVessel();

    public boolean paraglidingConsumesStamina();

    public boolean runningConsumesStamina();

    @NotNull
    public TotwCompatConfigOption paragliderInTowersOfTheWild();

    default public int additionalMaxHealth(int heartContainers) {
        return (this.startingHearts() - 10 + Math.min(this.maxHeartContainers(), heartContainers)) * 2;
    }

    default public int maxStamina(int staminaVessels) {
        return Math.max(0, this.startingStamina() + Math.max(0, Math.min(staminaVessels, this.maxStaminaVessels())) * this.staminaIncreasePerVessel());
    }

    public static enum TotwCompatConfigOption {
        DEFAULT,
        DISABLE,
        PARAGLIDER_ONLY,
        DEKU_LEAF_ONLY;

    }
}

