/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.client.settings;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.minecraft.util.StringRepresentable;
import org.jetbrains.annotations.NotNull;

public sealed interface StaminaWheelPosition {
    public static final StaminaWheelPosition DEFAULT = new ScreenProportion(0.382903981264637, 0.46875);

    public double x(double var1);

    public double y(double var1);

    public record ScreenProportion(double x, double y) implements StaminaWheelPosition
    {
        public static final MapCodec<ScreenProportion> CODEC = RecordCodecBuilder.mapCodec(b -> b.group((App)Codec.DOUBLE.fieldOf("x").forGetter(ScreenProportion::x), (App)Codec.DOUBLE.fieldOf("y").forGetter(ScreenProportion::y)).apply((Applicative)b, ScreenProportion::new));

        @Override
        public double x(double width) {
            return width * this.x;
        }

        @Override
        public double y(double height) {
            return height * this.y;
        }
    }

    public static enum Dir8 implements StringRepresentable
    {
        U,
        UR,
        R,
        DR,
        D,
        DL,
        L,
        UL;

        private final String serializedName = this.name().toLowerCase(Locale.ROOT);

        public double anchorX(double width) {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 5, 6, 7 -> 0.0;
                case 0, 4 -> width / 2.0;
                case 1, 2, 3 -> width;
            };
        }

        public double anchorY(double height) {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0, 1, 7 -> 0.0;
                case 2, 6 -> height / 2.0;
                case 3, 4, 5 -> height;
            };
        }

        @NotNull
        public String getSerializedName() {
            return this.serializedName;
        }
    }

    public record Anchored(Dir8 anchor, double x, double y) implements StaminaWheelPosition
    {
        public static final MapCodec<Anchored> CODEC = RecordCodecBuilder.mapCodec(b -> b.group((App)StringRepresentable.fromValues(Dir8::values).fieldOf("anchor").forGetter(Anchored::anchor), (App)Codec.DOUBLE.fieldOf("x").forGetter(Anchored::x), (App)Codec.DOUBLE.fieldOf("y").forGetter(Anchored::y)).apply((Applicative)b, Anchored::new));

        @Override
        public double x(double width) {
            return this.anchor.anchorX(width) + this.x;
        }

        @Override
        public double y(double height) {
            return this.anchor.anchorY(height) + this.y;
        }
    }
}

