/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.client.screen;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tictim.paraglider.ParagliderUtils;
import tictim.paraglider.api.bargain.BargainPreview;
import tictim.paraglider.bargain.BargainCatalog;
import tictim.paraglider.client.render.BargainScreenStaminaWheelRenderer;
import tictim.paraglider.client.screen.DisableStaminaRender;
import tictim.paraglider.client.settings.ExtraWheelAttachment;
import tictim.paraglider.network.ParagliderNetwork;

public class BargainScreen
extends Screen
implements DisableStaminaRender {
    private static final ResourceLocation MERCHANT_GUI_TEXTURE = ResourceLocation.withDefaultNamespace((String)"textures/gui/container/villager.png");
    private static final ResourceLocation SCROLLER_SPRITE = ResourceLocation.withDefaultNamespace((String)"container/villager/scroller");
    private static final ResourceLocation SCROLLER_DISABLED_SPRITE = ResourceLocation.withDefaultNamespace((String)"container/villager/scroller_disabled");
    private static final ResourceLocation TRADE_ARROW_OUT_OF_STOCK_SPRITE = ResourceLocation.withDefaultNamespace((String)"container/villager/trade_arrow_out_of_stock");
    private static final ResourceLocation TRADE_ARROW_SPRITE = ResourceLocation.withDefaultNamespace((String)"container/villager/trade_arrow");
    private static final long ITEM_CYCLE_TIME = 1000L;
    private static final long DIALOG_FADEOUT_START = 1750L;
    private static final long DIALOG_FADEOUT_END = 2000L;
    private static final int SCROLL_BOX_THING_WIDTH = 97;
    private static final int SCROLL_BOX_THING_HEIGHT = 142;
    public final int sessionId;
    private final BargainButton[] buttons = new BargainButton[7];
    @NotNull
    private BargainCatalog[] catalogs = new BargainCatalog[0];
    @Nullable
    private List<List<ItemStack>>[] catalogDemandPreviews = new List[0];
    @Nullable
    private List<List<ItemStack>>[] catalogOfferPreviews = new List[0];
    private int buttonIndexOffset;
    private boolean isDragging;
    private long createdTime;
    private long currentTickTimestamp;
    @Nullable
    private Vec3 lookAt;
    @Nullable
    private Component dialog;
    private long dialogTimestamp;
    private boolean dialogUpdated;
    private BargainScreenStaminaWheelRenderer staminaWheelRenderer;
    private static final int BUTTON_INPUT_X_OFFSET_START = 2;
    private static final int BUTTON_INPUT_X_OFFSET_END = 22;
    private static final int BUTTON_OUTPUT_X_OFFSET_START = 50;
    private static final int BUTTON_OUTPUT_X_OFFSET_END = 70;

    public static int getDialogAlpha(long elapsedTime) {
        if (elapsedTime >= 2000L) {
            return 0;
        }
        if (elapsedTime <= 1750L) {
            return 255;
        }
        int alpha = Mth.clamp((int)((int)((2000L - elapsedTime) * 255L / 250L)), (int)0, (int)255);
        return alpha > 4 ? alpha : 0;
    }

    public BargainScreen(int sessionId, @NotNull @NotNull List<@NotNull BargainCatalog> catalog, @Nullable Vec3 lookAt, @Nullable Component dialog) {
        super((Component)Component.empty());
        this.sessionId = sessionId;
        this.setCatalog(catalog);
        this.setLookAt(lookAt);
        this.setDialog(dialog);
    }

    public void setCatalog(@NotNull @NotNull List<@NotNull BargainCatalog> catalog) {
        this.catalogs = catalog.toArray(new BargainCatalog[0]);
        this.catalogDemandPreviews = new List[catalog.size()];
        this.catalogOfferPreviews = new List[catalog.size()];
        Arrays.sort(this.catalogs, Comparator.comparing(BargainCatalog::bargain));
    }

    public void setLookAt(@Nullable Vec3 lookAt) {
        this.lookAt = lookAt;
    }

    public void setDialog(@Nullable Component dialog) {
        this.dialog = dialog;
        this.dialogUpdated = dialog != null;
    }

    protected void init() {
        this.currentTickTimestamp = this.createdTime = ParagliderUtils.ms();
        this.staminaWheelRenderer = new BargainScreenStaminaWheelRenderer();
        super.init();
        int y = this.getTop() + 1;
        for (int i = 0; i < 7; ++i) {
            this.buttons[i] = (BargainButton)this.addRenderableWidget((GuiEventListener)new BargainButton(this, 31, y + 20 * i, i));
        }
    }

    public int getLeft() {
        return 30;
    }

    public int getTop() {
        return (this.height - 142) / 2;
    }

    public int getBottom() {
        return this.getTop() + 142;
    }

    private void renderScroller(GuiGraphics guiGraphics, int left, int top) {
        int offScreenBargains = this.catalogs.length + 1 - 7;
        if (offScreenBargains > 1) {
            int j = 139 - (27 + (offScreenBargains - 1) * 139 / offScreenBargains);
            int k = 1 + j / offScreenBargains + 139 / offScreenBargains;
            int yOffset = Math.min(113, this.buttonIndexOffset * k);
            if (this.buttonIndexOffset == offScreenBargains - 1) {
                yOffset = 113;
            }
            guiGraphics.blitSprite(SCROLLER_SPRITE, left + 90, top + 1 + yOffset, 6, 27);
        } else {
            guiGraphics.blitSprite(SCROLLER_DISABLED_SPRITE, left + 90, top + 1, 6, 27);
        }
    }

    public void tick() {
        this.staminaWheelRenderer.tick();
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        long newTimestamp = ParagliderUtils.ms();
        if (BargainScreen.hasShiftDown()) {
            this.createdTime += newTimestamp - this.currentTickTimestamp;
        }
        this.currentTickTimestamp = newTimestamp;
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        if (this.catalogs.length > 0) {
            this.renderScroller(guiGraphics, this.getLeft(), this.getTop());
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate(0.0f, 0.0f, 100.0f);
            for (BargainButton button : this.buttons) {
                button.renderItems(guiGraphics);
            }
            guiGraphics.pose().popPose();
            for (BargainButton button : this.buttons) {
                if (button.isHovered()) {
                    this.renderPreview(guiGraphics, button.actualIndex());
                }
                button.visible = button.index < this.catalogs.length;
            }
        }
        for (BargainButton button : this.buttons) {
            button.renderToolTip(guiGraphics, mouseX, mouseY);
        }
        this.processLookAt(partialTicks);
    }

    public void renderBackground(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        guiGraphics.blit(MERCHANT_GUI_TEXTURE, this.getLeft(), this.getTop(), 4.0f, 17.0f, 97, 142, 512, 256);
        if (ParagliderUtils.renderStaminaWheel((Player)Objects.requireNonNull(this.minecraft).player)) {
            this.staminaWheelRenderer.render(guiGraphics, (float)(this.getLeft() + 97 + 5), (float)(this.getTop() - 5 - 10), 0.0f, partialTick, ExtraWheelAttachment.LEFT);
        }
        if (this.dialog != null) {
            int alpha;
            if (this.dialogUpdated) {
                this.dialogTimestamp = this.currentTickTimestamp;
                this.dialogUpdated = false;
            }
            if ((alpha = BargainScreen.getDialogAlpha(this.currentTickTimestamp - this.dialogTimestamp)) > 0) {
                guiGraphics.drawCenteredString(this.font, this.dialog, this.width / 2, this.getBottom() + 9, alpha << 24 | 0xFFFFFF);
            }
        }
    }

    @Nullable
    private BargainCatalog getBargainCatalog(int bargainIndex) {
        return bargainIndex < 0 || bargainIndex >= this.catalogs.length ? null : this.catalogs[bargainIndex];
    }

    @NotNull
    private List<List<ItemStack>> demandPreviewItem(int bargainIndex) {
        if (bargainIndex < 0 || bargainIndex >= this.catalogs.length) {
            return List.of();
        }
        BargainCatalog catalog = this.getBargainCatalog(bargainIndex);
        if (catalog == null) {
            return List.of();
        }
        List<List<ItemStack>> ret = this.catalogDemandPreviews[bargainIndex];
        if (ret == null) {
            this.catalogDemandPreviews[bargainIndex] = ret = catalog.demands().stream().map(BargainPreview::display).toList();
        }
        return ret;
    }

    @NotNull
    private List<List<ItemStack>> offerPreviewItem(int bargainIndex) {
        if (bargainIndex < 0 || bargainIndex >= this.catalogs.length) {
            return List.of();
        }
        BargainCatalog catalog = this.getBargainCatalog(bargainIndex);
        if (catalog == null) {
            return List.of();
        }
        List<List<ItemStack>> ret = this.catalogOfferPreviews[bargainIndex];
        if (ret == null) {
            this.catalogOfferPreviews[bargainIndex] = ret = catalog.offers().stream().map(BargainPreview::display).toList();
        }
        return ret;
    }

    private void renderPreview(GuiGraphics guiGraphics, int bargainIndex) {
        int textMag;
        BargainCatalog catalog = this.getBargainCatalog(bargainIndex);
        if (catalog == null) {
            return;
        }
        List<BargainPreview<?>> demands = catalog.demands();
        if (demands.isEmpty()) {
            return;
        }
        List<List<ItemStack>> demandPreviewItem = this.demandPreviewItem(bargainIndex);
        int mag = demands.size() <= 2 ? 8 : (demands.size() <= 8 ? 4 : 2);
        int n = textMag = demands.size() <= 8 ? 2 : 1;
        int rows = demands.size() <= 2 ? 2 : (demands.size() <= 8 ? 4 : 8);
        int left = this.getLeft() + 97 + 20;
        int top = this.getTop();
        for (int i = 0; i < demands.size(); ++i) {
            BargainPreview<?> demand = demands.get(i);
            int xOff = left + i % rows * (16 * mag);
            int yOff = top + i / rows * (16 * mag);
            PoseStack pose = guiGraphics.pose();
            pose.pushPose();
            pose.translate((float)xOff, (float)yOff, 0.0f);
            pose.pushPose();
            pose.scale((float)mag, (float)mag, 1.0f);
            guiGraphics.renderFakeItem(this.cycle(demandPreviewItem.get(i)), 0, 0);
            pose.popPose();
            int count = catalog.getCount(i);
            String s = String.valueOf(count >= demand.quantity() ? Integer.valueOf(count) : String.valueOf(ChatFormatting.RED) + count + String.valueOf(ChatFormatting.RESET)) + "/" + demand.quantity();
            pose.translate((float)(15 * mag + 2 * textMag), (float)(16 * mag - 7 * textMag), 200.0f);
            pose.scale((float)textMag, (float)textMag, 1.0f);
            this.font.drawInBatch(s, (float)(-this.font.width(s)), 0.0f, -1, true, pose.last().pose(), (MultiBufferSource)guiGraphics.bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
            pose.popPose();
        }
    }

    private void processLookAt(float partialTicks) {
        if (this.lookAt == null) {
            return;
        }
        LocalPlayer player = this.minecraft.player;
        Vec3 eyePosition = player.getEyePosition(partialTicks);
        double lookX = this.lookAt.x() - eyePosition.x;
        double lookY = this.lookAt.y() - eyePosition.y;
        double lookZ = this.lookAt.z() - eyePosition.z;
        double xzLength = Math.sqrt(lookX * lookX + lookZ * lookZ);
        double rotationPitch = Mth.wrapDegrees((float)((float)(-Mth.atan2((double)lookY, (double)xzLength) * 57.29577951308232)));
        double rotationYaw = Mth.wrapDegrees((float)((float)(Mth.atan2((double)lookZ, (double)lookX) * 57.29577951308232) - 90.0f));
        double lerpPercentage = (double)partialTicks * 0.3;
        player.setXRot(BargainScreen.lerpAngle(lerpPercentage, Mth.wrapDegrees((float)player.getXRot()), rotationPitch));
        player.setYRot(BargainScreen.lerpAngle(lerpPercentage, Mth.wrapDegrees((float)player.getYRot()), rotationYaw));
        player.setYHeadRot(player.getYRot());
        player.xRotO = player.getXRot();
        player.yRotO = player.getYRot();
        player.yHeadRotO = player.yHeadRot;
        player.yBodyRotO = player.yBodyRot = player.yHeadRot;
    }

    private static float lerpAngle(double percentage, double start, double end) {
        return (float)Mth.lerp((double)percentage, (double)(start < end ? (end - start > 180.0 ? start + 360.0 : start) : (start - end > 180.0 ? start - 360.0 : start)), (double)end);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        int bargainSize;
        if (!super.mouseScrolled(mouseX, mouseY, scrollX, scrollY) && (bargainSize = this.catalogs.length) > 7) {
            this.buttonIndexOffset = Mth.clamp((int)((int)((double)this.buttonIndexOffset - scrollY)), (int)0, (int)(bargainSize - 7));
        }
        return true;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (!this.isDragging) {
            return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
        }
        int offScreenBargains = this.catalogs.length - 7;
        this.buttonIndexOffset = Mth.clamp((int)((int)((mouseY - (double)this.getTop() + 1.0 - 13.5) / 112.0 * (double)offScreenBargains + 0.5)), (int)0, (int)offScreenBargains);
        return true;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.isDragging = false;
        int left = this.getLeft();
        int top = this.getTop();
        if (this.catalogs.length > 7 && mouseX > (double)(left + 90) && mouseX < (double)(left + 90 + 6) && mouseY > (double)(top + 1) && mouseY <= (double)(top + 1 + 139 + 1)) {
            this.isDragging = true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (super.keyPressed(keyCode, scanCode, modifiers) || this.minecraft == null) {
            return true;
        }
        InputConstants.Key key = InputConstants.getKey((int)keyCode, (int)scanCode);
        if (this.minecraft.options.keyInventory.isActiveAndMatches(key)) {
            this.onClose();
            return true;
        }
        return false;
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void onClose() {
        ParagliderNetwork.get().bargainEndToServer(this.sessionId);
        super.onClose();
    }

    @NotNull
    private ItemStack cycle(@NotNull List<ItemStack> stacks) {
        int i = this.cycleIndex(stacks.size());
        return i < 0 || i >= stacks.size() ? ItemStack.EMPTY : stacks.get(i);
    }

    private int cycleIndex(int counts) {
        if (counts <= 0) {
            return -1;
        }
        return (int)(Math.abs(this.currentTickTimestamp - this.createdTime) / 1000L % (long)counts);
    }

    private static int determineItemPosition(int n, int length, int start, int end) {
        if (n >= length) {
            throw new IllegalArgumentException("length");
        }
        if (end < start) {
            throw new IllegalArgumentException("end < start");
        }
        if (length == 1) {
            return (start + end) / 2;
        }
        int span = end - start;
        int spanPerElement = Math.min(16, span / (length - 1));
        if (spanPerElement == 0) {
            return start - (length - 1 - span) / 2 + n;
        }
        int leftover = span % spanPerElement;
        return start + leftover / 2 + spanPerElement * n;
    }

    private static final class BargainButton
    extends AbstractButton {
        private final BargainScreen screen;
        private final int index;
        @Nullable
        private ItemStack fallbackIcon;

        public BargainButton(BargainScreen screen, int x, int y, int index) {
            super(x, y, 89, 20, (Component)Component.empty());
            this.screen = screen;
            this.index = index;
            this.visible = false;
        }

        public void onPress() {
            BargainCatalog catalog = this.catalog();
            if (catalog != null) {
                ParagliderNetwork.get().bargain(this.screen.sessionId, catalog.bargain());
            }
        }

        public int actualIndex() {
            return this.index + this.screen.buttonIndexOffset;
        }

        @Nullable
        public BargainCatalog catalog() {
            return this.screen.getBargainCatalog(this.actualIndex());
        }

        protected void renderWidget(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
            super.renderWidget(guiGraphics, mouseX, mouseY, partialTicks);
            this.renderTradeArrow(guiGraphics);
        }

        private void renderTradeArrow(GuiGraphics guiGraphics) {
            BargainCatalog catalog = this.catalog();
            guiGraphics.blitSprite(catalog == null || catalog.canBargain() ? TRADE_ARROW_SPRITE : TRADE_ARROW_OUT_OF_STOCK_SPRITE, this.getX() + 39, this.getY() + 5, 10, 9);
        }

        public int getFGColor() {
            BargainCatalog catalog = this.catalog();
            return catalog != null && catalog.canBargain() ? 0xFFFFFF : 0xA0A0A0;
        }

        public void renderString(@NotNull GuiGraphics guiGraphics, @NotNull Font font, int color) {
        }

        private ItemStack fallbackIcon() {
            if (this.fallbackIcon != null) {
                return this.fallbackIcon;
            }
            this.fallbackIcon = new ItemStack((ItemLike)Items.BARRIER);
            return this.fallbackIcon;
        }

        private void renderItems(GuiGraphics guiGraphics) {
            if (!this.visible) {
                return;
            }
            BargainCatalog catalog = this.catalog();
            if (catalog == null) {
                return;
            }
            List<BargainPreview<?>> demands = catalog.demands();
            List<List<ItemStack>> demandItems = this.screen.demandPreviewItem(this.actualIndex());
            for (int i = demands.size() - 1; i >= 0; --i) {
                this.renderPreviewItem(guiGraphics, demandItems.get(i), demands.get(i).quantity(), this.getX() + BargainScreen.determineItemPosition(i, demands.size(), 2, 22), this.getY() + 2);
            }
            List<BargainPreview<?>> offers = catalog.offers();
            List<List<ItemStack>> offerItems = this.screen.offerPreviewItem(this.actualIndex());
            for (int i = offers.size() - 1; i >= 0; --i) {
                this.renderPreviewItem(guiGraphics, offerItems.get(i), offers.get(i).quantity(), this.getX() + BargainScreen.determineItemPosition(i, offers.size(), 50, 70), this.getY() + 2);
            }
        }

        private void renderPreviewItem(GuiGraphics guiGraphics, List<ItemStack> stacks, int quantity, int x, int y) {
            ItemStack stack;
            if (stacks.isEmpty()) {
                stack = this.fallbackIcon();
            } else {
                stack = this.screen.cycle(stacks);
                if (stack.isEmpty()) {
                    stack = this.fallbackIcon();
                }
            }
            guiGraphics.renderFakeItem(stack, x, y);
            if (quantity != 1) {
                guiGraphics.renderItemDecorations(this.screen.font, stack, x, y, String.valueOf(quantity));
            }
        }

        private void renderToolTip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
            if (!this.isHovered) {
                return;
            }
            BargainCatalog catalog = this.catalog();
            if (catalog == null) {
                return;
            }
            if (this.renderTooltip0(guiGraphics, mouseX, mouseY, catalog, true)) {
                return;
            }
            this.renderTooltip0(guiGraphics, mouseX, mouseY, catalog, false);
        }

        private boolean renderTooltip0(GuiGraphics guiGraphics, int mouseX, int mouseY, BargainCatalog catalog, boolean demand) {
            List<BargainPreview<?>> list = demand ? catalog.demands() : catalog.offers();
            BargainPreview<?> closest = null;
            int closestIndex = -1;
            int closestDist = Integer.MAX_VALUE;
            for (int i = 0; i < list.size(); ++i) {
                int itemX = this.getX() + BargainScreen.determineItemPosition(i, list.size(), demand ? 2 : 50, demand ? 22 : 70);
                if (mouseX < itemX || mouseX >= itemX + 16) continue;
                int dist = Math.abs(itemX + 8 - mouseX);
                if (closestDist <= dist) break;
                closestDist = dist;
                closest = list.get(i);
                closestIndex = i;
            }
            if (closest == null) {
                return false;
            }
            List<@NotNull Object> tooltip = closest.getTooltip();
            if (tooltip == null) {
                List<List<ItemStack>> previewItems;
                List<List<ItemStack>> list2 = previewItems = demand ? this.screen.demandPreviewItem(this.actualIndex()) : this.screen.offerPreviewItem(this.actualIndex());
                if (closestIndex < previewItems.size()) {
                    List<ItemStack> items = previewItems.get(closestIndex);
                    int i = this.screen.cycleIndex(items.size());
                    tooltip = i < 0 || i >= items.size() ? List.of(Component.literal((String)"No Preview")) : Screen.getTooltipFromItem((Minecraft)Minecraft.getInstance(), (ItemStack)items.get(i));
                }
            }
            if (tooltip != null) {
                guiGraphics.renderComponentTooltip(this.screen.font, tooltip, mouseX, mouseY);
            }
            return true;
        }

        protected void updateWidgetNarration(@NotNull NarrationElementOutput o) {
        }
    }
}

