/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.client.render;

import net.minecraft.util.FastColor;

public final class StaminaWheelConstants {
    public static final int GLOW = FastColor.ARGB32.color((int)255, (int)255, (int)255);
    public static final int EVIL_GLOW = FastColor.ARGB32.color((int)248, (int)223, (int)223);
    public static final int DEPLETED_1 = FastColor.ARGB32.color((int)150, (int)2, (int)2);
    public static final int DEPLETED_2 = FastColor.ARGB32.color((int)255, (int)150, (int)2);
    public static final int EMPTY = FastColor.ARGB32.color((int)150, (int)2, (int)2, (int)2);
    public static final int EXTRA = -256;
    public static final long GLOW_FADE_START = 100L;
    public static final long GLOW_FADE_DURATION = 250L;
    public static final long GLOW_FADE_END = 350L;
    public static final long FADE_START = 1000L;
    public static final long FADE_DURATION = 100L;
    public static final long FADE_END = 1100L;
    public static final long BLINK = 300L;
    public static final long DEPLETED_BLINK = 600L;
    public static final long OUTER_WHEEL_FILL_DURATION = 250L;
    public static final long OUTER_WHEEL_EMPTY_DURATION = 250L;
    public static final int WHEEL_RADIUS = 10;
    public static final int EXTRA_WHEEL_RADIUS = 5;
    private static final int[] WHEEL_COLORS = new int[]{-16720045, -16751840, -8274945, -16755819, -32062, -8115112, -2116352, -10203392, -16721439, -16752283, -3237121, -10535796, -28080, -7851520};

    private StaminaWheelConstants() {
    }

    public static int wheelColor(int offset) {
        return WHEEL_COLORS[offset % (WHEEL_COLORS.length / 2) * 2];
    }

    public static int wheelBgColor(int offset) {
        return WHEEL_COLORS[offset % (WHEEL_COLORS.length / 2) * 2 + 1];
    }

    public static int getGlowAndFadeColor(long time, int baseColor) {
        if (time < 100L) {
            return GLOW;
        }
        if (time < 350L) {
            return FastColor.ARGB32.lerp((float)((float)(time - 100L) / 250.0f), (int)GLOW, (int)baseColor);
        }
        if (time < 1000L) {
            return baseColor;
        }
        if (time < 1100L) {
            return FastColor.ARGB32.lerp((float)((float)(time - 1000L) / 100.0f), (int)baseColor, (int)FastColor.ARGB32.color((int)0, (int)baseColor));
        }
        return 0;
    }

    public static int getGlowColor(long time, int baseColor) {
        if (time < 100L) {
            return GLOW;
        }
        if (time < 350L) {
            return FastColor.ARGB32.lerp((float)((float)(time - 100L) / 250.0f), (int)GLOW, (int)baseColor);
        }
        return baseColor;
    }

    public static int getFadeColor(long time, int baseColor) {
        if (time < 1000L) {
            return baseColor;
        }
        if (time < 1100L) {
            return FastColor.ARGB32.lerp((float)((float)(time - 1000L) / 100.0f), (int)baseColor, (int)FastColor.ARGB32.color((int)0, (int)baseColor));
        }
        return baseColor;
    }

    public static int getBlinkColor(long time, boolean depleted) {
        return FastColor.ARGB32.lerp((float)StaminaWheelConstants.cycle(time, depleted ? 600L : 300L), (int)DEPLETED_1, (int)DEPLETED_2);
    }

    public static float cycle(long currentTime, long cycleTime) {
        long halfCycle = cycleTime / 2L;
        return (float)Math.abs(currentTime % cycleTime - halfCycle) / (float)halfCycle;
    }

    public static float toWheelPos(double stamina) {
        return (float)(stamina / 1000.0);
    }
}

