/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.client.render;

import net.minecraft.util.FastColor;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import tictim.paraglider.ParagliderUtils;
import tictim.paraglider.api.movement.Movement;
import tictim.paraglider.api.stamina.Stamina;
import tictim.paraglider.client.render.EffectTimer;
import tictim.paraglider.client.render.StaminaWheelConstants;
import tictim.paraglider.client.render.StaminaWheelRenderer;

public class InGameStaminaWheelRenderer
extends StaminaWheelRenderer {
    private static final InGameStaminaWheelRenderer instance = new InGameStaminaWheelRenderer();
    private final EffectTimer fullAnim = new EffectTimer();
    private final EffectTimer outerWheelFillAnim = new EffectTimer(250L);
    private final EffectTimer outerWheelEmptyAnim = new EffectTimer(250L);
    private final EffectTimer recoverAnim = new EffectTimer(350L);
    private final EffectTimer gainExtraStaminaAnim = new EffectTimer(350L);
    private boolean prevDepleted;
    private int prevWheelIndex = -1;
    private double prevExtraStamina;

    public static InGameStaminaWheelRenderer get() {
        return instance;
    }

    public InGameStaminaWheelRenderer() {
        this.reset();
    }

    @Override
    protected void makeWheel(@NotNull Player player, float partialTicks) {
        boolean gainedExtraStamina;
        Stamina s = Stamina.get(player);
        double maxStamina = s.maxStamina();
        double stamina = s.stamina();
        double extraStamina = s.extraStamina();
        Movement movement = Movement.get(player);
        double staminaDelta = movement.staminaDelta();
        this.mainWheel.setProperties(stamina, maxStamina);
        this.extraWheel.setProperties(extraStamina, extraStamina);
        boolean full = stamina >= maxStamina;
        int wheelIndex = (int)Math.ceil(this.mainWheel.staminaWheelPos());
        boolean bl = gainedExtraStamina = !this.gainExtraStaminaAnim.isActive() && this.prevExtraStamina < extraStamina;
        this.fullAnim.update(full ? (gainedExtraStamina ? EffectTimer.UpdateMode.SET_ACTIVE : EffectTimer.UpdateMode.RETAIN_ACTIVE) : EffectTimer.UpdateMode.SET_INACTIVE);
        this.outerWheelFillAnim.update(full ? EffectTimer.UpdateMode.SET_INACTIVE : (this.prevWheelIndex < wheelIndex ? EffectTimer.UpdateMode.SET_ACTIVE : EffectTimer.UpdateMode.RETAIN));
        this.outerWheelEmptyAnim.update(full ? EffectTimer.UpdateMode.SET_INACTIVE : (this.prevWheelIndex > wheelIndex ? EffectTimer.UpdateMode.SET_ACTIVE : EffectTimer.UpdateMode.RETAIN));
        this.recoverAnim.update(full ? EffectTimer.UpdateMode.SET_INACTIVE : (this.prevDepleted && !s.isDepleted() ? EffectTimer.UpdateMode.SET_ACTIVE : EffectTimer.UpdateMode.RETAIN));
        this.gainExtraStaminaAnim.update(gainedExtraStamina ? EffectTimer.UpdateMode.SET_ACTIVE : EffectTimer.UpdateMode.RETAIN);
        this.prevWheelIndex = wheelIndex;
        this.prevDepleted = s.isDepleted();
        if (!this.gainExtraStaminaAnim.isActive()) {
            this.prevExtraStamina = extraStamina;
        }
        double staminaDeltaHighlightRemaining = 0.0;
        int blinkColor = 0;
        if (full) {
            color = this.fullAnim.getGlowAndFadeColor(StaminaWheelConstants.wheelColor(0));
            if (FastColor.ARGB32.alpha((int)color) <= 0) {
                return;
            }
            this.mainWheel.fillStamina(0.0, maxStamina, color);
            this.makeOuterWheel(this.mainWheel);
        } else {
            this.mainWheel.fillStamina(0.0, maxStamina, StaminaWheelConstants.EMPTY);
            if (s.isDepleted()) {
                this.mainWheel.fillStamina(0.0, stamina, this.recoverAnim.getGlowColor(StaminaWheelConstants.getBlinkColor(ParagliderUtils.ms(), true)));
            } else {
                this.mainWheel.fillStamina(0.0, stamina, this.recoverAnim.getGlowColor(StaminaWheelConstants.wheelColor(0)));
                this.makeOuterWheel(this.mainWheel);
                if (staminaDelta < 0.0) {
                    blinkColor = StaminaWheelConstants.getBlinkColor(ParagliderUtils.ms(), false);
                    color = this.recoverAnim.getGlowColor(blinkColor);
                    double staminaDeltaHighlightStart = stamina + staminaDelta * 10.0;
                    this.mainWheel.fillStamina(staminaDeltaHighlightStart, stamina, color);
                    if (staminaDeltaHighlightStart < 0.0) {
                        staminaDeltaHighlightRemaining = -staminaDeltaHighlightStart;
                    }
                    if (this.mainWheel.staminaWheelPos() > 3.0f) {
                        this.mainWheel.fillWheel(1.0f + StaminaWheelConstants.toWheelPos(staminaDeltaHighlightStart), 1.0f + StaminaWheelConstants.toWheelPos(stamina), color);
                    }
                }
            }
        }
        if (extraStamina > 0.0) {
            int extraWheelColor = this.fullAnim.getFadeColor(-256);
            this.extraWheel.fillStamina(0.0, extraStamina, extraWheelColor);
            if (this.gainExtraStaminaAnim.isActive()) {
                extraWheelColor = this.fullAnim.getFadeColor(this.gainExtraStaminaAnim.getGlowColor(-256));
                this.extraWheel.fillStamina(this.prevExtraStamina, extraStamina, extraWheelColor);
            }
            float staminaEndWheePos = StaminaWheelConstants.toWheelPos(extraStamina);
            this.extraWheel.fillWheel(staminaEndWheePos, (float)Math.ceil(staminaEndWheePos), StaminaWheelConstants.EMPTY);
            this.extraWheel.setIndicatorColor(extraWheelColor);
            if (staminaDeltaHighlightRemaining > 0.0) {
                this.extraWheel.fillWheel(staminaEndWheePos - StaminaWheelConstants.toWheelPos(staminaDeltaHighlightRemaining), staminaEndWheePos, blinkColor);
            }
        }
        this.debugAnim("full", this.fullAnim);
        this.debugAnim("outerWheelFill", this.outerWheelFillAnim);
        this.debugAnim("outerWheelEmpty", this.outerWheelEmptyAnim);
        this.debugAnim("recoverAnim", this.recoverAnim);
        this.debugAnim("gainExtraStamina", this.gainExtraStaminaAnim);
    }

    private void makeOuterWheel(StaminaWheelRenderer.Wheel wheel) {
        int wheelIndicatorColor;
        float staminaWheelPos = wheel.staminaWheelPos();
        if (staminaWheelPos <= 2.0f) {
            return;
        }
        int wheels = (int)Math.ceil(staminaWheelPos);
        int color = StaminaWheelConstants.wheelColor(wheels - 3);
        int n = wheelIndicatorColor = wheels == 3 ? 0 : color;
        if (this.outerWheelEmptyAnim.isActive()) {
            float d = Math.min(1.0f, (float)this.outerWheelEmptyAnim.activeDuration() / 250.0f);
            color = FastColor.ARGB32.lerp((float)d, (int)StaminaWheelConstants.wheelBgColor(wheels - 3), (int)color);
            wheelIndicatorColor = FastColor.ARGB32.lerp((float)d, (int)StaminaWheelConstants.wheelColor(wheels - 2), (int)(wheels == 3 ? FastColor.ARGB32.color((int)0, (int)StaminaWheelConstants.wheelColor(1)) : StaminaWheelConstants.wheelColor(wheels - 3)));
        }
        if (this.fullAnim.isActive()) {
            color = this.fullAnim.getGlowAndFadeColor(color);
            if (wheels >= 4) {
                wheelIndicatorColor = color;
            }
        } else if (this.recoverAnim.isActive()) {
            wheelIndicatorColor = color = this.recoverAnim.getGlowColor(color);
        }
        wheel.fillWheel(2.0f, staminaWheelPos, color);
        if (wheels >= 4) {
            int bgColor = StaminaWheelConstants.wheelBgColor(wheels - 4);
            if (this.outerWheelFillAnim.isActive()) {
                float d = Math.min(1.0f, (float)this.outerWheelFillAnim.activeDuration() / 250.0f);
                bgColor = FastColor.ARGB32.lerp((float)d, (int)StaminaWheelConstants.wheelColor(wheels - 4), (int)bgColor);
                wheelIndicatorColor = FastColor.ARGB32.lerp((float)d, (int)(wheels == 4 ? FastColor.ARGB32.color((int)0, (int)StaminaWheelConstants.wheelColor(1)) : StaminaWheelConstants.wheelColor(wheels - 4)), (int)StaminaWheelConstants.wheelColor(wheels - 3));
            }
            if (this.fullAnim.isActive()) {
                bgColor = this.fullAnim.getGlowAndFadeColor(bgColor);
            } else if (this.recoverAnim.isActive()) {
                bgColor = this.recoverAnim.getGlowColor(bgColor);
            }
            wheel.fillWheel(staminaWheelPos, (float)Math.ceil(staminaWheelPos), bgColor);
        }
        wheel.setIndicatorColor(wheelIndicatorColor);
    }

    public void reset() {
        this.fullAnim.setActive(1100L);
        this.outerWheelFillAnim.reset();
        this.outerWheelEmptyAnim.reset();
        this.recoverAnim.reset();
        this.gainExtraStaminaAnim.reset();
        this.prevDepleted = false;
        this.prevWheelIndex = -1;
        this.prevExtraStamina = 0.0;
    }
}

