/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.client.render;

import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import tictim.paraglider.api.stamina.Stamina;
import tictim.paraglider.client.render.EffectTimer;
import tictim.paraglider.client.render.StaminaWheelConstants;
import tictim.paraglider.client.render.StaminaWheelRenderer;

public class BargainScreenStaminaWheelRenderer
extends StaminaWheelRenderer {
    private final EffectTimer fullAnim = new EffectTimer();
    private final EffectTimer outerWheelFillAnim = new EffectTimer(250L);
    private final EffectTimer outerWheelEmptyAnim = new EffectTimer(250L);
    private double stamina;
    private double maxStamina;
    private double prevMaxStamina;
    private int prevWheelIndex = -1;
    private boolean gainedStamina;
    private boolean full;

    public BargainScreenStaminaWheelRenderer() {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        this.maxStamina = this.prevMaxStamina = Stamina.get((Player)player).maxStamina();
        this.stamina = this.prevMaxStamina;
    }

    public void tick() {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        double maxStamina = Stamina.get((Player)player).maxStamina();
        if (maxStamina != this.maxStamina) {
            if (this.maxStamina == this.stamina) {
                this.prevMaxStamina = this.maxStamina;
            }
            this.maxStamina = maxStamina;
        }
        if (this.stamina > maxStamina) {
            this.stamina = Math.max(this.stamina - 20.0, maxStamina);
            this.gainedStamina = false;
        } else if (this.stamina < maxStamina) {
            this.stamina = Math.min(this.stamina + 20.0, maxStamina);
            this.gainedStamina = true;
        }
        this.full = this.gainedStamina && this.stamina >= maxStamina;
    }

    @Override
    protected void makeWheel(@NotNull Player player, float partialTicks) {
        this.mainWheel.setProperties(this.stamina, Math.max(this.stamina, this.maxStamina));
        int wheelIndex = (int)Math.ceil(this.mainWheel.staminaWheelPos());
        this.fullAnim.update(this.full);
        this.outerWheelFillAnim.update(this.full ? EffectTimer.UpdateMode.SET_INACTIVE : (this.prevWheelIndex < wheelIndex ? EffectTimer.UpdateMode.SET_ACTIVE : EffectTimer.UpdateMode.RETAIN));
        this.outerWheelEmptyAnim.update(this.full ? EffectTimer.UpdateMode.SET_INACTIVE : (this.prevWheelIndex > wheelIndex ? EffectTimer.UpdateMode.SET_ACTIVE : EffectTimer.UpdateMode.RETAIN));
        this.prevWheelIndex = wheelIndex;
        this.mainWheel.fillStamina(0.0, Math.min(this.maxStamina, this.stamina), StaminaWheelConstants.wheelColor(0));
        if (this.stamina > this.maxStamina) {
            this.mainWheel.fillStamina(this.maxStamina, this.stamina, StaminaWheelConstants.EVIL_GLOW);
        } else if (this.full) {
            this.mainWheel.fillStamina(this.prevMaxStamina, this.maxStamina, this.fullAnim.getGlowColor(StaminaWheelConstants.wheelColor(0)));
        }
        this.makeOuterWheel(this.mainWheel);
        this.debugAnim("full", this.fullAnim);
        this.debugAnim("outerWheelFill", this.outerWheelFillAnim);
        this.debugAnim("outerWheelEmpty", this.outerWheelEmptyAnim);
    }

    private void makeOuterWheel(StaminaWheelRenderer.Wheel wheel) {
        int wheelIndicatorColor;
        float staminaWheelPos = wheel.staminaWheelPos();
        if (staminaWheelPos <= 2.0f) {
            return;
        }
        int wheels = (int)Math.ceil(staminaWheelPos);
        int color = StaminaWheelConstants.wheelColor(wheels - 3);
        int n = wheelIndicatorColor = wheels == 3 ? 0 : color;
        if (this.outerWheelEmptyAnim.isActive()) {
            float d = Math.min(1.0f, (float)this.outerWheelEmptyAnim.activeDuration() / 250.0f);
            color = FastColor.ARGB32.lerp((float)d, (int)StaminaWheelConstants.wheelBgColor(wheels - 3), (int)color);
            wheelIndicatorColor = FastColor.ARGB32.lerp((float)d, (int)StaminaWheelConstants.wheelColor(wheels - 2), (int)(wheels == 3 ? FastColor.ARGB32.color((int)0, (int)StaminaWheelConstants.wheelColor(1)) : StaminaWheelConstants.wheelColor(wheels - 3)));
        }
        wheel.fillWheel(2.0f, staminaWheelPos, color);
        if (this.stamina > this.maxStamina) {
            wheel.fillWheel(StaminaWheelConstants.toWheelPos(this.maxStamina), Math.min(StaminaWheelConstants.toWheelPos(this.stamina), staminaWheelPos), StaminaWheelConstants.EVIL_GLOW);
        } else if (this.fullAnim.isActive()) {
            color = this.fullAnim.getGlowColor(color);
            if (wheels >= 4) {
                wheelIndicatorColor = color;
            }
            wheel.fillWheel(Math.max(StaminaWheelConstants.toWheelPos(this.prevMaxStamina), (float)(wheels - 1)), StaminaWheelConstants.toWheelPos(this.maxStamina), color);
        }
        if (wheels >= 4) {
            int bgColor = StaminaWheelConstants.wheelBgColor(wheels - 4);
            if (this.outerWheelFillAnim.isActive()) {
                float d = Math.min(1.0f, (float)this.outerWheelFillAnim.activeDuration() / 250.0f);
                bgColor = FastColor.ARGB32.lerp((float)d, (int)StaminaWheelConstants.wheelColor(wheels - 4), (int)bgColor);
                wheelIndicatorColor = FastColor.ARGB32.lerp((float)d, (int)(wheels == 4 ? FastColor.ARGB32.color((int)0, (int)StaminaWheelConstants.wheelColor(1)) : StaminaWheelConstants.wheelColor(wheels - 4)), (int)StaminaWheelConstants.wheelColor(wheels - 3));
            }
            wheel.fillWheel(staminaWheelPos, (float)Math.ceil(staminaWheelPos), bgColor);
            if (this.stamina > this.maxStamina) {
                wheel.fillWheel(StaminaWheelConstants.toWheelPos(this.maxStamina) + 1.0f, (float)Math.ceil(staminaWheelPos), StaminaWheelConstants.EVIL_GLOW);
            } else if (this.fullAnim.isActive()) {
                wheel.fillWheel(StaminaWheelConstants.toWheelPos(this.prevMaxStamina) + 1.0f, Math.min(StaminaWheelConstants.toWheelPos(this.maxStamina) + 1.0f, (float)Math.ceil(staminaWheelPos)), this.fullAnim.getGlowColor(bgColor));
            }
        }
        wheel.setIndicatorColor(wheelIndicatorColor);
    }
}

