/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.client;

import java.time.LocalDate;
import java.time.Month;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.fml.common.asm.enumextension.EnumProxy;
import org.jetbrains.annotations.Nullable;

public final class ParaglidingArmPose {
    public static final EnumProxy<HumanoidModel.ArmPose> ENUM = new EnumProxy(HumanoidModel.ArmPose.class, new Object[]{true, ParaglidingArmPose::applyTransform});
    private static final float ARM_ROTATION = 3.3831854f;
    @Nullable
    private static Boolean IS_CHRISTMAS;

    private ParaglidingArmPose() {
    }

    private static void applyTransform(HumanoidModel<?> model, LivingEntity entity, HumanoidArm arm) {
        Boolean theDay = IS_CHRISTMAS;
        if (theDay == null) {
            LocalDate now = LocalDate.now();
            IS_CHRISTMAS = theDay = Boolean.valueOf(now.getMonth() == Month.APRIL && now.getDayOfMonth() == 1);
        }
        if (theDay.booleanValue()) {
            model.head.xRot = 0.0f;
            model.head.yRot = 0.0f;
            model.head.zRot = 0.0f;
            model.leftArm.xRot = 0.0f;
            model.leftArm.yRot = 0.0f;
            model.leftArm.zRot = -1.5707964f;
            model.rightArm.xRot = 0.0f;
            model.rightArm.yRot = 0.0f;
            model.rightArm.zRot = 1.5707964f;
            model.leftLeg.xRot = 0.0f;
            model.leftLeg.yRot = 0.0f;
            model.leftLeg.zRot = 0.0f;
            model.rightLeg.xRot = 0.0f;
            model.rightLeg.yRot = 0.0f;
            model.rightLeg.zRot = 0.0f;
        } else {
            model.leftArm.xRot = 3.3831854f;
            model.leftArm.yRot = 0.0f;
            model.leftArm.zRot = 0.0f;
            model.rightArm.xRot = 3.3831854f;
            model.rightArm.yRot = 0.0f;
            model.rightArm.zRot = 0.0f;
            model.leftLeg.xRot = 0.0f;
            model.leftLeg.yRot = 0.0f;
            model.leftLeg.zRot = 0.0f;
            model.rightLeg.xRot = 0.0f;
            model.rightLeg.yRot = 0.0f;
            model.rightLeg.zRot = 0.0f;
        }
        Minecraft mc = Minecraft.getInstance();
        ClientLevel level = Objects.requireNonNull(mc.level);
        float partialTick = mc.getTimer().getGameTimeDeltaPartialTick(!level.tickRateManager().isEntityFrozen((Entity)entity));
        float ageInTicks = (float)entity.tickCount + partialTick;
        AnimationUtils.bobModelPart((ModelPart)model.rightArm, (float)ageInTicks, (float)-1.0f);
        AnimationUtils.bobModelPart((ModelPart)model.leftArm, (float)ageInTicks, (float)1.0f);
    }
}

