/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.bargain;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import tictim.paraglider.api.bargain.Bargain;
import tictim.paraglider.api.bargain.BargainType;
import tictim.paraglider.api.vessel.VesselContainer;
import tictim.paraglider.bargain.BargainCatalog;
import tictim.paraglider.network.ParagliderNetwork;

public final class BargainContext {
    private final ServerPlayer player;
    private final int sessionId;
    private final BargainType type;
    private final ResourceLocation typeId;
    private final Map<ResourceLocation, Bargain> bargains;
    @Nullable
    private ResourceLocation advancement;
    @Nullable
    private Vec3 lookAt;
    private int @Nullable [] inventoryHashes;
    private int heartContainerCache;
    private int staminaVesselCache;
    private int essenceCache;
    private boolean catalogRefreshScheduled;
    private boolean finished;

    public BargainContext(@NotNull ServerPlayer player, int sessionId, @NotNull BargainType type, @NotNull ResourceLocation typeId, @NotNull @NotNull Map<@NotNull ResourceLocation, @NotNull Bargain> bargains, @Nullable ResourceLocation advancement, @Nullable Vec3 lookAt) {
        this.player = Objects.requireNonNull(player);
        this.sessionId = sessionId;
        this.type = Objects.requireNonNull(type);
        this.typeId = Objects.requireNonNull(typeId);
        this.bargains = Objects.requireNonNull(bargains);
        this.advancement = advancement;
        this.lookAt = lookAt;
    }

    @NotNull
    public ServerPlayer player() {
        return this.player;
    }

    public int sessionId() {
        return this.sessionId;
    }

    @NotNull
    public BargainType type() {
        return this.type;
    }

    @NotNull
    public ResourceLocation typeId() {
        return this.typeId;
    }

    @NotNull
    public @NotNull @Unmodifiable Map<@NotNull ResourceLocation, @NotNull Bargain> bargains() {
        return Collections.unmodifiableMap(this.bargains);
    }

    public boolean isFinished() {
        return this.finished;
    }

    @Nullable
    public ResourceLocation advancement() {
        return this.advancement;
    }

    @Nullable
    public Vec3 lookAt() {
        return this.lookAt;
    }

    public void setAdvancement(@Nullable ResourceLocation advancement) {
        this.advancement = advancement;
    }

    public void setLookAt(@Nullable Vec3 lookAt) {
        if (Objects.equals(this.lookAt, lookAt)) {
            return;
        }
        this.lookAt = lookAt;
        ParagliderNetwork.get().syncBargainLookAt(this, lookAt);
    }

    public void scheduleCatalogRefresh() {
        this.catalogRefreshScheduled = true;
    }

    public void markFinished() {
        this.finished = true;
    }

    public void checkForUpdates() {
        if (this.isFinished()) {
            return;
        }
        boolean refreshCatalog = false;
        if (this.catalogRefreshScheduled) {
            refreshCatalog = true;
            this.catalogRefreshScheduled = false;
        }
        if (this.inventoryHashes == null) {
            refreshCatalog = true;
            this.inventoryHashes = new int[this.player.getInventory().getContainerSize()];
        }
        for (int i = 0; i < this.inventoryHashes.length; ++i) {
            ItemStack stack = this.player.getInventory().getItem(i);
            int hash = stack.getItem().hashCode();
            if (this.inventoryHashes[i] == (hash = hash * 31 + stack.getCount())) continue;
            refreshCatalog = true;
            this.inventoryHashes[i] = hash;
        }
        VesselContainer container = VesselContainer.get((Player)this.player);
        if (this.heartContainerCache != container.heartContainer()) {
            refreshCatalog = true;
            this.heartContainerCache = container.heartContainer();
        }
        if (this.staminaVesselCache != container.staminaVessel()) {
            refreshCatalog = true;
            this.staminaVesselCache = container.staminaVessel();
        }
        if (this.essenceCache != container.essence()) {
            refreshCatalog = true;
            this.essenceCache = container.essence();
        }
        if (refreshCatalog) {
            ParagliderNetwork.get().syncBargainCatalog(this, this.makeCatalog());
        }
    }

    @NotNull
    public @NotNull List<@NotNull BargainCatalog> makeCatalog() {
        ArrayList<BargainCatalog> demands = new ArrayList<BargainCatalog>();
        for (Map.Entry<ResourceLocation, Bargain> e : this.bargains.entrySet()) {
            Bargain bargain = e.getValue();
            demands.add(new BargainCatalog(e.getKey(), bargain.previewDemands(), bargain.previewOffers(), (IntList)new IntArrayList(bargain.countDemands((Player)this.player)), bargain.bargain((Player)this.player, true).isSuccess()));
        }
        return demands;
    }
}

