/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.api.stamina;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tictim.paraglider.api.ParagliderAPI;
import tictim.paraglider.api.movement.PlayerState;
import tictim.paraglider.api.stamina.StaminaEfficiencyLogicHandler;

public interface StaminaEfficiencyLogic {
    @NotNull
    public static StaminaEfficiencyLogicHandler handler() {
        return ParagliderAPI.staminaEfficiencyLogicHandler();
    }

    public static double applyEfficiency(double baseStaminaDelta, double efficiency) {
        if (efficiency == 0.0 || Double.isNaN(efficiency)) {
            return baseStaminaDelta;
        }
        boolean sd = baseStaminaDelta > 0.0;
        boolean se = efficiency > 0.0;
        double factor = 1.0 + Math.abs(efficiency);
        return sd == se ? baseStaminaDelta * factor : baseStaminaDelta / factor;
    }

    public boolean isApplicable(double var1, @NotNull Context var3);

    public double getEfficiency(double var1, @NotNull Context var3);

    public record SimpleContext(@Nullable Player player, @Nullable PlayerState state) implements Context
    {
    }

    public static interface Context {
        @Nullable
        public Player player();

        @Nullable
        public PlayerState state();

        default public boolean stateIs(@NotNull ResourceLocation id) {
            PlayerState state = this.state();
            return state != null && state.is(id);
        }

        default public boolean stateHasFlag(@NotNull ResourceLocation flag) {
            PlayerState state = this.state();
            return state != null && state.hasFlag(flag);
        }
    }
}

