/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.api.stamina;

import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import tictim.paraglider.api.ParagliderAPI;

public interface Stamina {
    public static final double STAMINA_PER_WHEEL = 1000.0;

    @NotNull
    public static Stamina get(@NotNull Player player) {
        return ParagliderAPI.staminaSupplier().apply(player);
    }

    public double stamina();

    default public void setStamina(double stamina) {
        this.setStamina(stamina, false);
    }

    public void setStamina(double var1, boolean var3);

    public double maxStamina();

    public double extraStamina();

    default public void setExtraStamina(double extraStamina) {
        this.setExtraStamina(extraStamina, false);
    }

    public void setExtraStamina(double var1, boolean var3);

    public boolean isDepleted();

    default public void setDepleted(boolean depleted) {
        this.setDepleted(depleted, false);
    }

    public void setDepleted(boolean var1, boolean var2);

    public boolean isDirty();

    public void setDirty(boolean var1);

    default public double giveStamina(double amount, boolean simulate) {
        return this.giveStamina(amount, simulate, false);
    }

    public double giveStamina(double var1, boolean var3, boolean var4);

    default public double takeStamina(double amount, boolean simulate, boolean ignoreDepletion) {
        return this.takeStamina(amount, simulate, ignoreDepletion, false);
    }

    default public double takeStamina(double amount, boolean simulate, boolean ignoreDepletion, boolean silent) {
        return this.takeStamina(amount, simulate, ignoreDepletion, true, true, silent);
    }

    public double takeStamina(double var1, boolean var3, boolean var4, boolean var5, boolean var6, boolean var7);

    default public boolean renderStaminaWheel() {
        return true;
    }

    default public boolean updateWithDefaultLogic(boolean client) {
        return true;
    }

    default public void syncProperties(double stamina, double extraStamina, boolean depleted) {
        this.setStamina(stamina);
        this.setExtraStamina(extraStamina);
        this.setDepleted(depleted);
    }
}

