/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.api.movement;

import java.util.Objects;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public sealed interface MovementPluginAction {

    public record SetFallbackConnection(@NotNull ResourceLocation parent, @Nullable ResourceLocation fallback, double priority) implements MovementPluginAction
    {
    }

    public record ChangeDefaultStaminaDelta(@NotNull ResourceLocation id, double defaultStaminaDelta) implements MovementPluginAction
    {
        public ChangeDefaultStaminaDelta(@NotNull ResourceLocation id, double defaultStaminaDelta) {
            Objects.requireNonNull(id, "id == null");
        }
    }

    public static sealed interface NewState
    extends MovementPluginAction {
        @NotNull
        public ResourceLocation id();

        public record Synthetic(@NotNull ResourceLocation id) implements NewState
        {
            public Synthetic(@NotNull ResourceLocation id) {
                Objects.requireNonNull(id, "id == null");
            }
        }

        public record Regular(@NotNull ResourceLocation id, double defaultStaminaDelta, @NotNull @NotNull @Unmodifiable Set<@NotNull ResourceLocation> flags) implements NewState
        {
            public Regular(@NotNull ResourceLocation id, double defaultStaminaDelta, @NotNull @Unmodifiable Set<ResourceLocation> flags) {
                Objects.requireNonNull(id, "id == null");
                Objects.requireNonNull(flags, "flags == null");
                for (ResourceLocation flag : flags) {
                    Objects.requireNonNull(flag);
                }
            }
        }
    }
}

