/*
 * Decompiled with CFR 0.152.
 */
package me.frankv.jmi.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import org.joml.Matrix4f;

public class Draw {
    public static void drawRectangle(GuiGraphics guiGraphics, double x, double y, double width, double height, int color, float alpha) {
        Draw.drawRectangle(guiGraphics, x, y, width, height, color, alpha, 0.0f);
    }

    public static void drawRectangle(GuiGraphics guiGraphics, double x, double y, double width, double height, int color, float alpha, float level) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        BufferBuilder bufferbuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        Matrix4f matrix4f = guiGraphics.pose().last().pose();
        bufferbuilder.addVertex(matrix4f, (float)x, (float)(height + y), level).setColor(red, green, blue, alpha);
        bufferbuilder.addVertex(matrix4f, (float)(x + width), (float)(height + y), level).setColor(red, green, blue, alpha);
        bufferbuilder.addVertex(matrix4f, (float)(x + width), (float)y, level).setColor(red, green, blue, alpha);
        bufferbuilder.addVertex(matrix4f, (float)x, (float)y, level).setColor(red, green, blue, alpha);
        BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }
}

