/*
 * Decompiled with CFR 0.152.
 */
package me.frankv.jmi.config;

import java.util.ArrayList;
import java.util.List;
import me.frankv.jmi.api.jmoverlay.ClientConfig;
import net.neoforged.neoforge.common.ModConfigSpec;

public class NeoForgeClientConfig
implements ClientConfig {
    private final ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
    private final ModConfigSpec.BooleanValue ftbChunks;
    private final ModConfigSpec.BooleanValue waystone;
    private final ModConfigSpec.ConfigValue<List<? extends String>> waypointMessageBlocks;
    private final ModConfigSpec.BooleanValue waypointMessageEmptyHandOnly;
    private final ModConfigSpec.DoubleValue claimedChunkOverlayOpacity;
    private final ModConfigSpec.BooleanValue disableFTBFunction;
    private final ModConfigSpec.IntValue waystoneColor;
    private final ModConfigSpec.IntValue defaultConfigVersion;

    public NeoForgeClientConfig() {
        this.builder.comment("Client-Side Integration");
        this.builder.push("FTBChunks");
        this.ftbChunks = this.builder.comment("Enable FTBChunks Integration").define("ftbChunks", true);
        this.claimedChunkOverlayOpacity = this.builder.defineInRange("claimedChunkOverlayOpacity", (double)0.175f, 0.0, 1.0);
        this.disableFTBFunction = this.builder.comment("Disable conflict functions for FTBChunks (MiniMap, Waypoint beam, Death waypoint)").define("disableFTBFunction", true);
        this.builder.pop();
        this.builder.push("Waystones");
        this.waystone = this.builder.comment("Enable Waystones Integration").define("waystones", true);
        this.waystoneColor = this.builder.comment("The color code for Waystone marker. You can generate the color code from https://www.mathsisfun.com/hexadecimal-decimal-colors.html").defineInRange("wayStoneMarkerColor", 0xFFFFFF, 0, 0xFFFFFF);
        this.builder.pop();
        this.builder.push("WaypointMessage");
        this.waypointMessageBlocks = this.builder.comment("List of block id and tags for WaypointMessage. e.g., [\"#forge:ores/diamond\", \"minecraft:diamond_block\"]").defineList("waypointMessageBlocks", ArrayList::new, l -> l instanceof String);
        this.waypointMessageEmptyHandOnly = this.builder.define("emptyHandOnly", true);
        this.builder.pop();
        this.builder.push("JourneyMap Default Config");
        this.defaultConfigVersion = this.builder.comment("When local JM default config version is older than `defaultConfigVersion` it will copy everything under `/config/jmdefaultconfig/` to `/journeymap/` and replace the existing files. Set to -1 to disable.").defineInRange("defaultConfigVersion", -1, -1, Integer.MAX_VALUE);
        this.builder.pop();
    }

    public ModConfigSpec getSpec() {
        return this.builder.build();
    }

    @Override
    public Boolean getFtbChunks() {
        return (Boolean)this.ftbChunks.get();
    }

    @Override
    public Boolean getWaystone() {
        return (Boolean)this.waystone.get();
    }

    @Override
    public List<? extends String> getWaypointMessageBlocks() {
        return (List)this.waypointMessageBlocks.get();
    }

    @Override
    public Boolean getWaypointMessageEmptyHandOnly() {
        return (Boolean)this.waypointMessageEmptyHandOnly.get();
    }

    @Override
    public Double getClaimedChunkOverlayOpacity() {
        return (Double)this.claimedChunkOverlayOpacity.get();
    }

    @Override
    public Boolean getDisableFTBFunction() {
        return (Boolean)this.disableFTBFunction.get();
    }

    @Override
    public Integer getWaystoneColor() {
        return (Integer)this.waystoneColor.get();
    }

    @Override
    public Integer getDefaultConfigVersion() {
        return (Integer)this.defaultConfigVersion.get();
    }
}

