/*
 * Decompiled with CFR 0.152.
 */
package me.frankv.jmi.compat.ftbchunks;

import dev.ftb.mods.ftblibrary.math.ChunkDimPos;
import dev.ftb.mods.ftbteams.data.ClientTeam;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import journeymap.api.v2.client.display.Overlay;
import journeymap.api.v2.client.model.ShapeProperties;
import journeymap.api.v2.client.model.TextProperties;
import lombok.Generated;
import me.frankv.jmi.compat.ftbchunks.ClaimedChunk;
import me.frankv.jmi.compat.ftbchunks.OverlayUtil;
import me.frankv.jmi.compat.ftbchunks.PolygonWrapper;

public class FTBChunksCompatStates {
    private final Map<ChunkDimPos, ClaimedChunk> chunkData = new HashMap<ChunkDimPos, ClaimedChunk>();
    private final Map<ChunkDimPos, Overlay> forceLoadedOverlays = new HashMap<ChunkDimPos, Overlay>();
    private final Map<UUID, ShapeProperties> shapeProperties = new HashMap<UUID, ShapeProperties>();
    private final Map<UUID, TextProperties> textProperties = new HashMap<UUID, TextProperties>();
    private final Map<UUID, Set<PolygonWrapper>> teamOverlays = new HashMap<UUID, Set<PolygonWrapper>>();

    public void clearOverlays() {
        this.teamOverlays.clear();
        this.forceLoadedOverlays.clear();
    }

    public void resetData() {
        this.chunkData.clear();
        this.forceLoadedOverlays.clear();
        this.shapeProperties.clear();
        this.textProperties.clear();
        this.teamOverlays.clear();
    }

    public ShapeProperties getShapeProps(ClientTeam team, float opacity) {
        return this.shapeProperties.computeIfAbsent(team.getTeamId(), __ -> new ShapeProperties().setStrokeWidth(1.5f).setStrokeOpacity(0.75f).setStrokeColor(team.getColor()).setFillColor(team.getColor()).setFillOpacity(opacity));
    }

    public TextProperties getTextProps(ClientTeam team) {
        return this.textProperties.computeIfAbsent(team.getTeamId(), __ -> new TextProperties().setColor(OverlayUtil.getTeamTextColor(team)).setMinZoom(250).setFontShadow(true));
    }

    @Generated
    public Map<ChunkDimPos, ClaimedChunk> getChunkData() {
        return this.chunkData;
    }

    @Generated
    public Map<ChunkDimPos, Overlay> getForceLoadedOverlays() {
        return this.forceLoadedOverlays;
    }

    @Generated
    public Map<UUID, ShapeProperties> getShapeProperties() {
        return this.shapeProperties;
    }

    @Generated
    public Map<UUID, TextProperties> getTextProperties() {
        return this.textProperties;
    }

    @Generated
    public Map<UUID, Set<PolygonWrapper>> getTeamOverlays() {
        return this.teamOverlays;
    }

    @Generated
    public FTBChunksCompatStates() {
    }
}

