/*
 * Decompiled with CFR 0.152.
 */
package me.frankv.jmi.compat.ftbchunks;

import dev.ftb.mods.ftbchunks.client.FTBChunksClientConfig;
import java.util.Set;
import journeymap.api.v2.client.IClientAPI;
import lombok.Generated;
import me.frankv.jmi.api.ModCompat;
import me.frankv.jmi.api.PlatformHelper;
import me.frankv.jmi.api.event.Event;
import me.frankv.jmi.api.event.JMIEventBus;
import me.frankv.jmi.api.jmoverlay.ClientConfig;
import me.frankv.jmi.api.jmoverlay.ToggleableOverlay;
import me.frankv.jmi.compat.ftbchunks.FTBChunksCompatStates;
import me.frankv.jmi.compat.ftbchunks.GeneralDataOverlay;
import me.frankv.jmi.compat.ftbchunks.claimedchunksoverlay.ClaimedChunksOverlay;
import me.frankv.jmi.compat.ftbchunks.claimingmode.ClaimingMode;
import me.frankv.jmi.compat.ftbchunks.infoslot.ClaimedChunkInfoSlot;

public class FTBChunksCompat
implements ModCompat {
    private final Set<ToggleableOverlay> toggleableOverlays = Set.of(ClaimedChunksOverlay.INSTANCE, ClaimingMode.INSTANCE);
    private ClaimedChunkInfoSlot claimedChunkInfoSlot;
    private FTBChunksCompatStates states;
    private ClientConfig clientConfig;

    @Override
    public void init(IClientAPI jmAPI, ClientConfig clientConfig) {
        this.states = new FTBChunksCompatStates();
        this.clientConfig = clientConfig;
        this.claimedChunkInfoSlot = new ClaimedChunkInfoSlot(this.states);
        ClaimedChunksOverlay.INSTANCE.init(clientConfig, this.states);
        this.disableFTBChunksStuff();
    }

    @Override
    public void registerEvent(JMIEventBus eventBus) {
        eventBus.subscribe(Event.ClientTick.class, e -> ClaimedChunksOverlay.INSTANCE.onClientTick());
        eventBus.subscribe(Event.ResetDataEvent.class, e -> this.states.resetData());
        eventBus.subscribe(Event.ScreenClose.class, e -> ClaimingMode.INSTANCE.onScreenClose(e.screen()));
        eventBus.subscribe(Event.JMMappingEvent.class, ClaimedChunksOverlay.INSTANCE::onJMMapping);
        eventBus.subscribe(Event.JMClickEvent.class, e -> ClaimingMode.INSTANCE.getHandler().onClick(e.clickEvent()));
        eventBus.subscribe(Event.JMMouseMoveEvent.class, e -> ClaimingMode.INSTANCE.getHandler().onMouseMove(e.mouseMoveEvent()));
        eventBus.subscribe(Event.JMMouseDraggedEvent.class, e -> ClaimingMode.INSTANCE.getHandler().onDrag(e.mouseDraggedEvent()));
        eventBus.subscribe(Event.JMInfoSlotRegistryEvent.class, this.claimedChunkInfoSlot::onJMInfoSlotRegistryEvent);
        eventBus.subscribe(Event.MouseRelease.class, e -> ClaimingMode.INSTANCE.getHandler().onMouseReleased());
        eventBus.subscribe(Event.ScreenDraw.class, e -> GeneralDataOverlay.onScreenDraw(e.screen(), e.guiGraphics()));
    }

    @Override
    public boolean isEnabled() {
        return this.clientConfig.getFtbChunks();
    }

    @Override
    public boolean isTargetModsLoaded() {
        return PlatformHelper.PLATFORM.isModLoaded("ftbchunks");
    }

    private void disableFTBChunksStuff() {
        if (!this.clientConfig.getDisableFTBFunction().booleanValue()) {
            return;
        }
        FTBChunksClientConfig.DEATH_WAYPOINTS.set((Object)false);
        FTBChunksClientConfig.MINIMAP_ENABLED.set((Object)false);
        FTBChunksClientConfig.IN_WORLD_WAYPOINTS.set((Object)false);
    }

    @Override
    @Generated
    public Set<ToggleableOverlay> getToggleableOverlays() {
        return this.toggleableOverlays;
    }

    @Generated
    public ClaimedChunkInfoSlot getClaimedChunkInfoSlot() {
        return this.claimedChunkInfoSlot;
    }

    @Generated
    public FTBChunksCompatStates getStates() {
        return this.states;
    }

    @Generated
    public ClientConfig getClientConfig() {
        return this.clientConfig;
    }
}

