/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.jupiter.config.interfaces;

import com.iafenvoy.jupiter.Jupiter;
import com.iafenvoy.jupiter.config.ConfigDataFixer;
import com.iafenvoy.jupiter.config.interfaces.ValueChangeCallback;
import com.iafenvoy.jupiter.config.type.ConfigType;
import com.iafenvoy.jupiter.interfaces.IConfigEntry;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.Objects;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public interface ConfigEntry<T>
extends IConfigEntry<T> {
    @Override
    public ConfigType<T> getType();

    @Override
    @Nullable
    public String getKey();

    @Override
    public Component getName();

    @Override
    @Nullable
    public Component getTooltip();

    @Override
    public ConfigEntry<T> newInstance();

    @Override
    public void registerCallback(ValueChangeCallback<T> var1);

    @Override
    public T getValue();

    @Override
    public T getDefaultValue();

    @Override
    public void setValue(T var1);

    @Override
    public Codec<T> getCodec();

    @Override
    default public <R> DataResult<R> encode(ConfigDataFixer dataFixer, DynamicOps<R> ops) {
        return this.getCodec().encodeStart(ops, this.getValue());
    }

    @Override
    default public <R> void decode(ConfigDataFixer dataFixer, DynamicOps<R> ops, R input) {
        this.getCodec().parse(ops, input).resultOrPartial(arg_0 -> ((Logger)Jupiter.LOGGER).error(arg_0)).ifPresent(this::setValue);
    }

    @Override
    public void reset();

    @Override
    default public boolean canReset() {
        return !Objects.equals(this.getValue(), this.getDefaultValue());
    }
}

