/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.adorable_eggs.block.custom;

import com.cerbon.adorable_eggs.block.ADEBlocks;
import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class EggBlock
extends HorizontalDirectionalBlock {
    private final ItemLike eggDrop;
    public static final MapCodec<EggBlock> CODEC = EggBlock.simpleCodec(properties1 -> new EggBlock((BlockBehaviour.Properties)properties1, (ItemLike)ADEBlocks.ALLAY_EGG.get()));
    public static final VoxelShape SHAPE = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)19.0, (double)15.0);
    public static final Map<ItemLike, EggBlock> SPAWN_EGG_TO_BLOCK_EGG = new Object2ObjectOpenHashMap();

    public EggBlock(BlockBehaviour.Properties properties, ItemLike eggDrop) {
        super(properties);
        this.eggDrop = eggDrop;
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
        SPAWN_EGG_TO_BLOCK_EGG.putIfAbsent(eggDrop, this);
    }

    @NotNull
    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public ItemLike eggDrop() {
        return this.eggDrop;
    }

    @NotNull
    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    public void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    @NotNull
    protected BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    @NotNull
    protected BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }
}

