/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.cristellib.config;

import blue.endless.jankson.Jankson;
import blue.endless.jankson.JsonElement;
import blue.endless.jankson.JsonGrammar;
import blue.endless.jankson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import de.cristelknight.cristellib.CristelLib;
import de.cristelknight.cristellib.CristelLibExpectPlatform;
import de.cristelknight.cristellib.StructureConfig;
import de.cristelknight.cristellib.config.serialize.ed.EDConfig;
import de.cristelknight.cristellib.config.serialize.ed.EDConfigTransformer;
import de.cristelknight.cristellib.config.serialize.ed.NestedEDConfig;
import de.cristelknight.cristellib.config.serialize.placement.PlacementConfig;
import de.cristelknight.cristellib.config.simple.ConfigRegistry;
import de.cristelknight.cristellib.config.simple.datafixer.DataFixer;
import de.cristelknight.cristellib.util.JanksonUtil;
import de.cristelknight.cristellib.util.jankson.JanksonOps;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;

public class ConfigManager {
    public static final Path CONFIG_DIR = CristelLibExpectPlatform.getConfigDirectory();
    public static final Path CONFIG_LIB = CONFIG_DIR.resolve("cristellib");
    public static final Jankson JANKSON = Jankson.builder().build();
    public static final Supplier<JsonGrammar.Builder> JSON_GRAMMAR_BUILDER = () -> new JsonGrammar.Builder().withComments(true).bareSpecialNumerics(true).printCommas(true);
    public static final JsonGrammar JSON_GRAMMAR = JSON_GRAMMAR_BUILDER.get().build();

    public static void createEDConfig(StructureConfig config, boolean override) {
        Map<String, NestedEDConfig> nestedStructureMap;
        if (config.enableDisableConfig == null) {
            Map<ResourceLocation, List<ResourceLocation>> sets = config.getDefaultStructures();
            nestedStructureMap = EDConfigTransformer.mapToNestedStructures(sets, config);
        } else {
            nestedStructureMap = EDConfigTransformer.mapToNestedStructuresWithValues(config.enableDisableConfig, config);
        }
        ConfigManager.writeConfig(config, NestedEDConfig.ED_CODEC, nestedStructureMap, override);
    }

    public static Map<ResourceLocation, EDConfig> readEDConfig(StructureConfig config) {
        Map<String, NestedEDConfig> configMap = ConfigManager.readFromJanksonPath(config.getPath(), NestedEDConfig.ED_CODEC);
        HashMap<ResourceLocation, EDConfig> map = new HashMap<ResourceLocation, EDConfig>();
        for (String structureSet : configMap.keySet()) {
            map.put(config.toDefaultRL(structureSet), new EDConfig(EDConfigTransformer.stringBooleanMap(configMap.get(structureSet), "")));
        }
        return map;
    }

    public static void createPlacementConfig(StructureConfig config, boolean override) {
        Map<ResourceLocation, PlacementConfig> sets = config.placementConfig == null ? config.getDefaultStructurePlacement() : config.placementConfig;
        Map<String, PlacementConfig> sets2 = sets.entrySet().stream().collect(Collectors.toMap(entry -> config.toDefaultString((ResourceLocation)entry.getKey()), Map.Entry::getValue));
        ConfigManager.writeConfig(config, PlacementConfig.PLACEMENT_CODEC, sets2, override);
    }

    public static Map<ResourceLocation, PlacementConfig> readPlacementConfig(StructureConfig config) {
        Map<String, PlacementConfig> sets = ConfigManager.readFromJanksonPath(config.getPath(), PlacementConfig.PLACEMENT_CODEC);
        return sets.entrySet().stream().collect(Collectors.toMap(entry -> config.toDefaultRL((String)entry.getKey()), Map.Entry::getValue));
    }

    public static String createHeader(String header) {
        if (header == null || ((String)header).isEmpty()) {
            return "";
        }
        if (!((String)header).endsWith("\n")) {
            header = (String)header + "\n";
        }
        return "/*\n" + (String)header + "*/\n";
    }

    public static <T> void writeConfig(StructureConfig config, Codec<T> codec, T from, boolean override) {
        Path path = config.getPath();
        if (!override && path.toFile().exists()) {
            return;
        }
        ConfigManager.writeFile(config.getPath(), codec, config.getComments(), from, ConfigManager.createHeader(config.getHeader()), true);
    }

    public static <T> void writeFile(Path path, Codec<T> codec, Map<String, String> comments, T from, String header, boolean isSorted) {
        JsonElement jsonElement = ConfigManager.createElement(path, codec, JanksonOps.INSTANCE, from);
        if (jsonElement instanceof JsonObject) {
            JsonObject jsonObject = (JsonObject)jsonElement;
            jsonElement = JanksonUtil.addCommentsAndAlphabeticallySortRecursively(comments, jsonObject, "", isSorted);
        }
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            String output = header + jsonElement.toJson(JSON_GRAMMAR);
            Files.write(path, output.getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            CristelLib.LOGGER.error(e.toString());
        }
    }

    public static <T, K> K createElement(Path path, Codec<T> codec, DynamicOps<K> ops, T from) {
        DataResult dataResult = codec.encodeStart(ops, from);
        Optional error = dataResult.error();
        if (error.isPresent()) {
            throw new IllegalArgumentException(CristelLib.getWithPrefix(String.format("Jankson file creation for \"%s\" failed due to the following error(s):\n%s", path.toString(), ((DataResult.Error)error.get()).message())));
        }
        return (K)dataResult.result().orElseThrow();
    }

    public static <T> T readFromJanksonPath(Path path, Codec<T> codec) {
        JsonObject load;
        try {
            load = JANKSON.load(path.toFile());
        }
        catch (Exception errorMsg) {
            throw new IllegalArgumentException(CristelLib.getWithPrefix(String.format("Couldn't load %s, crashing instead. Maybe try to delete the config files!", path)));
        }
        return ConfigManager.readElement(String.format("Couldn't read %s, crashing instead. Maybe try to delete the config files!", path), codec, JanksonOps.INSTANCE, load);
    }

    /*
     * Unable to fully structure code
     */
    public static <T> T readFromJanksonPathWithFix(Path path, Codec<T> codec, Consumer<T> writeAfterFix) {
        try {
            load = ConfigManager.JANKSON.load(path.toFile());
        }
        catch (Exception errorMsg) {
            throw new IllegalArgumentException(CristelLib.getWithPrefix(String.format("Couldn't load %s, crashing instead. Maybe try to delete the config files!", new Object[]{path})));
        }
        if (!(load instanceof JsonObject)) ** GOTO lbl-1000
        object = load;
        if (DataFixer.appliedFixer(ConfigRegistry.getClazzFromCodec(codec), object)) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
        gotFixed = v0;
        config = ConfigManager.readElement(String.format("Couldn't read %s, crashing instead. Maybe try to delete the config files!", new Object[]{path}), codec, JanksonOps.INSTANCE, load);
        if (gotFixed) {
            writeAfterFix.accept(config);
        }
        return config;
    }

    public static <T> T readFromJsonPath(String errorMsg, Path path, Codec<T> codec) {
        InputStream stream;
        try {
            stream = Files.newInputStream(path, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(CristelLib.getWithPrefix(String.format("Couldn't load %s, crashing instead. Maybe try to delete the config files!", path)));
        }
        com.google.gson.JsonElement load = JsonParser.parseReader((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8));
        return ConfigManager.readElement(errorMsg, codec, JsonOps.INSTANCE, load);
    }

    public static <T, K> T readElement(String errorMsg, Codec<T> codec, DynamicOps<K> ops, K load) {
        DataResult decode = codec.decode(ops, load);
        Optional error = decode.error();
        if (error.isPresent()) {
            throw new IllegalArgumentException(CristelLib.getWithPrefix(errorMsg) + " " + ((DataResult.Error)error.get()).message());
        }
        return (T)((Pair)decode.result().orElseThrow()).getFirst();
    }
}

