/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsbridges.world.processor;

import com.yungnickyoung.minecraft.yungsapi.api.world.randomize.BlockStateRandomizer;
import com.yungnickyoung.minecraft.yungsbridges.world.processor.ITemplateFeatureProcessor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class OptionalBlockProcessor
implements ITemplateFeatureProcessor {
    private final BlockStateRandomizer brownStainedGlassReplacer = new BlockStateRandomizer(AIR).addBlock(Blocks.STONE_BRICKS.defaultBlockState(), 0.1875f).addBlock(Blocks.MOSSY_STONE_BRICKS.defaultBlockState(), 0.375f).addBlock(Blocks.CRACKED_STONE_BRICKS.defaultBlockState(), 0.1875f);
    private final BlockStateRandomizer blueStainedGlassReplacer = new BlockStateRandomizer(AIR).addBlock(Blocks.CHISELED_STONE_BRICKS.defaultBlockState(), 0.75f);
    private final BlockStateRandomizer redStainedGlassReplacer = new BlockStateRandomizer(AIR).addBlock(Blocks.COBBLESTONE.defaultBlockState(), 0.75f);
    private final BlockStateRandomizer endStoneBricksReplacer = new BlockStateRandomizer(AIR).addBlock(Blocks.POLISHED_ANDESITE.defaultBlockState(), 0.75f);
    private final BlockStateRandomizer darkPrismarineReplacer = new BlockStateRandomizer(AIR).addBlock(Blocks.COBBLESTONE.defaultBlockState(), 0.375f).addBlock(Blocks.ANDESITE.defaultBlockState(), 0.375f);

    @Override
    public void processTemplate(StructureTemplate template, WorldGenLevel level, RandomSource randomSource, BlockPos cornerPos, BlockPos centerPos, StructurePlaceSettings placementSettings) {
        Holder biome = level.getBiome(cornerPos);
        for (StructureTemplate.StructureBlockInfo blockInfo : template.filterBlocks(cornerPos, placementSettings, Blocks.BROWN_STAINED_GLASS)) {
            level.setBlock(blockInfo.pos(), this.brownStainedGlassReplacer.get(randomSource), 2);
        }
        for (StructureTemplate.StructureBlockInfo blockInfo : template.filterBlocks(cornerPos, placementSettings, Blocks.BLUE_STAINED_GLASS)) {
            level.setBlock(blockInfo.pos(), this.blueStainedGlassReplacer.get(randomSource), 2);
        }
        for (StructureTemplate.StructureBlockInfo blockInfo : template.filterBlocks(cornerPos, placementSettings, Blocks.RED_STAINED_GLASS)) {
            level.setBlock(blockInfo.pos(), this.redStainedGlassReplacer.get(randomSource), 2);
        }
        for (StructureTemplate.StructureBlockInfo blockInfo : template.filterBlocks(cornerPos, placementSettings, Blocks.END_STONE_BRICKS)) {
            level.setBlock(blockInfo.pos(), this.endStoneBricksReplacer.get(randomSource), 2);
        }
        for (StructureTemplate.StructureBlockInfo blockInfo : template.filterBlocks(cornerPos, placementSettings, Blocks.DARK_PRISMARINE)) {
            level.setBlock(blockInfo.pos(), this.darkPrismarineReplacer.get(randomSource), 2);
        }
        for (StructureTemplate.StructureBlockInfo blockInfo : template.filterBlocks(cornerPos, placementSettings, Blocks.LIME_STAINED_GLASS)) {
            if (randomSource.nextFloat() < 0.5f) {
                level.setBlock(blockInfo.pos(), this.getLogBlockWithState(this.getLogBiomeVariant((Holder<Biome>)biome), blockInfo.state()), 2);
                continue;
            }
            level.setBlock(blockInfo.pos(), Blocks.AIR.defaultBlockState(), 2);
        }
    }
}

