/*
 * Decompiled with CFR 0.152.
 */
package samebutdifferent.ecologics.registry;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.DiskConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import oshi.util.tuples.Pair;
import samebutdifferent.ecologics.worldgen.feature.CoastalFeature;
import samebutdifferent.ecologics.worldgen.feature.DesertRuinFeature;
import samebutdifferent.ecologics.worldgen.feature.ThinIceFeature;

public class ModFeatures {
    public static final ArrayList<Pair<ResourceLocation, Feature<?>>> FEATURES = new ArrayList();
    public static final Feature<?> COASTAL = ModFeatures.registerFeature("coastal", new CoastalFeature((Codec<SimpleBlockConfiguration>)SimpleBlockConfiguration.CODEC));
    public static final Feature<?> THIN_ICE = ModFeatures.registerFeature("thin_ice", new ThinIceFeature((Codec<DiskConfiguration>)DiskConfiguration.CODEC));
    public static final Feature<?> DESERT_RUIN = ModFeatures.registerFeature("desert_ruin", new DesertRuinFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.CODEC));
    public static final Feature<?> AZALEA_TREE = ModFeatures.registerFeature("azalea_tree", new TreeFeature(TreeConfiguration.CODEC));
    public static final Feature<?> COCONUT_TREE = ModFeatures.registerFeature("coconut_tree", new TreeFeature(TreeConfiguration.CODEC));
    public static final Feature<?> WALNUT_TREE = ModFeatures.registerFeature("walnut_tree", new TreeFeature(TreeConfiguration.CODEC));
    public static final ResourceKey<ConfiguredFeature<?, ?>> ROOTED_AZALEA_TREE = ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"ecologics", (String)"rooted_azalea_tree"));
    public static final ResourceKey<ConfiguredFeature<?, ?>> AZALEA_REGULAR = ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"ecologics", (String)"azalea_tree"));
    public static final ResourceKey<ConfiguredFeature<?, ?>> COCONUT_REGULAR = ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"ecologics", (String)"coconut_tree"));
    public static final ResourceKey<ConfiguredFeature<?, ?>> WALNUT_REGULAR = ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"ecologics", (String)"walnut_tree"));

    public static void init() {
        for (Pair<ResourceLocation, Feature<?>> registry : FEATURES) {
            Registry.register((Registry)BuiltInRegistries.FEATURE, (ResourceLocation)((ResourceLocation)registry.getA()), (Object)((Feature)registry.getB()));
        }
    }

    public static Feature<?> registerFeature(String name, Feature<?> feature) {
        FEATURES.add(new Pair((Object)ResourceLocation.fromNamespaceAndPath((String)"ecologics", (String)name), feature));
        return feature;
    }
}

