/*
 * Decompiled with CFR 0.152.
 */
package samebutdifferent.ecologics.registry;

import java.util.ArrayList;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import oshi.util.tuples.Pair;
import samebutdifferent.ecologics.entity.CoconutCrab;
import samebutdifferent.ecologics.entity.ModBoat;
import samebutdifferent.ecologics.entity.ModChestBoat;
import samebutdifferent.ecologics.entity.Penguin;
import samebutdifferent.ecologics.entity.Squirrel;

public class ModEntityTypes {
    public static final ArrayList<Pair<ResourceLocation, EntityType<?>>> ENTITY_TYPES = new ArrayList();
    public static final EntityType<ModBoat> BOAT = ModEntityTypes.registerEntityType("boat", EntityType.Builder.of(ModBoat::new, (MobCategory)MobCategory.MISC).sized(1.375f, 0.5625f).clientTrackingRange(10).build("boat"));
    public static final EntityType<ModChestBoat> CHEST_BOAT = ModEntityTypes.registerEntityType("chest_boat", EntityType.Builder.of(ModChestBoat::new, (MobCategory)MobCategory.MISC).sized(1.375f, 0.5625f).clientTrackingRange(10).build("chest_boat"));
    public static final EntityType<CoconutCrab> COCONUT_CRAB = ModEntityTypes.registerEntityType("coconut_crab", EntityType.Builder.of(CoconutCrab::new, (MobCategory)MobCategory.CREATURE).sized(1.2f, 1.2f).clientTrackingRange(10).build("coconut_crab"));
    public static final EntityType<Penguin> PENGUIN = ModEntityTypes.registerEntityType("penguin", EntityType.Builder.of(Penguin::new, (MobCategory)MobCategory.CREATURE).sized(0.7f, 0.9f).clientTrackingRange(10).build("penguin"));
    public static final EntityType<Squirrel> SQUIRREL = ModEntityTypes.registerEntityType("squirrel", EntityType.Builder.of(Squirrel::new, (MobCategory)MobCategory.CREATURE).sized(0.9f, 0.8f).clientTrackingRange(8).build("squirrel"));

    public static void init() {
        for (Pair<ResourceLocation, EntityType<?>> registry : ENTITY_TYPES) {
            Registry.register((Registry)BuiltInRegistries.ENTITY_TYPE, (ResourceLocation)((ResourceLocation)registry.getA()), (Object)((EntityType)registry.getB()));
        }
    }

    public static <T extends EntityType<?>> T registerEntityType(String name, T entity) {
        ENTITY_TYPES.add(new Pair((Object)ResourceLocation.fromNamespaceAndPath((String)"ecologics", (String)name), entity));
        return entity;
    }
}

