/*
 * Decompiled with CFR 0.152.
 */
package samebutdifferent.ecologics.entity;

import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import samebutdifferent.ecologics.registry.ModItems;
import samebutdifferent.ecologics.registry.ModSoundEvents;

public class CoconutCrab
extends Animal
implements NeutralMob {
    private static final EntityDataAccessor<Boolean> HAS_COCONUT = SynchedEntityData.defineId(CoconutCrab.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.rangeOfSeconds((int)20, (int)39);
    private int remainingPersistentAngerTime;
    @Nullable
    private UUID persistentAngerTarget;

    public CoconutCrab(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel pLevel, AgeableMob pMob) {
        return null;
    }

    public boolean isFood(ItemStack pStack) {
        return false;
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, new CrabAvoidGoal<Player>(this, Player.class, 8.0f, 2.0, 2.0));
        this.goalSelector.addGoal(2, (Goal)new CrabMeleeAttackGoal(this, 1.0, true));
        this.goalSelector.addGoal(3, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new CrabHurtByTargetGoal(this));
        this.targetSelector.addGoal(2, new CrabNearestAttackableTargetGoal<Player>(this, Player.class, 10, true, false, arg_0 -> ((CoconutCrab)this).isAngryAt(arg_0)));
        this.targetSelector.addGoal(3, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 20.0).add(Attributes.FOLLOW_RANGE, 20.0).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.ATTACK_DAMAGE, 2.0);
    }

    public boolean hurt(DamageSource pSource, float pAmount) {
        return super.hurt(pSource, this.hasCoconut() ? pAmount / 2.0f : pAmount);
    }

    public void tick() {
        super.tick();
        if (this.getHealth() <= this.getMaxHealth() / 2.0f && this.hasCoconut()) {
            this.breakCoconut();
        }
        if (!this.level().isClientSide()) {
            this.updatePersistentAnger((ServerLevel)this.level(), true);
        }
    }

    private void breakCoconut() {
        this.setHasCoconut(false);
        this.stopBeingAngry();
        this.playCoconutSmashSound();
        if (((GameRules.BooleanValue)this.level().getGameRules().getRule(GameRules.RULE_DOMOBLOOT)).get()) {
            ItemEntity itementity = new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), new ItemStack((ItemLike)ModItems.COCONUT_SLICE, 2));
            itementity.setDefaultPickUpDelay();
            this.level().addFreshEntity((Entity)itementity);
        }
    }

    protected float getWaterSlowDown() {
        return 0.98f;
    }

    public boolean causeFallDamage(float pFallDistance, float pMultiplier, DamageSource pSource) {
        return false;
    }

    public boolean canBeLeashed() {
        return false;
    }

    public void setHasCoconut(boolean hasCoconut) {
        this.entityData.set(HAS_COCONUT, (Object)hasCoconut);
    }

    public boolean hasCoconut() {
        return (Boolean)this.entityData.get(HAS_COCONUT);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(HAS_COCONUT, (Object)true);
    }

    public void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        pCompound.putBoolean("Coconut", this.hasCoconut());
    }

    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        this.setHasCoconut(pCompound.getBoolean("Coconut"));
    }

    protected SoundEvent getAmbientSound() {
        return ModSoundEvents.COCONUT_CRAB_AMBIENT;
    }

    protected SoundEvent getHurtSound(DamageSource pDamageSource) {
        return ModSoundEvents.COCONUT_CRAB_HURT;
    }

    protected SoundEvent getDeathSound() {
        return ModSoundEvents.COCONUT_CRAB_DEATH;
    }

    protected void playStepSound(BlockPos pPos, BlockState pBlock) {
        this.playSound(SoundEvents.SPIDER_STEP, 0.15f, 1.0f);
    }

    protected void playCoconutSmashSound() {
        this.playSound(ModSoundEvents.COCONUT_SMASH, 0.7f, 1.0f);
    }

    public int getRemainingPersistentAngerTime() {
        return this.remainingPersistentAngerTime;
    }

    public void setRemainingPersistentAngerTime(int pTime) {
        this.remainingPersistentAngerTime = pTime;
    }

    @Nullable
    public UUID getPersistentAngerTarget() {
        return this.persistentAngerTarget;
    }

    public void setPersistentAngerTarget(@Nullable UUID pTarget) {
        this.persistentAngerTarget = pTarget;
    }

    public void startPersistentAngerTimer() {
        this.setRemainingPersistentAngerTime(PERSISTENT_ANGER_TIME.sample(this.random));
    }

    static class CrabAvoidGoal<T extends LivingEntity>
    extends AvoidEntityGoal<T> {
        private final CoconutCrab crab;

        public CrabAvoidGoal(CoconutCrab pMob, Class<T> pEntityClassToAvoid, float pMaxDistance, double pWalkSpeedModifier, double pSprintSpeedModifier) {
            super((PathfinderMob)pMob, pEntityClassToAvoid, pMaxDistance, pWalkSpeedModifier, pSprintSpeedModifier, EntitySelector.NO_SPECTATORS::test);
            this.crab = pMob;
        }

        public boolean canUse() {
            return !this.crab.hasCoconut() && super.canUse();
        }

        public boolean canContinueToUse() {
            return !this.crab.hasCoconut() && super.canContinueToUse();
        }
    }

    static class CrabMeleeAttackGoal
    extends MeleeAttackGoal {
        private final CoconutCrab crab;

        public CrabMeleeAttackGoal(CoconutCrab pMob, double pSpeedModifier, boolean pFollowingTargetEvenIfNotSeen) {
            super((PathfinderMob)pMob, pSpeedModifier, pFollowingTargetEvenIfNotSeen);
            this.crab = pMob;
        }

        public boolean canUse() {
            return this.crab.hasCoconut() && super.canUse();
        }

        public boolean canContinueToUse() {
            return this.crab.hasCoconut() && super.canContinueToUse();
        }
    }

    static class CrabHurtByTargetGoal
    extends HurtByTargetGoal {
        private final CoconutCrab crab;

        public CrabHurtByTargetGoal(CoconutCrab pMob) {
            super((PathfinderMob)pMob, new Class[0]);
            this.crab = pMob;
        }

        public boolean canUse() {
            return this.crab.hasCoconut() && super.canUse();
        }

        public boolean canContinueToUse() {
            return this.crab.hasCoconut() && super.canContinueToUse();
        }
    }

    static class CrabNearestAttackableTargetGoal<T extends LivingEntity>
    extends NearestAttackableTargetGoal<T> {
        private final CoconutCrab crab;

        public CrabNearestAttackableTargetGoal(CoconutCrab pMob, Class<T> pTargetType, int pRandomInterval, boolean pMustSee, boolean pMustReach, @Nullable Predicate<LivingEntity> pTargetPredicate) {
            super((Mob)pMob, pTargetType, pRandomInterval, pMustSee, pMustReach, pTargetPredicate);
            this.crab = pMob;
        }

        public boolean canUse() {
            return this.crab.hasCoconut() && super.canUse();
        }

        public boolean canContinueToUse() {
            return this.crab.hasCoconut() && super.canContinueToUse();
        }
    }
}

