/*
 * Decompiled with CFR 0.152.
 */
package samebutdifferent.ecologics.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import samebutdifferent.ecologics.client.model.PenguinModel;
import samebutdifferent.ecologics.entity.Penguin;

@OnlyIn(value=Dist.CLIENT)
public class PenguinHeldItemLayer
extends RenderLayer<Penguin, PenguinModel> {
    private final ItemInHandRenderer itemInHandRenderer;

    public PenguinHeldItemLayer(RenderLayerParent<Penguin, PenguinModel> renderLayerParent, ItemInHandRenderer itemInHandRenderer) {
        super(renderLayerParent);
        this.itemInHandRenderer = itemInHandRenderer;
    }

    public void render(PoseStack matrixStack, MultiBufferSource buffer, int packedLight, Penguin livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        matrixStack.pushPose();
        ((PenguinModel)this.getParentModel()).head.translateAndRotate(matrixStack);
        matrixStack.translate(0.1f, -0.05f, -0.2f);
        matrixStack.mulPose(Axis.XP.rotationDegrees(90.0f));
        matrixStack.mulPose(Axis.ZP.rotationDegrees(135.0f));
        ItemStack itemStack = livingEntity.getItemBySlot(EquipmentSlot.MAINHAND);
        this.itemInHandRenderer.renderItem((LivingEntity)livingEntity, itemStack, ItemDisplayContext.GROUND, false, matrixStack, buffer, packedLight);
        matrixStack.popPose();
    }
}

