/*
 * Decompiled with CFR 0.152.
 */
package samebutdifferent.ecologics.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.TurtleEggBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class SandcastleBlock
extends HorizontalDirectionalBlock {
    public static final MapCodec<SandcastleBlock> CODEC = SandcastleBlock.simpleCodec(SandcastleBlock::new);
    private static final VoxelShape SHAPE = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)7.0, (double)15.0);
    public static final IntegerProperty HATCH = BlockStateProperties.HATCH;
    public static final IntegerProperty EGGS_INSIDE = IntegerProperty.create((String)"eggs_inside", (int)0, (int)4);

    public SandcastleBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)EGGS_INSIDE, (Comparable)Integer.valueOf(0))).setValue((Property)HATCH, (Comparable)Integer.valueOf(0)));
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    public boolean canSurvive(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        return pLevel.getBlockState(pPos.below()).is(Blocks.SAND);
    }

    public BlockState updateShape(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        return pFacing == Direction.DOWN && !pState.canSurvive((LevelReader)pLevel, pCurrentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    public void stepOn(Level pLevel, BlockPos pPos, BlockState pState, Entity pEntity) {
        this.destroySandcastle(pLevel, pState, pPos, pEntity, 50);
    }

    public void fallOn(Level pLevel, BlockState pState, BlockPos pPos, Entity pEntity, float pFallDistance) {
        this.destroySandcastle(pLevel, pState, pPos, pEntity, 3);
    }

    private void destroySandcastle(Level pLevel, BlockState pState, BlockPos pPos, Entity pEntity, int chance) {
        if (this.canBreakSandcastle(pEntity) && !pLevel.isClientSide && pLevel.random.nextInt(chance) == 0) {
            pLevel.playSound(null, pPos, SoundEvents.SAND_FALL, SoundSource.BLOCKS, 1.0f, 1.0f);
            if ((Integer)pState.getValue((Property)EGGS_INSIDE) > 0) {
                pLevel.setBlockAndUpdate(pPos, (BlockState)((BlockState)Blocks.TURTLE_EGG.defaultBlockState().setValue((Property)TurtleEggBlock.EGGS, (Comparable)((Integer)pState.getValue((Property)EGGS_INSIDE)))).setValue((Property)TurtleEggBlock.HATCH, (Comparable)((Integer)pState.getValue((Property)HATCH))));
            } else {
                pLevel.destroyBlock(pPos, false);
            }
        }
    }

    private boolean canBreakSandcastle(Entity pEntity) {
        if (!(pEntity instanceof Turtle)) {
            if (!(pEntity instanceof LivingEntity)) {
                return false;
            }
            return pEntity instanceof Player;
        }
        return false;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)pContext.getHorizontalDirection().getOpposite());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{FACING, EGGS_INSIDE, HATCH});
    }

    public boolean isRandomlyTicking(BlockState pState) {
        return (Integer)pState.getValue((Property)EGGS_INSIDE) > 0;
    }

    public void randomTick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (this.shouldUpdateHatchLevel((Level)pLevel)) {
            int hatch = (Integer)pState.getValue((Property)HATCH);
            if (hatch < 2) {
                pLevel.playSound(null, pPos, SoundEvents.TURTLE_EGG_CRACK, SoundSource.BLOCKS, 0.7f, 0.9f + pRandom.nextFloat() * 0.2f);
                pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)HATCH, (Comparable)Integer.valueOf(hatch + 1)), 2);
            } else {
                pLevel.playSound(null, pPos, SoundEvents.TURTLE_EGG_HATCH, SoundSource.BLOCKS, 0.7f, 0.9f + pRandom.nextFloat() * 0.2f);
                pLevel.playSound(null, pPos, SoundEvents.SAND_BREAK, SoundSource.BLOCKS, 0.7f, 0.9f + pRandom.nextFloat() * 0.2f);
                pLevel.removeBlock(pPos, false);
                for (int i = 0; i < (Integer)pState.getValue((Property)EGGS_INSIDE); ++i) {
                    pLevel.levelEvent(2001, pPos, Block.getId((BlockState)pState));
                    Turtle turtle = (Turtle)EntityType.TURTLE.create((Level)pLevel);
                    turtle.setAge(-24000);
                    turtle.setHomePos(pPos);
                    turtle.moveTo((double)pPos.getX() + 0.3 + (double)i * 0.2, (double)pPos.getY(), (double)pPos.getZ() + 0.3, 0.0f, 0.0f);
                    pLevel.addFreshEntity((Entity)turtle);
                }
            }
        }
    }

    private boolean shouldUpdateHatchLevel(Level pLevel) {
        float time = pLevel.getTimeOfDay(1.0f);
        if ((double)time < 0.69 && (double)time > 0.65) {
            return true;
        }
        return pLevel.random.nextInt(2) == 0;
    }

    public void playerDestroy(Level pLevel, Player pPlayer, BlockPos pPos, BlockState pState, @Nullable BlockEntity pBlockEntity, ItemStack pTool) {
        super.playerDestroy(pLevel, pPlayer, pPos, pState, pBlockEntity, pTool);
        if ((Integer)pState.getValue((Property)EGGS_INSIDE) > 0) {
            pLevel.setBlockAndUpdate(pPos, (BlockState)((BlockState)Blocks.TURTLE_EGG.defaultBlockState().setValue((Property)TurtleEggBlock.EGGS, (Comparable)((Integer)pState.getValue((Property)EGGS_INSIDE)))).setValue((Property)TurtleEggBlock.HATCH, (Comparable)((Integer)pState.getValue((Property)HATCH))));
        }
    }
}

