/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.framework.api.client.screen.widget.element;

import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;

public abstract class Sound {
    public static final float DEFAULT_UI_VOLUME = 0.25f;
    public static final float DEFAULT_UI_PITCH = 1.0f;

    public abstract SoundEvent value();

    public abstract float volume();

    public abstract float pitch();

    public static Sound create(Holder<SoundEvent> holder) {
        return new Impl(() -> holder.value(), rand -> Float.valueOf(0.25f), rand -> Float.valueOf(1.0f));
    }

    public static Sound create(Holder<SoundEvent> holder, float volume, float pitch) {
        return new Impl(() -> holder.value(), rand -> Float.valueOf(volume), rand -> Float.valueOf(pitch));
    }

    public static Sound create(Holder<SoundEvent> holder, Function<RandomSource, Float> volumeFunction, Function<RandomSource, Float> pitchFunction) {
        return new Impl(() -> holder.value(), volumeFunction, pitchFunction);
    }

    public static Sound create(SoundEvent event) {
        return new Impl(() -> event, rand -> Float.valueOf(0.25f), rand -> Float.valueOf(1.0f));
    }

    public static Sound create(SoundEvent event, float volume, float pitch) {
        return new Impl(() -> event, rand -> Float.valueOf(volume), rand -> Float.valueOf(pitch));
    }

    public static Sound create(SoundEvent event, Function<RandomSource, Float> volumeFunction, Function<RandomSource, Float> pitchFunction) {
        return new Impl(() -> event, volumeFunction, pitchFunction);
    }

    public static Sound create(Supplier<SoundEvent> sound) {
        return new Impl(sound, rand -> Float.valueOf(0.25f), rand -> Float.valueOf(1.0f));
    }

    public static Sound create(Supplier<SoundEvent> sound, float volume, float pitch) {
        return new Impl(sound, rand -> Float.valueOf(volume), rand -> Float.valueOf(pitch));
    }

    public static Sound create(Supplier<SoundEvent> sound, Function<RandomSource, Float> volumeFunction, Function<RandomSource, Float> pitchFunction) {
        return new Impl(sound, volumeFunction, pitchFunction);
    }

    private static class Impl
    extends Sound {
        private static final RandomSource RANDOM = RandomSource.create();
        private final Supplier<SoundEvent> soundSupplier;
        private final Function<RandomSource, Float> volumeFunction;
        private final Function<RandomSource, Float> pitchFunction;

        private Impl(Supplier<SoundEvent> soundSupplier, Function<RandomSource, Float> volumeFunction, Function<RandomSource, Float> pitchFunction) {
            this.soundSupplier = soundSupplier;
            this.volumeFunction = volumeFunction;
            this.pitchFunction = pitchFunction;
        }

        @Override
        public SoundEvent value() {
            return this.soundSupplier.get();
        }

        @Override
        public float volume() {
            return this.volumeFunction.apply(RANDOM).floatValue();
        }

        @Override
        public float pitch() {
            return this.pitchFunction.apply(RANDOM).floatValue();
        }
    }
}

