/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.framework.api.client.screen.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mrcrayfish.framework.api.client.screen.widget.element.Icon;
import com.mrcrayfish.framework.api.client.screen.widget.layout.Border;
import com.mrcrayfish.framework.api.client.screen.widget.layout.Padding;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractContainerWidget;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.Nullable;

public final class FrameworkEditBox
extends AbstractContainerWidget {
    private static final WidgetSprites DEFAULT_SPRITES = new WidgetSprites(ResourceLocation.withDefaultNamespace((String)"widget/text_field"), ResourceLocation.withDefaultNamespace((String)"widget/text_field_highlighted"));
    public static final Padding DEFAULT_PADDING = Padding.of(4, 0, 4, 0);
    public static final Border DEFAULT_BORDER = Border.of(1);
    private final LinearLayout layout = LinearLayout.horizontal();
    @Nullable
    private final Icon icon;
    @Nullable
    private final CenteredSpriteWidget iconWidget;
    private final Border border;
    private final Padding padding;
    private final int spacing;
    @Nullable
    private final WidgetSprites background;
    @Nullable
    private final Supplier<Boolean> activeSupplier;
    private final EditBox editBox;
    private final boolean clearOnRightClick;

    private FrameworkEditBox(int x, int y, int width, int height, Function<FrameworkEditBox, Icon> icon, Padding padding, int spacing, @Nullable WidgetSprites background, Border border, String text, @Nullable String suggestion, @Nullable Component hint, @Nullable Consumer<String> callback, @Nullable Predicate<String> valueFilter, @Nullable BiFunction<String, Integer, FormattedCharSequence> styleFormatter, @Nullable Supplier<Boolean> activeSupplier, @Nullable Integer maxTextLength, boolean clearOnRightClick, @Nullable Integer iconWidthOverride) {
        super(x, y, width, height, CommonComponents.EMPTY);
        this.icon = icon.apply(this);
        this.padding = padding;
        this.spacing = spacing;
        this.background = background;
        this.border = border;
        this.activeSupplier = activeSupplier;
        this.clearOnRightClick = clearOnRightClick;
        this.layout.spacing(spacing);
        if (this.icon != null) {
            int iconWidth = iconWidthOverride != null ? iconWidthOverride.intValue() : this.icon.width();
            this.iconWidget = (CenteredSpriteWidget)this.layout.addChild((LayoutElement)new CenteredSpriteWidget(iconWidth, 0, this.icon), layoutSettings -> layoutSettings.paddingTop(border.top() + padding.top()).paddingBottom(border.bottom() + padding.bottom()).paddingLeft(padding.left() + border.left()));
        } else {
            this.iconWidget = null;
        }
        this.editBox = (EditBox)this.layout.addChild((LayoutElement)new Impl(this), layoutSettings -> {
            layoutSettings.paddingRight(border.right() + padding.right()).paddingTop(border.top() + padding.top()).paddingBottom(border.bottom() + padding.bottom());
            if (this.icon == null) {
                layoutSettings.paddingLeft(border.left() + padding.left());
            }
        });
        this.updateEditBoxWidth();
        if (valueFilter != null) {
            this.editBox.setFilter(valueFilter);
        }
        if (maxTextLength != null) {
            this.editBox.setMaxLength(maxTextLength.intValue());
        }
        this.editBox.setValue(text);
        this.editBox.setSuggestion(suggestion);
        if (hint != null) {
            this.editBox.setHint(hint);
        }
        if (callback != null) {
            this.editBox.setResponder(callback);
        }
        if (styleFormatter != null) {
            this.editBox.setFormatter(styleFormatter);
        }
        this.setSize(width, height);
    }

    private void updateEditBoxWidth() {
        if (this.iconWidget != null) {
            this.editBox.setWidth(this.getWidth() - (this.border.left() + this.padding.left() + this.iconWidget.getWidth() + this.spacing + this.padding.right() + this.border.right()));
        } else {
            this.editBox.setWidth(this.getWidth() - (this.border.left() + this.padding.left() + this.padding.right() + this.border.right()));
        }
    }

    public void setX(int x) {
        super.setX(x);
        this.layout.setX(x);
    }

    public void setY(int y) {
        super.setY(y);
        this.layout.setY(y);
    }

    public void setWidth(int width) {
        super.setWidth(width);
        this.updateEditBoxWidth();
        this.layout.arrangeElements();
    }

    public void setHeight(int height) {
        super.setHeight(height);
        this.updateEditBoxWidth();
        int contentHeight = height - (this.border.top() + this.padding.top() + this.padding.bottom() + this.border.bottom());
        this.editBox.setHeight(contentHeight);
        if (this.iconWidget != null) {
            this.iconWidget.setHeight(contentHeight);
        }
        this.layout.arrangeElements();
    }

    public void setSize(int width, int height) {
        this.setWidth(width);
        this.setHeight(height);
    }

    protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        if (this.activeSupplier != null) {
            boolean active;
            this.active = active = this.activeSupplier.get().booleanValue();
            this.editBox.active = active;
        }
        if (this.background != null) {
            RenderSystem.enableBlend();
            RenderSystem.enableDepthTest();
            graphics.setColor(1.0f, 1.0f, 1.0f, this.editBox.isActive() ? 1.0f : 0.5f);
            ResourceLocation background = this.background.get(this.editBox.isActive(), this.editBox.isFocused());
            graphics.blitSprite(background, this.getX(), this.getY(), this.getWidth(), this.getHeight());
            graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
            RenderSystem.disableBlend();
        }
        this.layout.visitWidgets(widget -> widget.render(graphics, mouseX, mouseY, partialTick));
    }

    protected void updateWidgetNarration(NarrationElementOutput output) {
        this.editBox.updateNarration(output);
    }

    public List<? extends GuiEventListener> children() {
        return List.of(this.editBox);
    }

    public void setFocused(boolean focused) {
        super.setFocused(focused);
        this.editBox.setFocused(focused);
    }

    public String getText() {
        return this.editBox.getValue();
    }

    public EditBox getEditBox() {
        return this.editBox;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static final class CenteredSpriteWidget
    extends AbstractWidget {
        private final Icon icon;

        public CenteredSpriteWidget(int width, int height, Icon icon) {
            super(0, 0, width, height, CommonComponents.EMPTY);
            this.icon = icon;
        }

        protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
            int iconX = this.getX() + (this.getWidth() - this.icon.width()) / 2;
            int iconY = this.getY() + (this.getHeight() - this.icon.height()) / 2;
            this.icon.draw(graphics, iconX, iconY, partialTick);
        }

        protected void updateWidgetNarration(NarrationElementOutput output) {
        }
    }

    private static class Impl
    extends EditBox {
        private final FrameworkEditBox parent;
        private boolean drawing;

        private Impl(FrameworkEditBox parent) {
            super(Minecraft.getInstance().font, 0, 0, CommonComponents.EMPTY);
            this.setBordered(false);
            this.parent = parent;
        }

        public boolean isBordered() {
            return false;
        }

        public int getY() {
            if (this.drawing) {
                return super.getY() + (this.getHeight() - 8) / 2;
            }
            return super.getY();
        }

        public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
            this.drawing = true;
            super.renderWidget(graphics, mouseX, mouseY, partialTick);
            this.drawing = false;
        }

        protected boolean clicked(double mouseX, double mouseY) {
            return this.visible && this.active && mouseX >= (double)this.parent.getX() && mouseY >= (double)this.parent.getY() && mouseX < (double)(this.parent.getX() + this.parent.getWidth()) && mouseY < (double)(this.parent.getY() + this.parent.getHeight());
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            if (this.parent.clearOnRightClick && this.active && this.visible && button == 1 && this.clicked(mouseX, mouseY)) {
                this.setValue("");
                return true;
            }
            return super.mouseClicked(mouseX, mouseY, button);
        }
    }

    public static class Builder {
        private int x;
        private int y;
        private int width = 100;
        private int height = 16;
        private Function<FrameworkEditBox, Icon> icon = editBox1 -> null;
        private Border border = DEFAULT_BORDER;
        private Padding padding = DEFAULT_PADDING;
        private int spacing = 4;
        @Nullable
        private WidgetSprites background = DEFAULT_SPRITES;
        private String text = "";
        @Nullable
        private String suggestion;
        @Nullable
        private Consumer<String> callback;
        @Nullable
        private Predicate<String> valueFilter;
        @Nullable
        private BiFunction<String, Integer, FormattedCharSequence> styleFormatter;
        @Nullable
        private Component hint;
        @Nullable
        private Supplier<Boolean> active;
        @Nullable
        private Integer maxTextLength;
        private boolean clearOnRightClick = true;
        @Nullable
        private Integer iconWidthOverride;

        public FrameworkEditBox build() {
            return new FrameworkEditBox(this.x, this.y, this.width, this.height, this.icon, this.padding, this.spacing, this.background, this.border, this.text, this.suggestion, this.hint, this.callback, this.valueFilter, this.styleFormatter, this.active, this.maxTextLength, this.clearOnRightClick, this.iconWidthOverride);
        }

        public Builder setX(int x) {
            this.x = x;
            return this;
        }

        public Builder setY(int y) {
            this.y = y;
            return this;
        }

        public Builder setPosition(int x, int y) {
            this.x = x;
            this.y = y;
            return this;
        }

        public Builder setWidth(int width) {
            this.width = width;
            return this;
        }

        public Builder setHeight(int height) {
            this.height = height;
            return this;
        }

        public Builder setSize(int width, int height) {
            this.width = width;
            this.height = height;
            return this;
        }

        public Builder setIcon(ResourceLocation sprite, int width, int height) {
            this.icon = editBox -> Icon.sprite(sprite, width, height);
            return this;
        }

        public Builder setIcon(Supplier<ResourceLocation> sprite, int width, int height) {
            this.icon = editBox -> Icon.sprite(sprite, width, height);
            return this;
        }

        public Builder setIcon(Function<FrameworkEditBox, Supplier<ResourceLocation>> sprite, int width, int height) {
            this.icon = editBox -> Icon.sprite((Supplier)sprite.apply((FrameworkEditBox)((Object)editBox)), width, height);
            return this;
        }

        public Builder setIcon(@Nullable Icon icon) {
            this.icon = editBox -> icon;
            return this;
        }

        public Builder setIcon(Function<FrameworkEditBox, Icon> icon) {
            this.icon = icon;
            return this;
        }

        public Builder setIconWidth(int width) {
            this.iconWidthOverride = width;
            return this;
        }

        public Builder setSpacing(int spacing) {
            this.spacing = spacing;
            return this;
        }

        public Builder setPadding(int padding) {
            this.padding = Padding.of(padding, padding, padding, padding);
            return this;
        }

        public Builder setPadding(int left, int top, int right, int bottom) {
            this.padding = Padding.of(left, top, right, bottom);
            return this;
        }

        public Builder setPadding(Padding padding) {
            this.padding = padding;
            return this;
        }

        public Builder setBackground(@Nullable WidgetSprites background) {
            this.background = background;
            return this;
        }

        public Builder noBackground() {
            this.background = null;
            return this;
        }

        public Builder setBorder(int border) {
            this.border = Border.of(border);
            return this;
        }

        public Builder setBorder(int left, int top, int right, int bottom) {
            this.border = Border.of(left, top, right, bottom);
            return this;
        }

        public Builder setBorder(Border border) {
            this.border = border;
            return this;
        }

        public Builder setInitialText(String text) {
            this.text = text;
            return this;
        }

        public Builder setMaxTextLength(int maxTextLength) {
            this.maxTextLength = maxTextLength;
            return this;
        }

        public Builder setCallback(@Nullable Consumer<String> callback) {
            this.callback = callback;
            return this;
        }

        public Builder setValueFilter(@Nullable Predicate<String> valueFilter) {
            this.valueFilter = valueFilter;
            return this;
        }

        public Builder setStyleFormatter(@Nullable BiFunction<String, Integer, FormattedCharSequence> styleFormatter) {
            this.styleFormatter = styleFormatter;
            return this;
        }

        public Builder setHint(@Nullable Component hint) {
            this.hint = hint;
            return this;
        }

        public Builder setDependent(Supplier<Boolean> active) {
            this.active = active;
            return this;
        }

        public Builder setClearOnRightClick(boolean clearOnRightClick) {
            this.clearOnRightClick = clearOnRightClick;
            return this;
        }
    }
}

