/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.framework.api.client.screen.widget;

import com.mrcrayfish.framework.api.client.screen.widget.FrameworkButton;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public final class Buttons {
    private Buttons() {
    }

    public static FrameworkButton.Builder createOnOff(Supplier<Boolean> getter, Consumer<Boolean> setter) {
        return Buttons.createOnOff(getter, setter, (Boolean newValue) -> {});
    }

    public static FrameworkButton.Builder createOnOff(Supplier<Boolean> getter, Consumer<Boolean> setter, Consumer<Boolean> onChanged) {
        return FrameworkButton.builder().setAction(btn -> {
            boolean newValue = (Boolean)getter.get() == false;
            setter.accept(newValue);
            onChanged.accept(newValue);
        }).setLabel(() -> CommonComponents.optionStatus((boolean)((Boolean)getter.get())));
    }

    public static FrameworkButton.Builder createOnOff(Component label, Supplier<Boolean> getter, Consumer<Boolean> setter) {
        return Buttons.createOnOff(label, getter, setter, value -> {});
    }

    public static FrameworkButton.Builder createOnOff(Component label, Supplier<Boolean> getter, Consumer<Boolean> setter, Consumer<Boolean> onChanged) {
        return FrameworkButton.builder().setAction(btn -> {
            boolean newValue = (Boolean)getter.get() == false;
            setter.accept(newValue);
            onChanged.accept(newValue);
        }).setLabel(() -> CommonComponents.optionStatus((Component)label, (boolean)((Boolean)getter.get())));
    }

    public static FrameworkButton.Builder createToggle(Supplier<Boolean> getter, Consumer<Boolean> setter) {
        return Buttons.createToggle(CommonComponents.EMPTY, getter, setter, newValue -> {});
    }

    public static FrameworkButton.Builder createToggle(Supplier<Boolean> getter, Consumer<Boolean> setter, Consumer<Boolean> onChanged) {
        return Buttons.createToggle(CommonComponents.EMPTY, getter, setter, onChanged);
    }

    public static FrameworkButton.Builder createToggle(Component label, Supplier<Boolean> getter, Consumer<Boolean> setter) {
        return Buttons.createToggle(label, getter, setter, newValue -> {});
    }

    public static FrameworkButton.Builder createToggle(Component label, Supplier<Boolean> getter, Consumer<Boolean> setter, Consumer<Boolean> onChanged) {
        return FrameworkButton.builder().setContentRenderer(new FrameworkButton.ToggleContentRenderer(getter)).setLabel(label).setAction(btn -> {
            boolean newValue = (Boolean)getter.get() == false;
            setter.accept(newValue);
            onChanged.accept(newValue);
        });
    }

    public static <T extends Enum<T>> FrameworkButton.Builder createValues(Function<T, Component> label, Supplier<T> getter, Consumer<T> setter) {
        return Buttons.createValues(label, t -> null, getter, setter, newValue -> {});
    }

    public static <T extends Enum<T>> FrameworkButton.Builder createValues(Function<T, Component> label, Supplier<T> getter, Consumer<T> setter, Consumer<T> onChanged) {
        return Buttons.createValues(label, t -> null, getter, setter, onChanged);
    }

    public static <T extends Enum<T>> FrameworkButton.Builder createValues(Function<T, Component> label, Function<T, @Nullable Component> tooltip, Supplier<T> getter, Consumer<T> setter, Consumer<T> onChanged) {
        return FrameworkButton.builder().setLabel(() -> (Component)label.apply((Enum)getter.get())).setTooltip(btn -> {
            Component text = (Component)tooltip.apply((Enum)getter.get());
            return text != null ? Tooltip.create((Component)text) : null;
        }).setAction(btn -> {
            Enum currentValue = (Enum)getter.get();
            Enum[] values = (Enum[])currentValue.getDeclaringClass().getEnumConstants();
            Enum nextValue = values[(currentValue.ordinal() + 1) % values.length];
            setter.accept(nextValue);
            onChanged.accept(nextValue);
        });
    }
}

