/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.worldgen.feature.misc;

import biomesoplenty.api.block.BOPBlocks;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class OrangeMapleLeafPileFeature
extends Feature<NoneFeatureConfiguration> {
    public OrangeMapleLeafPileFeature(Codec<NoneFeatureConfiguration> deserializer) {
        super(deserializer);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> featurePlaceContext) {
        WorldGenLevel world = featurePlaceContext.level();
        ChunkGenerator chunkGenerator = featurePlaceContext.chunkGenerator();
        RandomSource rand = featurePlaceContext.random();
        BlockPos pos = featurePlaceContext.origin();
        NoneFeatureConfiguration config = (NoneFeatureConfiguration)featurePlaceContext.config();
        int i = 0;
        for (int j = 0; j < 64; ++j) {
            BlockPos blockpos = pos.offset(rand.nextInt(8) - rand.nextInt(8), rand.nextInt(4) - rand.nextInt(4), rand.nextInt(8) - rand.nextInt(8));
            if (!TreeFeature.isAirOrLeaves((LevelSimulatedReader)world, (BlockPos)blockpos) || world.getBlockState(blockpos.below()).getBlock() != Blocks.GRASS_BLOCK) continue;
            for (int k = 0; k < 16; ++k) {
                if (world.getBlockState(blockpos.above(k)).getBlock() != BOPBlocks.ORANGE_MAPLE_LEAVES) continue;
                world.setBlock(blockpos, BOPBlocks.ORANGE_MAPLE_LEAF_PILE.defaultBlockState(), 2);
                ++i;
            }
        }
        return i > 0;
    }
}

