/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.core.other;

import com.teamabnormals.blueprint.core.util.BlockUtil;
import com.teamabnormals.blueprint.core.util.TradeUtil;
import com.teamabnormals.upgrade_aquatic.api.util.UAEntityPredicates;
import com.teamabnormals.upgrade_aquatic.common.block.BedrollBlock;
import com.teamabnormals.upgrade_aquatic.common.entity.animal.Lionfish;
import com.teamabnormals.upgrade_aquatic.common.entity.animal.Pike;
import com.teamabnormals.upgrade_aquatic.common.entity.monster.Thrasher;
import com.teamabnormals.upgrade_aquatic.core.UAConfig;
import com.teamabnormals.upgrade_aquatic.core.registry.UABlocks;
import com.teamabnormals.upgrade_aquatic.core.registry.UACriteriaTriggers;
import com.teamabnormals.upgrade_aquatic.core.registry.UAItems;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Optional;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAwardStatsPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.ServerStatsCounter;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.Dolphin;
import net.minecraft.world.entity.animal.TropicalFish;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.EntityMountEvent;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;
import net.neoforged.neoforge.event.entity.player.CanPlayerSleepEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.entity.player.PlayerSetSpawnEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.event.village.VillagerTradesEvent;
import net.neoforged.neoforge.event.village.WandererTradesEvent;
import net.neoforged.neoforge.fluids.FluidType;

@EventBusSubscriber(modid="upgrade_aquatic")
public class UAEvents {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onEntitySpawned(EntityJoinLevelEvent event) {
        if (event.getLevel().isClientSide) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof Drowned) {
            Drowned drowned = (Drowned)entity;
            drowned.goalSelector.addGoal(3, (Goal)new AvoidEntityGoal((PathfinderMob)drowned, Turtle.class, 6.0f, 1.0, 1.2));
        }
        if (entity instanceof AbstractFish) {
            AbstractFish fish = (AbstractFish)entity;
            fish.goalSelector.addGoal(2, (Goal)new AvoidEntityGoal((PathfinderMob)fish, Pike.class, 8.0f, 1.6, 1.4, UAEntityPredicates.IS_HIDING_IN_PICKERELWEED::test));
            if (entity instanceof TropicalFish) {
                fish.goalSelector.addGoal(2, (Goal)new AvoidEntityGoal((PathfinderMob)fish, Lionfish.class, 8.0f, 1.6, 1.4, EntitySelector.ENTITY_STILL_ALIVE::test));
            }
        }
        if (entity instanceof WaterAnimal) {
            WaterAnimal waterAnimal = (WaterAnimal)entity;
            if (!(entity instanceof Enemy)) {
                if (entity instanceof Dolphin) {
                    Dolphin dolphin = (Dolphin)entity;
                    dolphin.targetSelector.addGoal(0, (Goal)new HurtByTargetGoal((PathfinderMob)dolphin, new Class[]{Thrasher.class}).setAlertOthers(new Class[0]));
                    dolphin.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal((PathfinderMob)dolphin, 1.2, true));
                } else {
                    waterAnimal.goalSelector.addGoal(1, (Goal)new AvoidEntityGoal((PathfinderMob)waterAnimal, Thrasher.class, 20.0f, 1.4, 1.6, EntitySelector.ENTITY_STILL_ALIVE::test));
                }
            }
        }
    }

    @SubscribeEvent
    public static void onEntityUpdate(EntityTickEvent.Post event) {
        ServerPlayer serverPlayer;
        ServerStatsCounter statisticsManager;
        LivingEntity livingEntity;
        LivingEntity entity;
        Entity entity2 = event.getEntity();
        if (entity2 instanceof LivingEntity && (entity = (LivingEntity)entity2) instanceof Phantom && (livingEntity = ((Phantom)entity).getTarget()) instanceof ServerPlayer && (statisticsManager = (serverPlayer = (ServerPlayer)livingEntity).getStats()).getValue(Stats.CUSTOM.get((Object)Stats.TIME_SINCE_REST)) < 72000) {
            ((Phantom)entity).setTarget(null);
        }
    }

    @SubscribeEvent
    public static void onPlayerSleep(CanPlayerSleepEvent event) {
        ServerPlayer player = event.getEntity();
        BlockState state = player.getCommandSenderWorld().getBlockState(event.getPos());
        if (event.getProblem() == null && state.getFluidState().getAmount() == 8 && state.getBlock() instanceof BedrollBlock && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = player;
            if (player.isAlive() && !player.level().isClientSide()) {
                ((PlayerTrigger)UACriteriaTriggers.SLEEP_UNDERWATER.get()).trigger(serverPlayer);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerSetSpawn(PlayerSetSpawnEvent event) {
        Player entity = event.getEntity();
        BlockPos spawn = event.getNewSpawn();
        if (spawn != null && entity.getCommandSenderWorld().getBlockState(spawn).getBlock() instanceof BedrollBlock) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLivingDrops(LivingDropsEvent event) {
        if (event.getEntity() instanceof Pike && event.getEntity().isOnFire()) {
            Level level = event.getEntity().level();
            for (ItemEntity itemEntity : event.getDrops()) {
                ItemStack itemstack;
                ItemStack stack = itemEntity.getItem();
                Optional optional = level.getRecipeManager().getRecipeFor(RecipeType.SMELTING, (RecipeInput)new SingleRecipeInput(stack), level);
                if (!optional.isPresent() || (itemstack = ((SmeltingRecipe)((RecipeHolder)optional.get()).value()).getResultItem((HolderLookup.Provider)level.registryAccess())).isEmpty()) continue;
                ItemStack itemstack1 = itemstack.copy();
                itemstack1.setCount(stack.getCount() * itemstack.getCount());
                itemEntity.setItem(itemstack1);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        Level level = player.level();
        if (!level.isClientSide() && level.getGameTime() % 5L == 0L && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ServerStatsCounter statisticsManager = serverPlayer.getStats();
            Object2IntOpenHashMap object2intmap = new Object2IntOpenHashMap();
            object2intmap.put((Object)Stats.CUSTOM.get((Object)Stats.TIME_SINCE_REST), statisticsManager.getValue(Stats.CUSTOM.get((Object)Stats.TIME_SINCE_REST)));
            serverPlayer.connection.send((Packet)new ClientboundAwardStatsPacket((Object2IntMap)object2intmap));
        }
        ItemStack headSlotStack = player.getItemBySlot(EquipmentSlot.HEAD);
        if (player.isEffectiveAi() && !headSlotStack.isEmpty() && headSlotStack.is(Items.TURTLE_HELMET) && ((Boolean)UAConfig.COMMON.turtleShellRework.get()).booleanValue()) {
            int timeTillDamage;
            int enchLevel = headSlotStack.getEnchantmentLevel((Holder)level.registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(Enchantments.UNBREAKING));
            int n = timeTillDamage = enchLevel > 0 ? 40 * (1 + enchLevel / 2) : 40;
            if (player.isEyeInFluidType((FluidType)NeoForgeMod.WATER_TYPE.value())) {
                player.addEffect(new MobEffectInstance(MobEffects.WATER_BREATHING, 100));
                if (level.getGameTime() % (long)timeTillDamage == 0L) {
                    headSlotStack.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.HEAD);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerMount(EntityMountEvent event) {
        Entity mountingEntity = event.getEntityMounting();
        Entity entityBeingMounted = event.getEntityBeingMounted();
        if (mountingEntity instanceof Player) {
            Player player = (Player)mountingEntity;
            if (entityBeingMounted instanceof Thrasher) {
                Thrasher thrasher = (Thrasher)entityBeingMounted;
                if (event.isDismounting() && player.isAlive() && !player.isCreative() && !player.isSpectator() && thrasher.isAlive() && !thrasher.isStunned()) {
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        Block livingCoral;
        ResourceLocation name;
        String path;
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        BlockState state = level.getBlockState(pos);
        Player player = event.getEntity();
        ItemStack stack = event.getItemStack();
        RandomSource random = player.getRandom();
        if (stack.is(Items.GLOW_INK_SAC) && ((path = (name = BuiltInRegistries.BLOCK.getKey((Object)state.getBlock())).getPath()).contains("dead") || path.contains("elder")) && path.contains("coral") && !path.contains("coralstone") && (livingCoral = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)name.getNamespace(), (String)path.replace("dead_", "").replace("elder_", "")))) != Blocks.AIR) {
            level.setBlockAndUpdate(pos, BlockUtil.transferAllBlockStates((BlockState)state, (BlockState)livingCoral.defaultBlockState()));
            level.scheduleTick(pos, livingCoral, 60 + level.getRandom().nextInt(40));
            level.playSound(player, pos, SoundEvents.SQUID_SQUIRT, SoundSource.BLOCKS, 1.0f, 1.0f);
            for (int i = 0; i < 5; ++i) {
                double d1 = random.nextGaussian() * 0.02;
                double d6 = (double)pos.getX() + random.nextDouble();
                double d7 = (double)pos.getY() + random.nextDouble() * state.getShape((BlockGetter)level, pos).max(Direction.Axis.Y);
                double d8 = (double)pos.getZ() + random.nextDouble();
                level.addParticle((ParticleOptions)ParticleTypes.GLOW_SQUID_INK, d6, d7, d8, d1, d1, d1);
            }
            if (!player.getAbilities().instabuild) {
                player.getItemInHand(event.getHand()).shrink(1);
            }
            event.setCancellationResult(InteractionResult.sidedSuccess((boolean)level.isClientSide()));
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onWandererTradesEvent(WandererTradesEvent event) {
        TradeUtil.addWandererTrades((WandererTradesEvent)event, (VillagerTrades.ItemListing[])new VillagerTrades.ItemListing[]{new TradeUtil.BlueprintTrade(1, ((Block)UABlocks.BEACHGRASS.get()).asItem(), 1, 12, 1), new TradeUtil.BlueprintTrade(1, ((Block)UABlocks.WHITE_SEAROCKET.get()).asItem(), 1, 8, 1), new TradeUtil.BlueprintTrade(1, ((Block)UABlocks.PINK_SEAROCKET.get()).asItem(), 1, 8, 1), new TradeUtil.BlueprintTrade(1, ((Block)UABlocks.PICKERELWEED.get()).asItem(), 1, 8, 1), new TradeUtil.BlueprintTrade(3, ((Block)UABlocks.FINGER_CORAL_BLOCK.get()).asItem(), 1, 8, 1), new TradeUtil.BlueprintTrade(3, ((Block)UABlocks.ACAN_CORAL_BLOCK.get()).asItem(), 1, 8, 1), new TradeUtil.BlueprintTrade(3, ((Block)UABlocks.BRANCH_CORAL_BLOCK.get()).asItem(), 1, 8, 1), new TradeUtil.BlueprintTrade(3, ((Block)UABlocks.PILLOW_CORAL_BLOCK.get()).asItem(), 1, 8, 1), new TradeUtil.BlueprintTrade(3, ((Block)UABlocks.SILK_CORAL_BLOCK.get()).asItem(), 1, 8, 1), new TradeUtil.BlueprintTrade(3, ((Block)UABlocks.PETAL_CORAL_BLOCK.get()).asItem(), 1, 8, 1), new TradeUtil.BlueprintTrade(3, ((Block)UABlocks.MOSS_CORAL_BLOCK.get()).asItem(), 1, 8, 1), new TradeUtil.BlueprintTrade(3, ((Block)UABlocks.ROCK_CORAL_BLOCK.get()).asItem(), 1, 8, 1), new TradeUtil.BlueprintTrade(3, ((Block)UABlocks.STAR_CORAL_BLOCK.get()).asItem(), 1, 8, 1), new TradeUtil.BlueprintTrade(3, ((Block)UABlocks.CHROME_CORAL_BLOCK.get()).asItem(), 1, 8, 1), new TradeUtil.BlueprintTrade(5, ((Block)UABlocks.EMBEDDED_AMMONITE.get()).asItem(), 1, 5, 1)});
        TradeUtil.addRareWandererTrades((WandererTradesEvent)event, (VillagerTrades.ItemListing[])new VillagerTrades.ItemListing[]{new TradeUtil.BlueprintTrade(2, ((Block)UABlocks.DRIFTWOOD_LOG.get()).asItem(), 1, 16, 1), new TradeUtil.BlueprintTrade(5, (Item)UAItems.PIKE_BUCKET.get(), 1, 4, 1), new TradeUtil.BlueprintTrade(5, (Item)UAItems.LIONFISH_BUCKET.get(), 1, 4, 1), new TradeUtil.BlueprintTrade(5, (Item)UAItems.NAUTILUS_BUCKET.get(), 1, 4, 1)});
    }

    @SubscribeEvent
    public static void onVillagerTradesEvent(VillagerTradesEvent event) {
        TradeUtil.addVillagerTrades((VillagerTradesEvent)event, (VillagerProfession)VillagerProfession.FARMER, (int)2, (VillagerTrades.ItemListing[])new VillagerTrades.ItemListing[]{new TradeUtil.BlueprintTrade(1, (Item)UAItems.MULBERRY.get(), 5, 16, 5)});
        if (event.getType().equals((Object)VillagerProfession.FISHERMAN)) {
            TradeUtil.addVillagerTrades((VillagerTradesEvent)event, (int)2, (VillagerTrades.ItemListing[])new VillagerTrades.ItemListing[]{new TradeUtil.BlueprintTrade(new ItemStack((ItemLike)UAItems.PERCH.get(), 6), new ItemStack((ItemLike)Items.EMERALD), new ItemStack((ItemLike)UAItems.COOKED_PERCH.get(), 6), 16, 5, 0.05f)});
            TradeUtil.addVillagerTrades((VillagerTradesEvent)event, (int)3, (VillagerTrades.ItemListing[])new VillagerTrades.ItemListing[]{new TradeUtil.BlueprintTrade((Item)UAItems.PERCH.get(), 14, 1, 16, 20), new TradeUtil.BlueprintTrade(new ItemStack((ItemLike)UAItems.PIKE.get(), 6), new ItemStack((ItemLike)Items.EMERALD), new ItemStack((ItemLike)UAItems.COOKED_PIKE.get(), 6), 16, 10, 0.05f)});
            TradeUtil.addVillagerTrades((VillagerTradesEvent)event, (int)4, (VillagerTrades.ItemListing[])new VillagerTrades.ItemListing[]{new TradeUtil.BlueprintTrade((Item)UAItems.PIKE.get(), 5, 1, 16, 25), new TradeUtil.BlueprintTrade(new ItemStack((ItemLike)UAItems.LIONFISH.get(), 6), new ItemStack((ItemLike)Items.EMERALD), new ItemStack((ItemLike)UAItems.COOKED_LIONFISH.get(), 6), 16, 15, 0.05f)});
            TradeUtil.addVillagerTrades((VillagerTradesEvent)event, (int)5, (VillagerTrades.ItemListing[])new VillagerTrades.ItemListing[]{new TradeUtil.BlueprintTrade((Item)UAItems.LIONFISH.get(), 3, 1, 16, 30)});
        }
        TradeUtil.addVillagerTrades((VillagerTradesEvent)event, (VillagerProfession)VillagerProfession.MASON, (int)5, (VillagerTrades.ItemListing[])new VillagerTrades.ItemListing[]{new TradeUtil.BlueprintTrade(5, ((Block)UABlocks.TOOTH_TILES.get()).asItem(), 1, 12, 30), new TradeUtil.BlueprintTrade(5, ((Block)UABlocks.TOOTH_BRICKS.get()).asItem(), 1, 12, 30)});
        if (((Boolean)UAConfig.COMMON.clericsBuyThrasherTeeth.get()).booleanValue()) {
            TradeUtil.addVillagerTrades((VillagerTradesEvent)event, (VillagerProfession)VillagerProfession.CLERIC, (int)4, (VillagerTrades.ItemListing[])new VillagerTrades.ItemListing[]{new TradeUtil.BlueprintTrade((Item)UAItems.THRASHER_TOOTH.get(), 1, 1, 12, 15)});
        }
        if (((Boolean)UAConfig.COMMON.leatherworkersSellBedrolls.get()).booleanValue()) {
            TradeUtil.addVillagerTrades((VillagerTradesEvent)event, (VillagerProfession)VillagerProfession.LEATHERWORKER, (int)2, (VillagerTrades.ItemListing[])new VillagerTrades.ItemListing[]{new TradeUtil.BlueprintTrade(1, ((Block)UABlocks.BEDROLL.get()).asItem(), 1, 8, 10)});
        }
    }
}

