/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.core.other;

import com.teamabnormals.blueprint.core.util.BlockUtil;
import com.teamabnormals.blueprint.core.util.DataUtil;
import com.teamabnormals.upgrade_aquatic.core.registry.UAItems;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.item.DispensibleContainerItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class UADispenserBehaviors {
    public static DispenseItemBehavior EMPTY_FISH_BUCKET_BEHAVIOR = new DefaultDispenseItemBehavior(){
        private final DefaultDispenseItemBehavior defaultDispenseItemBehavior = new DefaultDispenseItemBehavior();

        public ItemStack execute(BlockSource source, ItemStack stack) {
            DispensibleContainerItem item = (DispensibleContainerItem)stack.getItem();
            BlockPos pos = source.pos().relative((Direction)source.state().getValue((Property)DispenserBlock.FACING));
            ServerLevel level = source.level();
            if (item.emptyContents(null, (Level)level, pos, null, stack)) {
                item.checkExtraContent(null, (Level)level, stack, pos);
                return this.consumeWithRemainder(source, stack, new ItemStack((ItemLike)Items.BUCKET));
            }
            return this.defaultDispenseItemBehavior.dispense(source, stack);
        }
    };
    public static DispenseItemBehavior FILL_FISH_BUCKET_BEHAVIOR = new DefaultDispenseItemBehavior(){
        private final DefaultDispenseItemBehavior defaultDispenseItemBehavior = new DefaultDispenseItemBehavior();

        protected ItemStack execute(BlockSource source, ItemStack stack) {
            LivingEntity entity2;
            BlockPos pos = source.pos().relative((Direction)source.state().getValue((Property)DispenserBlock.FACING));
            ServerLevel level = source.level();
            List entities = level.getEntitiesOfClass(LivingEntity.class, new AABB(pos), entity -> entity instanceof Bucketable);
            if (!entities.isEmpty() && (entity2 = (LivingEntity)entities.getFirst()) instanceof Bucketable) {
                Bucketable bucketable = (Bucketable)entity2;
                if (stack.getItem() == Items.WATER_BUCKET && entity2.isAlive()) {
                    entity2.playSound(bucketable.getPickupSound(), 1.0f, 1.0f);
                    ItemStack newStack = bucketable.getBucketItemStack();
                    bucketable.saveToBucketTag(newStack);
                    entity2.discard();
                    return newStack;
                }
            }
            return this.defaultDispenseItemBehavior.dispense(source, stack);
        }
    };

    public static void registerDispenseBehaviors() {
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)UAItems.NAUTILUS_BUCKET.get()), (DispenseItemBehavior)EMPTY_FISH_BUCKET_BEHAVIOR);
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)UAItems.PIKE_BUCKET.get()), (DispenseItemBehavior)EMPTY_FISH_BUCKET_BEHAVIOR);
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)UAItems.LIONFISH_BUCKET.get()), (DispenseItemBehavior)EMPTY_FISH_BUCKET_BEHAVIOR);
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)UAItems.SQUID_BUCKET.get()), (DispenseItemBehavior)EMPTY_FISH_BUCKET_BEHAVIOR);
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)UAItems.GLOW_SQUID_BUCKET.get()), (DispenseItemBehavior)EMPTY_FISH_BUCKET_BEHAVIOR);
        DataUtil.registerAlternativeDispenseBehavior((DataUtil.AlternativeDispenseBehavior)new DataUtil.AlternativeDispenseBehavior("upgrade_aquatic", Items.WATER_BUCKET, (source, stack) -> !BlockUtil.getEntitiesAtOffsetPos((BlockSource)source, LivingEntity.class, entity -> entity instanceof Bucketable).isEmpty(), FILL_FISH_BUCKET_BEHAVIOR));
    }
}

