/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.core.mixin.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.model.DrownedModel;
import net.minecraft.client.renderer.entity.AbstractZombieRenderer;
import net.minecraft.client.renderer.entity.DrownedRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Drowned;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;

@Mixin(value={DrownedRenderer.class})
public class DrownedRendererMixin
extends AbstractZombieRenderer<Drowned, DrownedModel<Drowned>> {
    protected DrownedRendererMixin(EntityRendererProvider.Context p_173910_, DrownedModel<Drowned> p_173911_, DrownedModel<Drowned> p_173912_, DrownedModel<Drowned> p_173913_) {
        super(p_173910_, p_173911_, p_173912_, p_173913_);
    }

    @Overwrite
    protected void setupRotations(Drowned entityLiving, PoseStack matrixStackIn, float ageInTicks, float rotationYaw, float partialTicks, float scale) {
        if (entityLiving.isVisuallySwimming()) {
            float swimAnimationTicks = entityLiving.getSwimAmount(partialTicks);
            if (entityLiving.isInWater()) {
                super.setupRotations((LivingEntity)entityLiving, matrixStackIn, ageInTicks, rotationYaw, partialTicks, scale);
                float rotationPitchChange = entityLiving.isInWater() ? -90.0f - entityLiving.getXRot() : -90.0f;
                float rotationModifier = Mth.lerp((float)swimAnimationTicks, (float)0.0f, (float)rotationPitchChange);
                matrixStackIn.mulPose(Axis.XP.rotationDegrees(rotationModifier));
                matrixStackIn.translate(0.0, -1.0, (double)0.3f);
            } else {
                super.setupRotations((LivingEntity)entityLiving, matrixStackIn, ageInTicks, rotationYaw, partialTicks, scale);
            }
        } else {
            super.setupRotations((LivingEntity)entityLiving, matrixStackIn, ageInTicks, rotationYaw, partialTicks, scale);
            float f = entityLiving.getSwimAmount(partialTicks);
            if (f > 0.0f) {
                matrixStackIn.mulPose(Axis.XP.rotationDegrees(Mth.lerp((float)f, (float)entityLiving.getXRot(), (float)(-10.0f - entityLiving.getXRot()))));
            }
        }
    }
}

