/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.core.data.server;

import com.teamabnormals.blueprint.common.remolder.Remolder;
import com.teamabnormals.blueprint.common.remolder.RemolderTypes;
import com.teamabnormals.blueprint.common.remolder.data.RemolderProvider;
import com.teamabnormals.blueprint.common.remolder.util.LootRemolders;
import com.teamabnormals.upgrade_aquatic.core.registry.UABlocks;
import com.teamabnormals.upgrade_aquatic.core.registry.UAItems;
import java.util.concurrent.CompletableFuture;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.LocationCheck;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public final class UADataRemolderProvider
extends RemolderProvider {
    public UADataRemolderProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> provider) {
        super("upgrade_aquatic", PackOutput.Target.DATA_PACK, output, provider);
    }

    protected void registerEntries(HolderLookup.Provider provider) {
        HolderLookup.RegistryLookup biomes = provider.lookupOrThrow(Registries.BIOME);
        LootItemCondition.Builder inSwamp = LocationCheck.checkLocation((LocationPredicate.Builder)LocationPredicate.Builder.location().setBiomes((HolderSet)HolderSet.direct((Holder[])new Holder[]{biomes.getOrThrow(Biomes.SWAMP)})));
        LootItemCondition.Builder inRiver = LocationCheck.checkLocation((LocationPredicate.Builder)LocationPredicate.Builder.location().setBiomes((HolderSet)HolderSet.direct((Holder[])new Holder[]{biomes.getOrThrow(Biomes.RIVER)})));
        LootItemCondition.Builder inWarmOcean = LocationCheck.checkLocation((LocationPredicate.Builder)LocationPredicate.Builder.location().setBiomes((HolderSet)HolderSet.direct((Holder[])new Holder[]{biomes.getOrThrow(Biomes.WARM_OCEAN)})));
        this.entry("loot_table/gameplay/fishing/fish").path(new String[]{"loot_table/gameplay/fishing/fish"}).remolder((Remolder)RemolderTypes.sequence((Remolder[])new Remolder[]{LootRemolders.addEntry((int)0, (LootPoolEntryContainer)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)UAItems.PIKE.get())).setWeight(11).when((LootItemCondition.Builder)inSwamp.or(inRiver))).build()), LootRemolders.addEntry((int)0, (LootPoolEntryContainer)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)UAItems.PERCH.get())).setWeight(18).when(inSwamp)).build()), LootRemolders.addEntry((int)0, (LootPoolEntryContainer)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)UAItems.LIONFISH.get())).setWeight(5).when(inWarmOcean)).build())}));
        this.entry("loot_table/gameplay/fishing/junk").path(new String[]{"loot_table/gameplay/fishing/junk"}).remolder((Remolder)RemolderTypes.sequence((Remolder[])new Remolder[]{LootRemolders.addEntry((int)0, (LootPoolEntryContainer)LootItem.lootTableItem((ItemLike)((ItemLike)UABlocks.DRIFTWOOD_LOG.get())).setWeight(10).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)5.0f))).build()), LootRemolders.addEntry((int)0, (LootPoolEntryContainer)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)UABlocks.PICKERELWEED.get())).setWeight(12).when((LootItemCondition.Builder)inSwamp.or(inRiver))).build())}));
        this.entry("loot_table/add_thrasher_teeth").path(new String[]{"loot_table/chests/underwater_ruin_big", "loot_table/chests/buried_treasure"}).remolder(LootRemolders.addPool((LootPool)LootPool.lootPool().name("upgrade_aquatic:thrasher_teeth").setRolls((NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)UAItems.THRASHER_TOOTH.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)2.0f)))).build()));
        this.entry("loot_table/pickerelweed_structures").path(new String[]{"loot_table/chests/shipwreck_supply"}).remolder(LootRemolders.addPool((LootPool)LootPool.lootPool().name("upgrade_aquatic:pickerelweed").setRolls((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)UABlocks.PICKERELWEED.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f))).setWeight(1)).build()));
        this.entry("loot_table/archaeology/ocean_ruin_cold").path(new String[]{"loot_table/archaeology/ocean_ruin_cold"}).remolder((Remolder)RemolderTypes.sequence((Remolder[])new Remolder[]{LootRemolders.addEntry((int)0, (LootPoolEntryContainer)LootItem.lootTableItem((ItemLike)((ItemLike)UAItems.DISC_FRAGMENT_ATLANTIS.get())).build()), LootRemolders.addEntry((int)0, (LootPoolEntryContainer)LootItem.lootTableItem((ItemLike)((ItemLike)UAItems.PREDATOR_POTTERY_SHERD.get())).build())}));
        this.entry("loot_table/entities/elder_guardian").path(new String[]{"loot_table/entities/elder_guardian"}).remolder(LootRemolders.addPool((LootPool)LootPool.lootPool().name("upgrade_aquatic:elder_guardian").setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)UABlocks.ELDER_EYE.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)1.0f)))).build()));
    }
}

