/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.common.levelgen.treedecorators;

import com.mojang.serialization.MapCodec;
import com.teamabnormals.upgrade_aquatic.common.block.MulberryVineBlock;
import com.teamabnormals.upgrade_aquatic.core.registry.UABlocks;
import com.teamabnormals.upgrade_aquatic.core.registry.UAFeatures;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class MulberryVinesDecorator
extends TreeDecorator {
    public static final MapCodec<MulberryVinesDecorator> CODEC;
    public static final MulberryVinesDecorator INSTANCE;

    protected TreeDecoratorType<?> type() {
        return (TreeDecoratorType)UAFeatures.MULBERRY_VINES.get();
    }

    public void place(TreeDecorator.Context context) {
        RandomSource random = context.random();
        LevelSimulatedReader level = context.level();
        for (BlockPos pos : context.leaves()) {
            LevelReader levelReader;
            BlockPos belowPos = pos.below();
            if (!level.isStateAtPosition(belowPos, BlockBehaviour.BlockStateBase::isAir)) continue;
            BlockState state = (BlockState)((BlockState)((Block)UABlocks.MULBERRY_VINE.get()).defaultBlockState().setValue((Property)MulberryVineBlock.AGE, (Comparable)Integer.valueOf(4))).setValue((Property)MulberryVineBlock.DOUBLE, (Comparable)Boolean.valueOf(random.nextBoolean()));
            if (!(level instanceof LevelReader) || !state.canSurvive(levelReader = (LevelReader)level, belowPos) || random.nextInt(5) != 0) continue;
            context.setBlock(belowPos, state);
        }
    }

    static {
        INSTANCE = new MulberryVinesDecorator();
        CODEC = MapCodec.unit(() -> INSTANCE);
    }
}

