/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.common.levelgen.feature;

import com.mojang.serialization.Codec;
import com.teamabnormals.blueprint.core.util.MathUtil;
import com.teamabnormals.upgrade_aquatic.core.registry.UABlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.BaseCoralWallFanBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class PrismarineCoralFeature
extends Feature<NoneFeatureConfiguration> {
    public PrismarineCoralFeature(Codec<NoneFeatureConfiguration> configFactoryIn) {
        super(configFactoryIn);
    }

    protected static BlockState coralBlock(boolean elder) {
        return !elder ? ((Block)UABlocks.PRISMARINE_CORAL_BLOCK.get()).defaultBlockState() : ((Block)UABlocks.ELDER_PRISMARINE_CORAL_BLOCK.get()).defaultBlockState();
    }

    protected static BlockState coral(boolean elder) {
        return !elder ? ((Block)UABlocks.PRISMARINE_CORAL.get()).defaultBlockState() : ((Block)UABlocks.ELDER_PRISMARINE_CORAL.get()).defaultBlockState();
    }

    protected static BlockState coralFan(boolean elder) {
        return !elder ? ((Block)UABlocks.PRISMARINE_CORAL_FAN.get()).defaultBlockState() : ((Block)UABlocks.ELDER_PRISMARINE_CORAL_FAN.get()).defaultBlockState();
    }

    protected static BlockState coralWallFan(boolean elder) {
        return !elder ? ((Block)UABlocks.PRISMARINE_CORAL_WALL_FAN.get()).defaultBlockState() : ((Block)UABlocks.ELDER_PRISMARINE_CORAL_WALL_FAN.get()).defaultBlockState();
    }

    protected static BlockState coralShower(boolean elder) {
        return !elder ? ((Block)UABlocks.PRISMARINE_CORAL_SHOWER.get()).defaultBlockState() : ((Block)UABlocks.ELDER_PRISMARINE_CORAL_SHOWER.get()).defaultBlockState();
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel world = context.level();
        RandomSource rand = context.random();
        BlockPos pos = context.origin();
        if (PrismarineCoralFeature.shouldPlace((LevelAccessor)world, pos)) {
            int a = rand.nextInt(4) + 2;
            int c = rand.nextInt(5) + 3;
            int b = 4;
            if (pos.getY() > 11) {
                PrismarineCoralFeature.addShelf((LevelAccessor)world, pos, rand, a, b, c, rand.nextDouble() <= 0.35);
                if (rand.nextBoolean()) {
                    BlockPos pairPos = pos.relative(Direction.getRandom((RandomSource)rand)).above(rand.nextInt(2) + 2);
                    if (PrismarineCoralFeature.isInWaterNextToStone((LevelAccessor)world, pairPos)) {
                        PrismarineCoralFeature.addShelf((LevelAccessor)world, pairPos, rand, 3, 3, c + 1, rand.nextDouble() <= 0.35);
                    }
                    if (rand.nextBoolean() && PrismarineCoralFeature.isInWaterNextToStone((LevelAccessor)world, pairPos = pos.relative(Direction.getRandom((RandomSource)rand)).below(rand.nextInt(2) + 2))) {
                        PrismarineCoralFeature.addShelf((LevelAccessor)world, pairPos, rand, 3, 4, c + 1, rand.nextDouble() <= 0.35);
                    }
                }
            }
            return true;
        }
        return false;
    }

    private static boolean isInWaterNextToStone(LevelAccessor level, BlockPos pos) {
        if (!level.isWaterAt(pos)) {
            return false;
        }
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            mutableBlockPos.setWithOffset((Vec3i)pos, direction);
            if (!level.getBlockState((BlockPos)mutableBlockPos).is(BlockTags.BASE_STONE_OVERWORLD)) continue;
            return true;
        }
        return false;
    }

    private static boolean shouldPlace(LevelAccessor level, BlockPos pos) {
        if (!PrismarineCoralFeature.isInWaterNextToStone(level, pos)) {
            return false;
        }
        for (int i = 0; i < 16; ++i) {
            BlockPos checkPos = pos.below(i);
            BlockState state = level.getBlockState(checkPos);
            if (state.getBlock() != Blocks.MAGMA_BLOCK && state.getBlock() != Blocks.OBSIDIAN) continue;
            return true;
        }
        return false;
    }

    private static void addShelf(LevelAccessor world, BlockPos pos, RandomSource rand, int a, int b, int c, boolean isElder) {
        MathUtil.Equation r = theta -> (Math.cos((double)b * theta) / (double)c + 1.0) * (double)a;
        for (int i = -(a / c + a); i < a / c + a; ++i) {
            for (int j = -(a / c + a); j < a / c + a; ++j) {
                BlockPos below;
                double radius = r.compute(Math.atan2(j, i));
                BlockPos placingPos = pos.offset(i, 0, j);
                if (!(world.getBlockState(placingPos).canBeReplaced() && (double)(i * i + j * j) < radius * radius || world.getBlockState(placingPos).getBlock() == UABlocks.PRISMARINE_CORAL_WALL_FAN.get() && (double)(i * i + j * j) < radius * radius) && (world.getBlockState(placingPos).getBlock() != UABlocks.ELDER_PRISMARINE_CORAL_WALL_FAN.get() || !((double)(i * i + j * j) < radius * radius))) continue;
                world.setBlock(placingPos, PrismarineCoralFeature.coralBlock(isElder), 2);
                if (!rand.nextBoolean()) continue;
                BlockPos above = placingPos.above();
                if (world.isWaterAt(above)) {
                    world.setBlock(above, rand.nextBoolean() ? PrismarineCoralFeature.coral(isElder) : PrismarineCoralFeature.coralFan(isElder), 2);
                }
                if (world.isWaterAt(below = placingPos.below())) {
                    world.setBlock(below, PrismarineCoralFeature.coralShower(isElder), 2);
                }
                for (Direction direction : Direction.Plane.HORIZONTAL) {
                    BlockPos blockpos1;
                    if (!(rand.nextFloat() < 0.85f) || world.getBlockState(blockpos1 = placingPos.relative(direction)).getBlock() != Blocks.WATER) continue;
                    BlockState blockstate1 = (BlockState)PrismarineCoralFeature.coralWallFan(isElder).setValue((Property)BaseCoralWallFanBlock.FACING, (Comparable)direction);
                    world.setBlock(blockpos1, blockstate1, 2);
                }
            }
        }
    }
}

