/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.common.item;

import com.teamabnormals.upgrade_aquatic.common.entity.animal.jellyfish.AbstractJellyfish;
import com.teamabnormals.upgrade_aquatic.core.other.JellyfishRegistry;
import com.teamabnormals.upgrade_aquatic.core.registry.UASoundEvents;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class JellyfishBucketItem
extends BucketItem {
    public JellyfishBucketItem(Fluid supplier, Item.Properties builder) {
        super(supplier, builder);
    }

    public void checkExtraContent(@Nullable Player player, Level level, ItemStack stack, BlockPos pos) {
        if (level instanceof ServerLevel) {
            AbstractJellyfish jellyfish;
            ServerLevel serverLevel = (ServerLevel)level;
            CompoundTag compoundTag = ((CustomData)stack.get(DataComponents.BUCKET_ENTITY_DATA)).copyTag();
            if (compoundTag.contains("EntityType")) {
                Optional type = BuiltInRegistries.ENTITY_TYPE.getOptional(ResourceLocation.parse((String)compoundTag.getString("EntityType")));
                if (type.isEmpty()) {
                    return;
                }
                Entity entity = ((EntityType)type.get()).spawn(serverLevel, stack, null, pos, MobSpawnType.BUCKET, true, false);
                if (!(entity instanceof AbstractJellyfish)) {
                    return;
                }
                jellyfish = (AbstractJellyfish)entity;
            } else {
                List<JellyfishRegistry.JellyfishEntry<?>> jellies = JellyfishRegistry.collectJelliesMatchingRarity(Rarity.COMMON);
                jellyfish = (AbstractJellyfish)jellies.get(new Random().nextInt(jellies.size())).jellyfish().get().spawn(serverLevel, stack, null, pos, MobSpawnType.BUCKET, true, false);
                if (jellyfish == null) {
                    return;
                }
            }
            jellyfish.loadFromBucketTag(compoundTag);
            jellyfish.setFromBucket(true);
        }
    }

    protected void playEmptySound(@Nullable Player player, LevelAccessor levelAccessor, BlockPos pos) {
        levelAccessor.playSound(player, pos, (SoundEvent)UASoundEvents.BUCKET_EMPTY_JELLYFISH.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        CustomData data = (CustomData)stack.getOrDefault(DataComponents.BUCKET_ENTITY_DATA, (Object)CustomData.EMPTY);
        if (data.isEmpty()) {
            return;
        }
        CompoundTag tag = data.copyTag();
        if (tag.contains("JellyfishDisplayTag")) {
            AbstractJellyfish.BucketDisplayInfo.appendHoverText(tooltip, tag.getCompound("JellyfishDisplayTag"));
        }
    }
}

