/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.common.entity.monster;

import com.teamabnormals.blueprint.core.endimator.Endimatable;
import com.teamabnormals.blueprint.core.endimator.PlayableEndimation;
import com.teamabnormals.blueprint.core.endimator.TimedEndimation;
import com.teamabnormals.blueprint.core.util.NetworkUtil;
import com.teamabnormals.upgrade_aquatic.common.entity.ai.goal.thrasher.ThrasherFindDetectionPointGoal;
import com.teamabnormals.upgrade_aquatic.common.entity.ai.goal.thrasher.ThrasherFireSonarGoal;
import com.teamabnormals.upgrade_aquatic.common.entity.ai.goal.thrasher.ThrasherGrabGoal;
import com.teamabnormals.upgrade_aquatic.common.entity.ai.goal.thrasher.ThrasherRandomSwimGoal;
import com.teamabnormals.upgrade_aquatic.common.entity.ai.goal.thrasher.ThrasherThrashGoal;
import com.teamabnormals.upgrade_aquatic.common.entity.monster.GreatThrasher;
import com.teamabnormals.upgrade_aquatic.core.UAConfig;
import com.teamabnormals.upgrade_aquatic.core.UpgradeAquatic;
import com.teamabnormals.upgrade_aquatic.core.other.UADataSerializers;
import com.teamabnormals.upgrade_aquatic.core.other.tags.UABiomeTags;
import com.teamabnormals.upgrade_aquatic.core.other.tags.UAEntityTypeTags;
import com.teamabnormals.upgrade_aquatic.core.registry.UAEntityTypes;
import com.teamabnormals.upgrade_aquatic.core.registry.UAItems;
import com.teamabnormals.upgrade_aquatic.core.registry.UAPlayableEndimations;
import com.teamabnormals.upgrade_aquatic.core.registry.UASoundEvents;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class Thrasher
extends Monster
implements Endimatable {
    public static final Predicate<Entity> ENEMY_MATCHER = entity -> {
        if (entity == null) {
            return false;
        }
        if (entity instanceof Player && !((Player)entity).isCreative() && !entity.isSpectator()) {
            return entity.isInWater();
        }
        return entity.getType().is(UAEntityTypeTags.THRASHER_SONAR_TARGETS) && entity.isInWater();
    };
    private static final AttributeModifier KNOCKBACK_RESISTANCE_MODIFIER = new AttributeModifier(UpgradeAquatic.location("thrasher_knockback_resistance"), 4.0, AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
    private static final EntityDataAccessor<Boolean> MOVING = SynchedEntityData.defineId(Thrasher.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> WATER_TIME = SynchedEntityData.defineId(Thrasher.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> STUN_TIME = SynchedEntityData.defineId(Thrasher.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> HITS_TILL_STUN = SynchedEntityData.defineId(Thrasher.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Optional<BlockPos>> POSSIBLE_DETECTION_POINT = SynchedEntityData.defineId(Thrasher.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_BLOCK_POS);
    private static final EntityDataAccessor<EntityDimensions> CAUGHT_SIZE = SynchedEntityData.defineId(Thrasher.class, (EntityDataSerializer)((EntityDataSerializer)UADataSerializers.ENTITY_SIZE.get()));
    private static final EntityDimensions DEFAULT_SIZE = EntityDimensions.fixed((float)1.6f, (float)0.9f);
    public final TimedEndimation stunAnimation = new TimedEndimation(10, 10);
    protected int ticksSinceLastSonarFire;
    protected float prevTailAnimation;
    protected float tailAnimation;
    protected float tailSpeed;
    protected float prevFinAnimation;
    protected float finAnimation;
    protected float finSpeed;

    public Thrasher(EntityType<? extends Thrasher> type, Level world) {
        super(type, world);
        this.xpReward = 30;
        this.moveControl = new ThrasherMoveController(this);
        this.lookControl = new ThrasherLookController(this);
        this.prevTailAnimation = this.tailAnimation = this.random.nextFloat();
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.createMobAttributes().add(Attributes.ATTACK_DAMAGE, 5.0).add(Attributes.MOVEMENT_SPEED, 0.55).add(Attributes.FOLLOW_RANGE, 32.0).add(Attributes.MAX_HEALTH, 50.0).add(Attributes.KNOCKBACK_RESISTANCE, 1.25).add(Attributes.ARMOR, 8.0);
    }

    public static boolean checkThrasherSpawnRules(EntityType<? extends PathfinderMob> entityType, ServerLevelAccessor level, MobSpawnType spawnReason, BlockPos pos, RandomSource random) {
        return level.getDifficulty() != Difficulty.PEACEFUL && pos.getY() <= (Integer)UAConfig.COMMON.thrasherMaxSpawnHeight.get() && (level.getLevel().isNight() || random.nextDouble() < (Double)UAConfig.COMMON.thrasherDaytimeSpawnChance.get());
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new ThrasherThrashGoal(this));
        this.goalSelector.addGoal(2, (Goal)new ThrasherFireSonarGoal(this));
        this.goalSelector.addGoal(3, (Goal)new ThrasherFindDetectionPointGoal(this));
        this.goalSelector.addGoal(4, (Goal)new ThrasherGrabGoal(this, 2.5, true));
        this.goalSelector.addGoal(5, (Goal)new ThrasherRandomSwimGoal(this, 1.1, 15));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(MOVING, (Object)false);
        builder.define(WATER_TIME, (Object)2500);
        builder.define(STUN_TIME, (Object)0);
        builder.define(HITS_TILL_STUN, (Object)0);
        builder.define(POSSIBLE_DETECTION_POINT, Optional.empty());
        builder.define(CAUGHT_SIZE, (Object)this.getDefaultSize());
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn) {
        GreatThrasher greatThrasher;
        Random rand;
        this.setAirSupply(this.getMaxAirSupply());
        if (reason == MobSpawnType.NATURAL && worldIn.getBiome(this.blockPosition()).is(UABiomeTags.HAS_GREAT_THRASHER) && (rand = new Random()).nextDouble() < (Double)UAConfig.COMMON.greatThrasherSpawnChance.get() && (greatThrasher = (GreatThrasher)((EntityType)UAEntityTypes.GREAT_THRASHER.get()).create(this.level())) != null) {
            greatThrasher.moveTo(this.getX(), this.getY(), this.getZ(), this.getYRot(), this.getXRot());
            this.level().addFreshEntity((Entity)greatThrasher);
            this.discard();
        }
        return super.finalizeSpawn(worldIn, difficultyIn, reason, spawnDataIn);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        if (HITS_TILL_STUN.equals(key) && this.tickCount > 10) {
            if (this.getHitsLeftTillStun() == 0) {
                this.setStunned((this.getRandom().nextInt(2) + 2) * 20 + this.getRandom().nextInt(10));
            }
        } else if (CAUGHT_SIZE.equals(key)) {
            this.refreshDimensions();
        }
        super.onSyncedDataUpdated(key);
    }

    public void positionRider(Entity passenger, Entity.MoveFunction function) {
        if (passenger instanceof LivingEntity) {
            float distance = this.getMountDistance();
            double dx = Math.cos((double)(this.getYRot() + 90.0f) * Math.PI / 180.0) * (double)distance;
            double dy = -Math.sin((double)this.getXRot() * (Math.PI / 180));
            double dz = Math.sin((double)(this.getYRot() + 90.0f) * Math.PI / 180.0) * (double)distance;
            Vec3 riderPos = new Vec3(this.getX() + dx, this.getY(), this.getZ() + dz);
            double offset = this.getPassengerRidingPosition(passenger).y() - (double)(passenger instanceof Player ? 0.5f : 0.75f);
            function.accept(passenger, riderPos.x, dy + offset, riderPos.z);
        } else {
            super.positionRider(passenger);
        }
    }

    protected void addPassenger(Entity passenger) {
        super.addPassenger(passenger);
        if (!this.level().isClientSide && passenger instanceof LivingEntity && passenger.getVehicle() == this && this.getPassengers().indexOf(passenger) == 0) {
            EntityDimensions defaultSize = this.getDefaultSize();
            this.setCaughtSize(EntityDimensions.fixed((float)(defaultSize.width() + passenger.getDimensions(passenger.getPose()).width()), (float)defaultSize.height()));
        }
    }

    protected void removePassenger(Entity passenger) {
        super.removePassenger(passenger);
        if (!this.level().isClientSide) {
            if (!this.getPassengers().isEmpty()) {
                Entity indexZeroPassenger = this.getFirstPassenger();
                EntityDimensions defaultSize = this.getDefaultSize();
                if (indexZeroPassenger instanceof LivingEntity && passenger.getVehicle() == this) {
                    this.setCaughtSize(EntityDimensions.fixed((float)(defaultSize.width() + passenger.getDimensions(passenger.getPose()).width()), (float)defaultSize.height()));
                } else {
                    this.setCaughtSize(defaultSize);
                }
            } else {
                this.setCaughtSize(this.getDefaultSize());
            }
        }
    }

    @Nullable
    public LivingEntity getControllingPassenger() {
        return null;
    }

    public float getMountDistance() {
        return 1.2f;
    }

    public boolean shouldRiderFaceForward(Player player) {
        return true;
    }

    public boolean canRiderInteract() {
        return true;
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public EntityDimensions getDefaultDimensions(Pose pose) {
        if (!this.getPassengers().isEmpty()) {
            return this.getCaughtSize();
        }
        return super.getDefaultDimensions(pose);
    }

    public boolean checkSpawnObstruction(LevelReader worldIn) {
        return worldIn.isUnobstructed((Entity)this);
    }

    public void onEndimationStart(PlayableEndimation endimation, PlayableEndimation oldEndimation) {
        AttributeInstance knockbackResistance;
        if (endimation == UAPlayableEndimations.THRASHER_THRASH && !(knockbackResistance = this.getAttribute(Attributes.KNOCKBACK_RESISTANCE)).hasModifier(KNOCKBACK_RESISTANCE_MODIFIER.id())) {
            knockbackResistance.addTransientModifier(KNOCKBACK_RESISTANCE_MODIFIER);
        }
    }

    public void onEndimationEnd(PlayableEndimation endimation, PlayableEndimation newEndimation) {
        if (endimation == UAPlayableEndimations.THRASHER_THRASH) {
            this.getAttribute(Attributes.KNOCKBACK_RESISTANCE).removeModifier(KNOCKBACK_RESISTANCE_MODIFIER.id());
        }
    }

    public void onInsideBubbleColumn(boolean downwards) {
    }

    public void onAboveBubbleCol(boolean downwards) {
    }

    public boolean hurt(DamageSource source, float amount) {
        Entity entitySource = source.getEntity();
        if (entitySource instanceof LivingEntity) {
            Player player;
            Vec3 difference = new Vec3(entitySource.getX() - this.getX(), entitySource.getY() - this.getY(), entitySource.getZ() - this.getZ());
            if (difference.length() <= 8.0) {
                if (entitySource.isInWater()) {
                    if (entitySource instanceof Player && !((Player)entitySource).isCreative() && !entitySource.isSpectator()) {
                        this.setTarget((LivingEntity)entitySource);
                    } else if (!(entitySource instanceof Player)) {
                        this.setTarget((LivingEntity)entitySource);
                    }
                }
                if (this.getHitsLeftTillStun() > 0) {
                    int chance;
                    int difficultyDividend = switch (this.level().getDifficulty()) {
                        default -> throw new MatchException(null, null);
                        case Difficulty.EASY, Difficulty.PEACEFUL -> 10;
                        case Difficulty.NORMAL -> 12;
                        case Difficulty.HARD -> 16;
                    };
                    int n = chance = (double)amount >= this.getStunDamageThreshold() ? 1 : difficultyDividend / (int)Math.max(1.0f, amount);
                    if (this.getRandom().nextInt(chance) == 0) {
                        this.setHitsTillStun(this.getHitsLeftTillStun() - 1);
                    }
                }
            } else if (!(entitySource instanceof Player) || !(player = (Player)entitySource).isCreative() && !player.isSpectator()) {
                this.setPossibleDetectionPoint(Optional.of(entitySource.blockPosition().offset(this.getRandom().nextInt(2), this.getRandom().nextInt(2), this.getRandom().nextInt(2))));
            }
        }
        if (!this.level().isClientSide() && this.isNoEndimationPlaying()) {
            NetworkUtil.setPlayingAnimation((Entity)this, (PlayableEndimation)UAPlayableEndimations.THRASHER_HURT);
        }
        return super.hurt(source, amount);
    }

    protected PathNavigation createNavigation(Level worldIn) {
        return new WaterBoundPathNavigation((Mob)this, worldIn);
    }

    public int getMaxAirSupply() {
        return 4950;
    }

    protected int increaseAirSupply(int currentAir) {
        return this.getMaxAirSupply();
    }

    public int getMaxHeadXRot() {
        return 1;
    }

    public int getMaxHeadYRot() {
        return 1;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getTailAnimation(float ptc) {
        return Mth.lerp((float)ptc, (float)this.prevTailAnimation, (float)this.tailAnimation);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getFinAnimation(float ptc) {
        return Mth.lerp((float)ptc, (float)this.prevFinAnimation, (float)this.finAnimation);
    }

    public void travel(Vec3 vec3) {
        if (this.isEffectiveAi() && this.isInWater()) {
            this.moveRelative(0.1f, vec3);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.9));
            if (!this.isMoving() && this.getTarget() == null) {
                double ySpeed = !((ThrasherLookController)this.getLookControl()).isTurningForSonar() ? -0.005 : -0.0025;
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, ySpeed, 0.0));
            }
        } else {
            super.travel(vec3);
        }
    }

    public void tick() {
        super.tick();
        if (this.getTarget() != null && !this.getTarget().isAlive() && this.ticksSinceLastSonarFire >= 55 && this.getRandom().nextFloat() < 0.05f) {
            this.setTarget(null);
        }
        if (!this.isNoAi()) {
            this.ticksSinceLastSonarFire = this.isEndimationPlaying(UAPlayableEndimations.THRASHER_SONAR_FIRE) ? 0 : ++this.ticksSinceLastSonarFire;
            if (this.isInWaterRainOrBubble()) {
                this.setWaterTime(2400);
            } else {
                this.setWaterTime(this.getWaterTime() - 1);
                if (this.getWaterTime() <= 0) {
                    this.hurt(this.damageSources().dryOut(), 1.0f);
                }
                if (!this.isInWater() && !this.isStunned() && this.onGround()) {
                    this.setDeltaMovement(this.getDeltaMovement().add((double)((this.random.nextFloat() * 2.0f - 1.0f) * 0.2f), 0.5, (double)((this.random.nextFloat() * 2.0f - 1.0f) * 0.2f)));
                    this.setYRot(this.random.nextFloat() * 360.0f);
                    this.setXRot(this.random.nextFloat() * -50.0f);
                    this.setOnGround(false);
                    this.hasImpulse = true;
                    this.playSound(this.getFlopSound(), this.getSoundVolume(), this.getVoicePitch());
                }
            }
            if (this.level().isClientSide() && !this.getPassengers().isEmpty() && this.isEndimationPlaying(UAPlayableEndimations.THRASHER_THRASH) && this.getAnimationTick() % 2 == 0 && this.getAnimationTick() > 5) {
                Entity passenger = this.getFirstPassenger();
                for (int i = 0; i < 3; ++i) {
                    if (!passenger.isEyeInFluid(FluidTags.WATER)) continue;
                    this.level().addParticle((ParticleOptions)ParticleTypes.BUBBLE, passenger.getX() + (this.getRandom().nextDouble() - 0.5) * (double)passenger.getBbWidth(), passenger.getY(), passenger.getZ() + (this.getRandom().nextDouble() - 0.5) * (double)passenger.getBbWidth(), (this.getRandom().nextDouble() - 0.5) * 2.0, -this.getRandom().nextDouble(), (this.getRandom().nextDouble() - 0.5) * 2.0);
                }
            }
            if (!this.level().isClientSide && this.isStunned()) {
                if (!this.getPassengers().isEmpty()) {
                    this.ejectPassengers();
                }
                this.setStunned(this.getStunTime() - 1);
            }
        }
    }

    public void aiStep() {
        if (this.isAlive()) {
            if (this.level().isClientSide) {
                this.prevTailAnimation = this.tailAnimation;
                this.prevFinAnimation = this.finAnimation;
                if (!this.isInWater() || this.isEndimationPlaying(UAPlayableEndimations.THRASHER_THRASH) || this.isEndimationPlaying(UAPlayableEndimations.THRASHER_SONAR_FIRE)) {
                    this.tailSpeed = 1.1f;
                    this.finSpeed = 0.875f;
                } else if (this.isMoving()) {
                    this.tailSpeed = this.tailSpeed < 0.5f ? 2.2f : (this.tailSpeed += (0.25f - this.tailSpeed) * 0.1f);
                    this.finSpeed = this.finSpeed < 0.5f ? 0.875f : (this.finSpeed += (0.045f - this.tailSpeed) * 0.05f);
                } else {
                    this.tailSpeed += (0.125f - this.tailSpeed) * 0.1f;
                    this.finSpeed += (0.01125f - this.finSpeed) * 0.05f;
                }
                TimedEndimation stunAnimation = this.stunAnimation;
                if (this.isStunned()) {
                    if (stunAnimation.getTick() >= 10) {
                        stunAnimation.setDecrementing(true);
                    } else if (stunAnimation.isDecrementing() && stunAnimation.getTick() <= 0) {
                        stunAnimation.setDecrementing(false);
                    }
                } else {
                    stunAnimation.setDecrementing(false);
                }
                stunAnimation.tick();
                this.tailAnimation += this.tailSpeed;
                this.finAnimation += this.finSpeed;
            }
            if (!this.isStunned()) {
                List nearbyEntities = this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(0.5), ENEMY_MATCHER);
                for (LivingEntity entities : nearbyEntities) {
                    if (this.getTarget() != null) continue;
                    this.setTarget(entities);
                }
            }
            if (this.isMoving() && this.isInWater()) {
                Vec3 vec3d1 = this.getViewVector(0.0f);
                for (int i = 0; i < 2; ++i) {
                    this.level().addParticle((ParticleOptions)ParticleTypes.BUBBLE, this.getX() + (this.random.nextDouble() - 0.5) * (double)this.getBbWidth() - vec3d1.x * 1.5, this.getY() + this.random.nextDouble() * (double)this.getBbHeight() - vec3d1.y * 1.5, this.getZ() + (this.random.nextDouble() - 0.5) * (double)this.getBbWidth() - vec3d1.z * 1.5, 0.0, 0.0, 0.0);
                }
            }
        }
        super.aiStep();
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)UAItems.THRASHER_SPAWN_EGG.get());
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return this.isInWater() ? (SoundEvent)UASoundEvents.THRASHER_HURT.get() : (SoundEvent)UASoundEvents.THRASHER_HURT_LAND.get();
    }

    protected SoundEvent getDeathSound() {
        return this.isInWater() ? (SoundEvent)UASoundEvents.THRASHER_DEATH.get() : (SoundEvent)UASoundEvents.THRASHER_DEATH_LAND.get();
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        if (this.isEndimationPlaying(UAPlayableEndimations.THRASHER_THRASH)) {
            return null;
        }
        return this.isInWater() ? (SoundEvent)UASoundEvents.THRASHER_AMBIENT.get() : (SoundEvent)UASoundEvents.THRASHER_AMBIENT_LAND.get();
    }

    protected SoundEvent getFlopSound() {
        return (SoundEvent)UASoundEvents.THRASHER_FLOP.get();
    }

    public SoundEvent getSonarFireSound() {
        return (SoundEvent)UASoundEvents.THRASHER_SONAR_FIRE.get();
    }

    public SoundEvent getThrashingSound() {
        return (SoundEvent)UASoundEvents.THRASHER_THRASH.get();
    }

    protected SoundEvent getSwimSound() {
        return SoundEvents.DOLPHIN_SWIM;
    }

    protected void playStepSound(BlockPos pos, BlockState blockIn) {
    }

    public int getAmbientSoundInterval() {
        return 100;
    }

    protected double getStunDamageThreshold() {
        return 6.0;
    }

    public int getMaxSpawnClusterSize() {
        return 1;
    }

    public boolean isMoving() {
        return (Boolean)this.entityData.get(MOVING);
    }

    private void setMoving(boolean moving) {
        this.entityData.set(MOVING, (Object)moving);
    }

    public int getWaterTime() {
        return (Integer)this.entityData.get(WATER_TIME);
    }

    public void setWaterTime(int ticks) {
        this.entityData.set(WATER_TIME, (Object)ticks);
    }

    public int getStunTime() {
        return (Integer)this.entityData.get(STUN_TIME);
    }

    public int getHitsLeftTillStun() {
        return (Integer)this.entityData.get(HITS_TILL_STUN);
    }

    public void setHitsTillStun(int hits) {
        this.entityData.set(HITS_TILL_STUN, (Object)hits);
    }

    public Optional<BlockPos> getPossibleDetectionPoint() {
        return (Optional)this.getEntityData().get(POSSIBLE_DETECTION_POINT);
    }

    public void setPossibleDetectionPoint(Optional<BlockPos> detectionPoint) {
        this.getEntityData().set(POSSIBLE_DETECTION_POINT, detectionPoint);
    }

    public EntityDimensions getCaughtSize() {
        return (EntityDimensions)this.entityData.get(CAUGHT_SIZE);
    }

    public void setCaughtSize(EntityDimensions caughtSize) {
        this.entityData.set(CAUGHT_SIZE, (Object)caughtSize);
    }

    public int getTicksSinceLastSonarFire() {
        return this.ticksSinceLastSonarFire;
    }

    public boolean isStunned() {
        return this.getStunTime() > 0;
    }

    private void setStunned(int ticks) {
        this.entityData.set(STUN_TIME, (Object)ticks);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("IsMoving", this.isMoving());
        compound.putInt("WaterTicks", this.getWaterTime());
        compound.putInt("StunnedTicks", this.getStunTime());
        compound.putInt("TicksSinceLastSonarFire", this.getTicksSinceLastSonarFire());
        if (this.getPossibleDetectionPoint().isPresent()) {
            compound.put("DetectionPoint", NbtUtils.writeBlockPos((BlockPos)this.getPossibleDetectionPoint().get()));
        }
    }

    protected EntityDimensions getDefaultSize() {
        return DEFAULT_SIZE;
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setMoving(compound.getBoolean("IsMoving"));
        this.setWaterTime(compound.getInt("WaterTicks"));
        this.setStunned(compound.getInt("StunnedTicks"));
        this.ticksSinceLastSonarFire = compound.getInt("TicksSinceLastSonarFire");
        if (this.getPossibleDetectionPoint().isPresent()) {
            this.setPossibleDetectionPoint(NbtUtils.readBlockPos((CompoundTag)compound, (String)"DetectionPoint"));
        }
    }

    static class ThrasherMoveController
    extends MoveControl {
        private final Thrasher thrasher;

        public ThrasherMoveController(Thrasher thrasher) {
            super((Mob)thrasher);
            this.thrasher = thrasher;
        }

        public void tick() {
            if (this.operation == MoveControl.Operation.MOVE_TO && !this.thrasher.getNavigation().isDone() && this.thrasher.getStunTime() <= 0) {
                Vec3 vec3d = new Vec3(this.wantedX - this.thrasher.getX(), this.wantedY - this.thrasher.getY(), this.wantedZ - this.thrasher.getZ());
                double d0 = vec3d.length();
                double d1 = vec3d.y / d0;
                float f = (float)(Mth.atan2((double)vec3d.z, (double)vec3d.x) * 57.2957763671875) - 90.0f;
                this.thrasher.setYRot(this.rotlerp(this.thrasher.getYRot(), f, 10.0f));
                this.thrasher.yBodyRot = this.thrasher.getYRot();
                this.thrasher.yHeadRot = this.thrasher.getYRot();
                float f1 = (float)(this.speedModifier * this.thrasher.getAttribute(Attributes.MOVEMENT_SPEED).getValue());
                float f2 = Mth.lerp((float)0.125f, (float)this.thrasher.getSpeed(), (float)f1);
                this.thrasher.setSpeed(f2);
                double d2 = Math.sin((double)(this.thrasher.tickCount + this.thrasher.getId()) * 0.5) * 0.05;
                double d3 = Math.cos(this.thrasher.getYRot() * ((float)Math.PI / 180));
                double d4 = Math.sin(this.thrasher.getYRot() * ((float)Math.PI / 180));
                double d5 = Math.sin((double)(this.thrasher.tickCount + this.thrasher.getId()) * 0.75) * 0.05;
                if (this.thrasher.isInWater()) {
                    float f3 = -((float)(Mth.atan2((double)vec3d.y, (double)Mth.sqrt((float)((float)(vec3d.x * vec3d.x + vec3d.z * vec3d.z)))) * 57.2957763671875));
                    f3 = Mth.clamp((float)Mth.wrapDegrees((float)f3), (float)-85.0f, (float)85.0f);
                    this.thrasher.setXRot(this.rotlerp(this.thrasher.getXRot(), f3, 5.0f));
                }
                this.thrasher.setDeltaMovement(this.thrasher.getDeltaMovement().add(d2 * d3, d5 * (d4 + d3) * 0.25 + (double)f2 * d1 * 0.1, d2 * d4));
                this.thrasher.setMoving(true);
            } else {
                this.thrasher.setSpeed(0.0f);
                this.thrasher.setMoving(false);
            }
        }
    }

    public static class ThrasherLookController
    extends LookControl {
        private boolean isTurningForSonar;

        public ThrasherLookController(Thrasher thrasher) {
            super((Mob)thrasher);
        }

        public void tick() {
            float angleLimit;
            if (this.lookAtCooldown > 0) {
                --this.lookAtCooldown;
                if (this.isTurningForSonar) {
                    this.getYRotD().ifPresent(yRot -> this.mob.setYRot(this.rotateTowards(this.mob.getYRot(), yRot.floatValue(), this.yMaxRotSpeed)));
                } else {
                    this.getYRotD().ifPresent(yRot -> {
                        this.mob.yHeadRot = this.rotateTowards(this.mob.yHeadRot, yRot.floatValue(), this.yMaxRotSpeed);
                    });
                }
                this.mob.setXRot(this.rotateTowards(this.mob.getXRot(), ((Float)this.getXRotD().get()).floatValue(), this.xMaxRotAngle));
            } else {
                if (this.mob.getNavigation().isDone()) {
                    this.mob.setXRot(this.rotateTowards(this.mob.getXRot(), 0.0f, 5.0f));
                }
                if (this.isTurningForSonar) {
                    this.mob.setYRot(this.rotateTowards(this.mob.getYRot(), this.mob.yBodyRot, this.yMaxRotSpeed));
                } else {
                    this.mob.yHeadRot = this.rotateTowards(this.mob.yHeadRot, this.mob.yBodyRot, this.yMaxRotSpeed);
                }
            }
            float wrappedDegrees = Mth.wrapDegrees((float)(this.mob.yHeadRot - this.mob.yBodyRot));
            float f = angleLimit = this.mob.getPassengers().isEmpty() ? 10.0f : 5.0f;
            if (wrappedDegrees < -angleLimit) {
                this.mob.yBodyRot -= 4.0f;
            } else if (wrappedDegrees > angleLimit) {
                this.mob.yBodyRot += 4.0f;
            }
        }

        public boolean isTurningForSonar() {
            return this.isTurningForSonar;
        }

        public void setTurningForSonar(boolean isTurning) {
            this.isTurningForSonar = isTurning;
        }
    }
}

