/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.common.entity.monster;

import com.teamabnormals.upgrade_aquatic.core.registry.UAItems;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.ServerStatsCounter;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class Flare
extends FlyingMob {
    private static final EntityDataAccessor<Integer> SIZE = SynchedEntityData.defineId(Flare.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private Vec3 orbitOffset = Vec3.ZERO;
    private BlockPos orbitPosition = BlockPos.ZERO;
    private AttackPhase attackPhase = AttackPhase.CIRCLE;

    public Flare(EntityType<? extends Flare> type, Level world) {
        super(type, world);
        this.xpReward = 5;
        this.moveControl = new MoveHelperController((Mob)this);
        this.lookControl = new LookHelperController(this, (Mob)this);
    }

    protected BodyRotationControl createBodyControl() {
        return new BodyHelperController((Mob)this);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new PickAttackGoal());
        this.goalSelector.addGoal(2, (Goal)new SweepAttackGoal());
        this.goalSelector.addGoal(3, (Goal)new OrbitPointGoal());
        this.targetSelector.addGoal(1, (Goal)new AttackLivingEntityGoal());
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.createMobAttributes().add(Attributes.ATTACK_DAMAGE);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(SIZE, (Object)0);
    }

    public void setPhantomSize(int sizeIn) {
        this.entityData.set(SIZE, (Object)Mth.clamp((int)sizeIn, (int)0, (int)64));
    }

    private void updatePhantomSize() {
        this.refreshDimensions();
        this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue((double)(12 + this.getPhantomSize()));
    }

    public int getPhantomSize() {
        return (Integer)this.entityData.get(SIZE);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        if (SIZE.equals(key)) {
            this.updatePhantomSize();
        }
        super.onSyncedDataUpdated(key);
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide) {
            float f = Mth.cos((float)((float)(this.getId() * 3 + this.tickCount) * 0.13f + (float)Math.PI));
            float f1 = Mth.cos((float)((float)(this.getId() * 3 + this.tickCount + 1) * 0.13f + (float)Math.PI));
            if (f > 0.0f && f1 <= 0.0f) {
                this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), SoundEvents.PHANTOM_FLAP, this.getSoundSource(), 0.95f + this.random.nextFloat() * 0.05f, 0.95f + this.random.nextFloat() * 0.05f, false);
            }
            int i = this.getPhantomSize();
            float f2 = Mth.cos((float)(this.getYRot() * ((float)Math.PI / 180))) * (1.3f + 0.21f * (float)i);
            float f3 = Mth.sin((float)(this.getYRot() * ((float)Math.PI / 180))) * (1.3f + 0.21f * (float)i);
            float f4 = (0.3f + f * 0.45f) * ((float)i * 0.2f + 1.0f);
            this.level().addParticle((ParticleOptions)ParticleTypes.PORTAL, this.getX() + (double)f2, this.getY() + (double)f4, this.getZ() + (double)f3, 0.0, 0.0, 0.0);
            this.level().addParticle((ParticleOptions)ParticleTypes.PORTAL, this.getX() - (double)f2, this.getY() + (double)f4, this.getZ() - (double)f3, 0.0, 0.0, 0.0);
        }
        if (!this.level().isClientSide && this.level().getDifficulty() == Difficulty.PEACEFUL) {
            this.discard();
        }
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn) {
        this.orbitPosition = this.blockPosition().above(5);
        this.setPhantomSize(0);
        return super.finalizeSpawn(worldIn, difficultyIn, reason, spawnDataIn);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("AX")) {
            this.orbitPosition = new BlockPos(compound.getInt("AX"), compound.getInt("AY"), compound.getInt("AZ"));
        }
        this.setPhantomSize(compound.getInt("Size"));
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("AX", this.orbitPosition.getX());
        compound.putInt("AY", this.orbitPosition.getY());
        compound.putInt("AZ", this.orbitPosition.getZ());
        compound.putInt("Size", this.getPhantomSize());
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldRenderAtSqrDistance(double distance) {
        return true;
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)UAItems.FLARE_SPAWN_EGG.get());
    }

    public SoundSource getSoundSource() {
        return SoundSource.HOSTILE;
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.PHANTOM_AMBIENT;
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return SoundEvents.PHANTOM_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.PHANTOM_DEATH;
    }

    protected float getSoundVolume() {
        return 1.0f;
    }

    public boolean canAttackType(EntityType<?> typeIn) {
        return true;
    }

    static enum AttackPhase {
        CIRCLE,
        SWOOP;

    }

    class MoveHelperController
    extends MoveControl {
        private float speedFactor;

        public MoveHelperController(Mob entityIn) {
            super(entityIn);
            this.speedFactor = 0.1f;
        }

        public void tick() {
            if (Flare.this.horizontalCollision) {
                Flare.this.setYRot(Flare.this.getYRot() + 180.0f);
                this.speedFactor = 0.1f;
            }
            float f = (float)(Flare.this.orbitOffset.x - Flare.this.getX());
            float f1 = (float)(Flare.this.orbitOffset.y - Flare.this.getY());
            float f2 = (float)(Flare.this.orbitOffset.z - Flare.this.getZ());
            double d0 = Mth.sqrt((float)(f * f + f2 * f2));
            double d1 = 1.0 - (double)Mth.abs((float)(f1 * 0.7f)) / d0;
            f = (float)((double)f * d1);
            f2 = (float)((double)f2 * d1);
            d0 = Mth.sqrt((float)(f * f + f2 * f2));
            double d2 = Mth.sqrt((float)(f * f + f2 * f2 + f1 * f1));
            float f3 = Flare.this.getYRot();
            float f4 = (float)Mth.atan2((double)f2, (double)f);
            float f5 = Mth.wrapDegrees((float)(Flare.this.getYRot() + 90.0f));
            float f6 = Mth.wrapDegrees((float)(f4 * 57.295776f));
            Flare.this.setYRot(Mth.approachDegrees((float)f5, (float)f6, (float)4.0f) - 90.0f);
            Flare.this.yBodyRot = Flare.this.getYRot();
            this.speedFactor = Mth.degreesDifferenceAbs((float)f3, (float)Flare.this.getYRot()) < 3.0f ? Mth.approach((float)this.speedFactor, (float)1.8f, (float)(0.005f * (1.8f / this.speedFactor))) : Mth.approach((float)this.speedFactor, (float)0.2f, (float)0.025f);
            float f7 = (float)(-(Mth.atan2((double)(-f1), (double)d0) * 57.2957763671875));
            Flare.this.setXRot(f7);
            float f8 = Flare.this.getYRot() + 90.0f;
            double d3 = (double)(this.speedFactor * Mth.cos((float)(f8 * ((float)Math.PI / 180)))) * Math.abs((double)f / d2);
            double d4 = (double)(this.speedFactor * Mth.sin((float)(f8 * ((float)Math.PI / 180)))) * Math.abs((double)f2 / d2);
            double d5 = (double)(this.speedFactor * Mth.sin((float)(f7 * ((float)Math.PI / 180)))) * Math.abs((double)f1 / d2);
            Vec3 vec3d = Flare.this.getDeltaMovement();
            Flare.this.setDeltaMovement(vec3d.add(new Vec3(d3, d5, d4).subtract(vec3d).scale(0.2)));
        }
    }

    class LookHelperController
    extends LookControl {
        public LookHelperController(Flare this$0, Mob entityIn) {
            super(entityIn);
        }

        public void tick() {
        }
    }

    class BodyHelperController
    extends BodyRotationControl {
        public BodyHelperController(Mob p_i49925_2_) {
            super(p_i49925_2_);
        }

        public void clientTick() {
            Flare.this.yHeadRot = Flare.this.yBodyRot;
            Flare.this.yBodyRot = Flare.this.getYRot();
        }
    }

    class PickAttackGoal
    extends Goal {
        private int tickDelay;

        private PickAttackGoal() {
        }

        public boolean canUse() {
            LivingEntity livingentity = Flare.this.getTarget();
            return livingentity != null && Flare.this.canAttack(Flare.this.getTarget(), TargetingConditions.DEFAULT);
        }

        public void start() {
            this.tickDelay = 10;
            Flare.this.attackPhase = AttackPhase.CIRCLE;
            this.setAnchorAboveTarget();
        }

        public void stop() {
            Flare.this.orbitPosition = Flare.this.level().getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, Flare.this.orbitPosition).above(10 + Flare.this.random.nextInt(20));
        }

        public void tick() {
            if (Flare.this.attackPhase == AttackPhase.CIRCLE) {
                --this.tickDelay;
                if (this.tickDelay <= 0) {
                    Flare.this.attackPhase = AttackPhase.SWOOP;
                    this.setAnchorAboveTarget();
                    this.tickDelay = (8 + Flare.this.random.nextInt(4)) * 20;
                    Flare.this.playSound(SoundEvents.PHANTOM_SWOOP, 10.0f, 0.95f + Flare.this.random.nextFloat() * 0.1f);
                }
            }
        }

        private void setAnchorAboveTarget() {
            Flare.this.orbitPosition = Flare.this.getTarget().blockPosition().above(20 + Flare.this.random.nextInt(20));
            if (Flare.this.orbitPosition.getY() < Flare.this.level().getSeaLevel()) {
                Flare.this.orbitPosition = new BlockPos(Flare.this.orbitPosition.getX(), Flare.this.level().getSeaLevel() + 1, Flare.this.orbitPosition.getZ());
            }
        }
    }

    class SweepAttackGoal
    extends MoveGoal {
        private SweepAttackGoal() {
        }

        public boolean canUse() {
            return Flare.this.getTarget() != null && Flare.this.attackPhase == AttackPhase.SWOOP;
        }

        public boolean canContinueToUse() {
            LivingEntity livingentity = Flare.this.getTarget();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.isAlive()) {
                return false;
            }
            if (!(livingentity instanceof Player) || !livingentity.isSpectator() && !((Player)livingentity).isCreative()) {
                List list;
                if (!this.canUse()) {
                    return false;
                }
                if (Flare.this.tickCount % 20 == 0 && !(list = Flare.this.level().getEntitiesOfClass(Cat.class, Flare.this.getBoundingBox().inflate(16.0), EntitySelector.ENTITY_STILL_ALIVE)).isEmpty()) {
                    for (Cat catentity : list) {
                        catentity.hiss();
                    }
                    return false;
                }
                return true;
            }
            return false;
        }

        public void start() {
        }

        public void stop() {
            if (Flare.this.getTarget() instanceof Player) {
                Flare.this.setTarget(null);
            }
            Flare.this.attackPhase = AttackPhase.CIRCLE;
        }

        public void tick() {
            LivingEntity livingentity = Flare.this.getTarget();
            Flare.this.orbitOffset = new Vec3(livingentity.getX(), livingentity.getY() + (double)livingentity.getBbHeight() * 0.5, livingentity.getZ());
            if (Flare.this.getBoundingBox().inflate((double)0.2f).intersects(livingentity.getBoundingBox())) {
                Flare.this.doHurtTarget((Entity)livingentity);
                Flare.this.attackPhase = AttackPhase.CIRCLE;
                Flare.this.level().levelEvent(1039, Flare.this.blockPosition(), 0);
            } else if (Flare.this.horizontalCollision || Flare.this.hurtTime > 0) {
                Flare.this.attackPhase = AttackPhase.CIRCLE;
            }
        }
    }

    class OrbitPointGoal
    extends MoveGoal {
        private float angle;
        private float distance;
        private float height;
        private float clockwise;

        private OrbitPointGoal() {
        }

        public boolean canUse() {
            return Flare.this.getTarget() == null || Flare.this.attackPhase == AttackPhase.CIRCLE;
        }

        public void start() {
            this.distance = 5.0f + Flare.this.random.nextFloat() * 10.0f;
            this.height = -4.0f + Flare.this.random.nextFloat() * 9.0f;
            this.clockwise = Flare.this.random.nextBoolean() ? 1.0f : -1.0f;
            this.selectNext();
        }

        public void tick() {
            if (Flare.this.random.nextInt(350) == 0) {
                this.height = -4.0f + Flare.this.random.nextFloat() * 9.0f;
            }
            if (Flare.this.random.nextInt(250) == 0) {
                this.distance += 1.0f;
                if (this.distance > 15.0f) {
                    this.distance = 5.0f;
                    this.clockwise = -this.clockwise;
                }
            }
            if (Flare.this.random.nextInt(450) == 0) {
                this.angle = Flare.this.random.nextFloat() * 2.0f * (float)Math.PI;
                this.selectNext();
            }
            if (this.touchingTarget()) {
                this.selectNext();
            }
            if (Flare.this.orbitOffset.y < Flare.this.getY() && !Flare.this.level().isEmptyBlock(Flare.this.blockPosition().below(1))) {
                this.height = Math.max(1.0f, this.height);
                this.selectNext();
            }
            if (Flare.this.orbitOffset.y > Flare.this.getY() && !Flare.this.level().isEmptyBlock(Flare.this.blockPosition().above(1))) {
                this.height = Math.min(-1.0f, this.height);
                this.selectNext();
            }
        }

        private void selectNext() {
            if (BlockPos.ZERO.equals((Object)Flare.this.orbitPosition)) {
                Flare.this.orbitPosition = Flare.this.blockPosition();
            }
            this.angle += this.clockwise * 15.0f * ((float)Math.PI / 180);
            Flare.this.orbitOffset = new Vec3((double)Flare.this.orbitPosition.getX(), (double)Flare.this.orbitPosition.getY(), (double)Flare.this.orbitPosition.getZ()).add((double)(this.distance * Mth.cos((float)this.angle)), (double)(-4.0f + this.height), (double)(this.distance * Mth.sin((float)this.angle)));
        }
    }

    public class AttackLivingEntityGoal
    extends Goal {
        private final TargetingConditions attackTargeting = TargetingConditions.forCombat().range(64.0);
        private int tickDelay = 20;

        private AttackLivingEntityGoal() {
        }

        public boolean canUse() {
            if (this.tickDelay > 0) {
                --this.tickDelay;
                return false;
            }
            this.tickDelay = 60;
            List list = Flare.this.level().getNearbyEntities(LivingEntity.class, this.attackTargeting, (LivingEntity)Flare.this, Flare.this.getBoundingBox().inflate(16.0, 64.0, 16.0));
            if (!list.isEmpty()) {
                for (LivingEntity mob : list) {
                    if (!Flare.this.canAttack(mob, TargetingConditions.DEFAULT)) continue;
                    if (mob instanceof ServerPlayer) {
                        ServerStatsCounter statisticsManager = ((ServerPlayer)mob).getStats();
                        if (statisticsManager.getValue(Stats.CUSTOM.get((Object)Stats.TIME_SINCE_REST)) >= 72000) continue;
                        Flare.this.setTarget(mob);
                        return true;
                    }
                    if (mob instanceof Flare) continue;
                    Flare.this.setTarget(mob);
                    return true;
                }
            }
            return false;
        }

        public boolean canContinueToUse() {
            ServerStatsCounter statisticsManager;
            LivingEntity livingentity = Flare.this.getTarget();
            if (livingentity instanceof ServerPlayer && (statisticsManager = ((ServerPlayer)livingentity).getStats()).getValue(Stats.CUSTOM.get((Object)Stats.TIME_SINCE_REST)) < 72000) {
                return Flare.this.canAttack(livingentity, TargetingConditions.DEFAULT);
            }
            return livingentity != null;
        }
    }

    abstract class MoveGoal
    extends Goal {
        public MoveGoal() {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        protected boolean touchingTarget() {
            return Flare.this.orbitOffset.distanceToSqr(Flare.this.getX(), Flare.this.getY(), Flare.this.getZ()) < 4.0;
        }
    }
}

