/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.common.entity.animal.jellyfish;

import com.teamabnormals.upgrade_aquatic.common.block.JellyTorchBlock;
import com.teamabnormals.upgrade_aquatic.common.entity.ai.goal.jellyfish.CassiopeaHideInSeagrassGoal;
import com.teamabnormals.upgrade_aquatic.common.entity.ai.goal.jellyfish.CassiopeaJellyfishFlipGoal;
import com.teamabnormals.upgrade_aquatic.common.entity.ai.goal.jellyfish.JellyfishRandomSwimmingGoal;
import com.teamabnormals.upgrade_aquatic.common.entity.animal.jellyfish.AbstractJellyfish;
import com.teamabnormals.upgrade_aquatic.common.entity.animal.jellyfish.ColoredSizableJellyfish;
import com.teamabnormals.upgrade_aquatic.core.registry.datapack.UADamageTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.level.Level;

public class CassiopeaJellyfish
extends ColoredSizableJellyfish {
    public int upsideDownCooldown;
    public int hideCooldown;

    public CassiopeaJellyfish(EntityType<? extends AbstractJellyfish> type, Level world) {
        super(type, world);
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return AbstractJellyfish.createAttributes().add(Attributes.ATTACK_DAMAGE, 1.0);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new CassiopeaHideInSeagrassGoal(this));
        this.goalSelector.addGoal(2, (Goal)new CassiopeaJellyfishFlipGoal(this));
        this.goalSelector.addGoal(2, (Goal)new JellyfishRandomSwimmingGoal(this));
        this.targetSelector.addGoal(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    @Override
    public void tick() {
        super.tick();
        if (this.hasUpsideDownCooldown()) {
            --this.upsideDownCooldown;
        }
        if (this.hasHideCooldown()) {
            --this.hideCooldown;
        }
    }

    @Override
    public void addAdditionalSaveDataSharedWithBucket(CompoundTag tag) {
        super.addAdditionalSaveDataSharedWithBucket(tag);
        tag.putInt("UpsideDownCooldown", this.upsideDownCooldown);
        tag.putInt("HideCooldown", this.hideCooldown);
    }

    @Override
    protected void readAdditionalSaveDataSharedWithBucket(CompoundTag tag) {
        super.readAdditionalSaveDataSharedWithBucket(tag);
        this.upsideDownCooldown = tag.getInt("UpsideDownCooldown");
        this.hideCooldown = tag.getInt("HideCooldown");
    }

    public boolean hasUpsideDownCooldown() {
        return this.upsideDownCooldown > 0;
    }

    public boolean hasHideCooldown() {
        return this.hideCooldown > 0;
    }

    public EntityDimensions getDefaultDimensions(Pose pose) {
        return super.getDefaultDimensions(pose).scale(this.getSize());
    }

    public int getMaxSpawnClusterSize() {
        return 3;
    }

    public String getVariantName() {
        return switch (this.getColor()) {
            default -> "cassiopea";
            case 1 -> "blue_cassiopea";
            case 2 -> "white_cassiopea";
        };
    }

    @Override
    public AbstractJellyfish.BucketDisplayInfo getBucketDisplayInfo() {
        JellyTorchBlock.JellyTorchType jellyTorchType = this.getJellyTorchType();
        return this.bucketDisplayInfo(this.getVariantName(), jellyTorchType.ordinal(), jellyTorchType);
    }

    @Override
    public JellyTorchBlock.JellyTorchType getJellyTorchType() {
        return switch (this.getColor()) {
            default -> JellyTorchBlock.JellyTorchType.GREEN;
            case 1 -> JellyTorchBlock.JellyTorchType.BLUE;
            case 2 -> JellyTorchBlock.JellyTorchType.WHITE;
        };
    }

    @Override
    public float getCooldownChance() {
        return this.getSize() < 1.0f ? 0.9f : 0.8f;
    }

    @Override
    public boolean stingEntity(LivingEntity livingEntity) {
        if ((this.getTarget() == livingEntity || this.getLastHurtByMob() == livingEntity) && this.getRandom().nextFloat() < 0.5f) {
            return livingEntity.hurt(UADamageTypes.jellyfishSting(this.level(), (Entity)this), (float)this.getAttribute(Attributes.ATTACK_DAMAGE).getValue());
        }
        return false;
    }

    @Override
    protected float getHealthSizeMultiplier() {
        return 6.0f;
    }

    @Override
    protected float getDefaultSize() {
        return 0.85f;
    }
}

