/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.common.entity.animal;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamabnormals.upgrade_aquatic.core.other.UADataMaps;
import com.teamabnormals.upgrade_aquatic.core.registry.UARegistries;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.Weight;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.level.biome.Biome;

public record PikeVariant(ResourceLocation assetId, Component description, float size, int weight, Optional<HolderSet<Biome>> biomes, Optional<ResourceLocation> glowAssetId) implements WeightedEntry
{
    public static final Codec<PikeVariant> DIRECT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("asset_id").forGetter(PikeVariant::assetId), (App)ComponentSerialization.CODEC.fieldOf("description").forGetter(PikeVariant::description), (App)Codec.FLOAT.fieldOf("size").forGetter(PikeVariant::size), (App)Codec.INT.fieldOf("weight").forGetter(PikeVariant::weight), (App)RegistryCodecs.homogeneousList((ResourceKey)Registries.BIOME).optionalFieldOf("biomes").forGetter(PikeVariant::biomes), (App)ResourceLocation.CODEC.optionalFieldOf("glow_asset_id").forGetter(PikeVariant::glowAssetId)).apply((Applicative)instance, PikeVariant::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, PikeVariant> DIRECT_STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, PikeVariant::assetId, (StreamCodec)ComponentSerialization.STREAM_CODEC, PikeVariant::description, (StreamCodec)ByteBufCodecs.FLOAT, PikeVariant::size, (StreamCodec)ByteBufCodecs.INT, PikeVariant::weight, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.holderSet((ResourceKey)Registries.BIOME)), PikeVariant::biomes, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ResourceLocation.STREAM_CODEC), PikeVariant::glowAssetId, PikeVariant::new);
    public static final Codec<Holder<PikeVariant>> CODEC = RegistryFileCodec.create(UARegistries.PIKE_VARIANT, DIRECT_CODEC);
    public static final StreamCodec<RegistryFriendlyByteBuf, Holder<PikeVariant>> STREAM_CODEC = ByteBufCodecs.holder(UARegistries.PIKE_VARIANT, DIRECT_STREAM_CODEC);

    public Weight getWeight() {
        return Weight.of((int)this.weight());
    }

    public static Holder<PikeVariant> getSpawnVariant(RegistryAccess registryAccess, Holder<Biome> biome, boolean fromBucket, RandomSource random) {
        WeightedRandomList variants;
        Holder variant;
        Registry registry = registryAccess.registryOrThrow(UARegistries.PIKE_VARIANT);
        Map spotted = registry.getDataMap(UADataMaps.SPOTTED_PIKE_VARIANTS);
        if (spotted.get((variant = registry.wrapAsHolder((Object)((PikeVariant)(variants = WeightedRandomList.create(PikeVariant.getPossibleTypes((Registry<PikeVariant>)registry, biome, fromBucket))).getRandom(random).orElseThrow()))).getKey()) != null) {
            UADataMaps.SpottedPikeVariant spottedVariant = (UADataMaps.SpottedPikeVariant)spotted.get(variant.getKey());
            if (random.nextFloat() < spottedVariant.chance()) {
                return spottedVariant.spottedVariant();
            }
        }
        return variant;
    }

    private static List<PikeVariant> getPossibleTypes(Registry<PikeVariant> registry, Holder<Biome> biome, boolean fromBucket) {
        Map spotted = registry.getDataMap(UADataMaps.SPOTTED_PIKE_VARIANTS);
        List<Holder> spottedVariants = spotted.values().stream().map(UADataMaps.SpottedPikeVariant::spottedVariant).toList();
        ArrayList validVariants = Lists.newArrayList();
        for (Holder holder : registry.holders().toList()) {
            PikeVariant variant = (PikeVariant)holder.value();
            if (!fromBucket && !variant.biomes().isEmpty() && !variant.biomes().get().contains(biome) || spottedVariants.contains(holder)) continue;
            validVariants.add(variant);
        }
        return validVariants;
    }
}

