/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.common.entity.animal;

import com.google.common.collect.Lists;
import com.teamabnormals.blueprint.common.entity.BucketableWaterAnimal;
import com.teamabnormals.upgrade_aquatic.api.util.UAEntityPredicates;
import com.teamabnormals.upgrade_aquatic.common.block.PickerelweedBlock;
import com.teamabnormals.upgrade_aquatic.common.block.PickerelweedDoublePlantBlock;
import com.teamabnormals.upgrade_aquatic.common.block.PickerelweedPlantBlock;
import com.teamabnormals.upgrade_aquatic.common.entity.ai.goal.pike.HideInPickerelweedGoal;
import com.teamabnormals.upgrade_aquatic.common.entity.ai.goal.pike.PikeAttackGoal;
import com.teamabnormals.upgrade_aquatic.common.entity.ai.goal.pike.PikeSwimToItemsGoal;
import com.teamabnormals.upgrade_aquatic.common.entity.ai.goal.pike.PikeTemptGoal;
import com.teamabnormals.upgrade_aquatic.common.entity.animal.PikeVariant;
import com.teamabnormals.upgrade_aquatic.core.other.UADataSerializers;
import com.teamabnormals.upgrade_aquatic.core.other.tags.UABlockTags;
import com.teamabnormals.upgrade_aquatic.core.registry.UAItems;
import com.teamabnormals.upgrade_aquatic.core.registry.UAParticleTypes;
import com.teamabnormals.upgrade_aquatic.core.registry.UARegistries;
import com.teamabnormals.upgrade_aquatic.core.registry.UASoundEvents;
import com.teamabnormals.upgrade_aquatic.core.registry.datapack.UAPikeVariants;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class Pike
extends BucketableWaterAnimal
implements VariantHolder<Holder<PikeVariant>> {
    private static final EntityDataAccessor<Holder<PikeVariant>> VARIANT = SynchedEntityData.defineId(Pike.class, (EntityDataSerializer)((EntityDataSerializer)UADataSerializers.PIKE_VARIANT.get()));
    private static final EntityDataAccessor<Boolean> DROP_ITEM = SynchedEntityData.defineId(Pike.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> MOVING = SynchedEntityData.defineId(Pike.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> LIT = SynchedEntityData.defineId(Pike.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> ATTACK_COOLDOWN = SynchedEntityData.defineId(Pike.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final Predicate<ItemEntity> ITEM_SELECTOR = entity -> !entity.hasPickUpDelay() && entity.isAlive() && entity.isInWater() && entity.getItem().is(ItemTags.FISHES);
    private int eatTicks;
    private int dropEatingLootCooldown;

    public Pike(EntityType<? extends Pike> type, Level world) {
        super(type, world);
        this.moveControl = new MoveHelperController(this);
        this.startUsingItem(InteractionHand.MAIN_HAND);
        this.setCanPickUpLoot(true);
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 12.0).add(Attributes.MOVEMENT_SPEED, 0.9);
    }

    protected void registerGoals() {
        super.registerGoals();
        if (!this.getVariant().is(UAPikeVariants.SPECTRAL)) {
            this.goalSelector.addGoal(2, (Goal)new AvoidEntityGoal<Pike>(this, (PathfinderMob)this, Pike.class, 8.0f, 1.6, 1.4, UAEntityPredicates.IS_SPECTRAL::test){

                public boolean canUse() {
                    return super.canUse() && this.mob != null && !((Pike)this.mob).getVariant().is(UAPikeVariants.SPECTRAL);
                }
            });
        }
        this.goalSelector.addGoal(3, (Goal)new PikeTemptGoal(this));
        this.goalSelector.addGoal(4, (Goal)new RandomSwimmingGoal(this, (PathfinderMob)this, 1.1, 40){

            public boolean canUse() {
                return ((Pike)this.mob).isHidingInPickerelweed() ? super.canUse() && this.mob.getRandom().nextInt(6) == 0 : super.canUse();
            }
        });
        this.goalSelector.addGoal(4, (Goal)new HideInPickerelweedGoal(this));
        this.goalSelector.addGoal(4, (Goal)new PikeSwimToItemsGoal(this));
        this.goalSelector.addGoal(4, (Goal)new PikeAttackGoal((PathfinderMob)this, 12.0, true));
        this.targetSelector.addGoal(5, (Goal)new NearestAttackableTargetGoal<AbstractFish>(this, (Mob)this, AbstractFish.class, true){

            public boolean canUse() {
                return ((Pike)this.mob).getAttackCooldown() <= 0 && super.canUse();
            }
        });
        this.targetSelector.addGoal(5, (Goal)new NearestAttackableTargetGoal<Turtle>(this, (Mob)this, Turtle.class, 10, true, false, UAEntityPredicates.IS_CHILD::test){

            public boolean canUse() {
                return ((Pike)this.mob).getAttackCooldown() <= 0 && super.canUse();
            }
        });
        this.targetSelector.addGoal(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        Registry registry = this.registryAccess().registryOrThrow(UARegistries.PIKE_VARIANT);
        builder.define(VARIANT, (Object)((Holder)registry.getHolder(UAPikeVariants.DEFAULT).or(() -> ((Registry)registry).getAny()).orElseThrow()));
        builder.define(DROP_ITEM, (Object)true);
        builder.define(MOVING, (Object)false);
        builder.define(LIT, (Object)false);
        builder.define(ATTACK_COOLDOWN, (Object)0);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        if (key.equals(VARIANT)) {
            this.refreshDimensions();
        }
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        this.getVariant().unwrapKey().ifPresent(variant -> compound.putString("BucketVariantTag", variant.location().toString()));
        compound.putInt("AttackCooldown", this.getAttackCooldown());
        compound.putInt("EatingLootDropCooldown", this.dropEatingLootCooldown);
        compound.putBoolean("DoesDropItem", this.shouldDropItem());
        compound.putBoolean("Lit", this.isLit());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        Optional.ofNullable(ResourceLocation.tryParse((String)compound.getString("BucketVariantTag"))).map(loc -> ResourceKey.create(UARegistries.PIKE_VARIANT, (ResourceLocation)loc)).flatMap(key -> this.registryAccess().registryOrThrow(UARegistries.PIKE_VARIANT).getHolder(key)).ifPresent(this::setVariant);
        this.dropEatingLootCooldown = compound.getInt("EatingLootDropCooldown");
        this.setAttackCooldown(compound.getInt("AttackCooldown"));
        this.setToDropItem(compound.getBoolean("DoesDropItem"));
        this.setLit(compound.getBoolean("Lit"));
    }

    public void aiStep() {
        int i;
        LivingEntity caughtEntity;
        super.aiStep();
        ++this.eatTicks;
        if (this.dropEatingLootCooldown > 0) {
            --this.dropEatingLootCooldown;
        }
        if (!this.isInWater() && this.onGround() && this.verticalCollision) {
            this.setDeltaMovement(this.getDeltaMovement().add((double)((this.random.nextFloat() * 2.0f - 1.0f) * 0.05f), (double)0.4f, (double)((this.random.nextFloat() * 2.0f - 1.0f) * 0.05f)));
            this.setOnGround(false);
            this.hasImpulse = true;
            this.playSound(this.getFlopSound(), this.getSoundVolume(), this.getVoicePitch());
        }
        if (this.level().getGameTime() % 20L == 0L && (caughtEntity = this.getCaughtEntity()) != null && (!this.isPickerelweedNearby() || this.isHidingInPickerelweed())) {
            this.level().playSound(null, this.blockPosition(), (SoundEvent)UASoundEvents.PIKE_BITE.get(), SoundSource.HOSTILE, 0.8f, 0.9f);
            if (this.level().isClientSide && caughtEntity.getHealth() <= 1.0f && this.getVariant().is(UAPikeVariants.SPECTRAL)) {
                for (i = 0; i < 3; ++i) {
                    this.level().addParticle((ParticleOptions)UAParticleTypes.SPECTRAL_CONSUME.get(), caughtEntity.getX() + (caughtEntity.getRandom().nextDouble() - 0.5) * (double)caughtEntity.getBbWidth(), caughtEntity.getY() + caughtEntity.getRandom().nextDouble() * (double)caughtEntity.getBbHeight() - 0.25, caughtEntity.getZ() + (caughtEntity.getRandom().nextDouble() - 0.5) * (double)caughtEntity.getBbWidth(), (this.getCaughtEntity().getRandom().nextDouble() - 0.5) * 2.0, -caughtEntity.getRandom().nextDouble(), (caughtEntity.getRandom().nextDouble() - 0.5) * 2.0);
                }
            }
            caughtEntity.hurt(this.damageSources().mobAttack((LivingEntity)this), 1.0f);
        }
        if (this.getAttackCooldown() > 0) {
            this.setAttackCooldown(this.getAttackCooldown() - 1);
        }
        ItemStack itemstack = this.getItemBySlot(EquipmentSlot.MAINHAND);
        if (!this.level().isClientSide && this.isAlive() && this.isEffectiveAi() && !itemstack.isEmpty() && this.canEatItem(itemstack) && this.isInWater()) {
            if (this.eatTicks > 600) {
                ItemStack itemstackFood = itemstack.finishUsingItem(this.level(), (LivingEntity)this);
                if (!itemstack.isEmpty()) {
                    this.setItemSlot(EquipmentSlot.MAINHAND, itemstackFood);
                }
                if (this.dropEatingLootCooldown <= 0) {
                    if (this.random.nextFloat() < 0.2f) {
                        for (ItemStack stacks : this.generateFishingLoot()) {
                            if (stacks.getCount() > 0) {
                                stacks.shrink(stacks.getCount() - 1);
                            }
                            this.spitOutItem(stacks);
                        }
                    } else {
                        this.spitOutItem(new ItemStack((ItemLike)Items.BONE_MEAL));
                    }
                    this.dropEatingLootCooldown = 3600 + this.getRandom().nextInt(400);
                }
                this.heal(6.0f);
                this.eatTicks = 0;
            } else if (this.eatTicks > 560 && this.random.nextFloat() < 0.1f) {
                this.playSound(this.getEatingSound(itemstack), 1.0f, 1.0f);
                this.level().broadcastEntityEvent((Entity)this, (byte)45);
            }
        }
        if (this.isMoving() && this.isInWater() && this.getVariant().is(UAPikeVariants.SUPERCHARGED)) {
            Vec3 vec3d1 = this.getViewVector(0.0f);
            for (int i2 = 0; i2 < 2; ++i2) {
                this.level().addParticle((ParticleOptions)ParticleTypes.BUBBLE, this.getX() + (this.random.nextDouble() - 0.5) * (double)this.getBbWidth() - vec3d1.x * 1.5, this.getY() + this.random.nextDouble() * (double)this.getBbHeight() - vec3d1.y * 1.5, this.getZ() + (this.random.nextDouble() - 0.5) * (double)this.getBbWidth() - vec3d1.z * 1.5, 0.0, 0.0, 0.0);
            }
        }
        if (this.getVariant().is(UAPikeVariants.OBSIDIAN) && this.isLit() && this.level().isClientSide) {
            for (i = 0; i < 2; ++i) {
                this.level().addParticle((ParticleOptions)ParticleTypes.PORTAL, this.getX() + (this.random.nextDouble() - 0.5) * (double)this.getBbWidth(), this.getY() + this.random.nextDouble() * (double)this.getBbHeight() - 0.25, this.getZ() + (this.random.nextDouble() - 0.5) * (double)this.getBbWidth(), (this.random.nextDouble() - 0.5) * 2.0, -this.random.nextDouble(), (this.random.nextDouble() - 0.5) * 2.0);
            }
        }
    }

    public void travel(Vec3 p_213352_1_) {
        if (this.isEffectiveAi() && this.isInWater()) {
            float speed = this.getVariant().is(UAPikeVariants.SUPERCHARGED) ? 0.05f : 0.01f;
            this.moveRelative(speed, p_213352_1_);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.9));
            if (this.getTarget() == null) {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.005, 0.0));
            }
        } else {
            super.travel(p_213352_1_);
        }
    }

    public boolean hurt(DamageSource source, float amount) {
        Entity entitySource = source.getEntity();
        if (!(this.hasCaughtEntity() || !(entitySource instanceof LivingEntity) || entitySource instanceof Player && ((Player)entitySource).getAbilities().instabuild)) {
            this.setTarget((LivingEntity)source.getEntity());
            return super.hurt(source, amount);
        }
        return super.hurt(source, amount);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, SpawnGroupData spawnGroupData) {
        Holder<PikeVariant> variant;
        spawnGroupData = super.finalizeSpawn(level, difficulty, reason, spawnGroupData);
        Holder biome = level.getBiome(this.blockPosition());
        if (spawnGroupData instanceof PikeData) {
            PikeData pikeGroupData = (PikeData)spawnGroupData;
            variant = pikeGroupData.type;
        } else {
            variant = PikeVariant.getSpawnVariant(this.registryAccess(), (Holder<Biome>)biome, reason == MobSpawnType.BUCKET, this.getRandom());
            if (!this.fromBucket()) {
                spawnGroupData = new PikeData(variant);
            }
        }
        this.setVariant(variant);
        if (this.random.nextFloat() < 0.1f && this.isEffectiveAi()) {
            List<ItemStack> generatedFishingLoot = this.generateFishingLoot();
            for (ItemStack itemstack : generatedFishingLoot) {
                this.setItemSlot(EquipmentSlot.MAINHAND, itemstack);
            }
            this.setToDropItem(false);
        }
        this.refreshDimensions();
        return spawnGroupData;
    }

    public static boolean checkPikeSpawnRules(EntityType<? extends Pike> entityType, LevelAccessor level, MobSpawnType spawnReason, BlockPos pos, RandomSource random) {
        int count = BlockPos.betweenClosedStream((BlockPos)pos.offset(-4, -6, -4), (BlockPos)pos.offset(4, 3, 4)).filter(offsetPos -> level.getBlockState(offsetPos).is(UABlockTags.PIKE_SPAWNABLE_IN)).toList().size();
        return random.nextFloat() < 0.05f * (float)count && WaterAnimal.checkSurfaceWaterAnimalSpawnRules(entityType, (LevelAccessor)level, (MobSpawnType)spawnReason, (BlockPos)pos, (RandomSource)random);
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (itemstack.getItem() == Items.FLINT_AND_STEEL) {
            itemstack.hurtAndBreak(1, (LivingEntity)player, Pike.getSlotForHand((InteractionHand)hand));
            this.playSound(SoundEvents.FLINTANDSTEEL_USE, 1.0f, 1.0f);
            this.setLit(true);
            return InteractionResult.SUCCESS;
        }
        return Bucketable.bucketMobPickup((Player)player, (InteractionHand)hand, (LivingEntity)this).orElse(super.mobInteract(player, hand));
    }

    protected PathNavigation createNavigation(Level worldIn) {
        return new WaterBoundPathNavigation(this, (Mob)this, worldIn){

            protected boolean canUpdatePath() {
                return super.canUpdatePath() || this.mob.getBlockStateOn().getBlock() instanceof PickerelweedBlock;
            }

            public boolean isStableDestination(BlockPos pos) {
                return super.isStableDestination(pos) || this.mob.getBlockStateOn().getBlock() instanceof PickerelweedBlock;
            }
        };
    }

    public ItemStack getBucketItemStack() {
        return new ItemStack((ItemLike)UAItems.PIKE_BUCKET.get());
    }

    public SoundEvent getPickupSound() {
        return SoundEvents.BUCKET_FILL_FISH;
    }

    public void saveToBucketTag(ItemStack stack) {
        super.saveToBucketTag(stack);
        CustomData.update((DataComponentType)DataComponents.BUCKET_ENTITY_DATA, (ItemStack)stack, tag -> {
            this.getVariant().unwrapKey().ifPresent(variant -> tag.putString("BucketVariantTag", variant.location().toString()));
            tag.putInt("EatingLootDropCooldown", this.dropEatingLootCooldown);
            tag.putBoolean("ShouldDropItem", this.shouldDropItem());
            tag.putBoolean("IsLit", this.isLit());
            CompoundTag heldItemTag = new CompoundTag();
            if (!this.getItemBySlot(EquipmentSlot.MAINHAND).isEmpty()) {
                this.getItemBySlot(EquipmentSlot.MAINHAND).save((HolderLookup.Provider)this.level().registryAccess(), (Tag)heldItemTag);
            }
            tag.put("PikeHeldItem", (Tag)heldItemTag);
        });
    }

    public void loadFromBucketTag(CompoundTag tag) {
        super.loadFromBucketTag(tag);
        if (tag.contains("BucketVariantTag", 8)) {
            Optional.ofNullable(ResourceLocation.tryParse((String)tag.getString("BucketVariantTag"))).map(loc -> ResourceKey.create(UARegistries.PIKE_VARIANT, (ResourceLocation)loc)).flatMap(key -> this.registryAccess().registryOrThrow(UARegistries.PIKE_VARIANT).getHolder(key)).ifPresent(this::setVariant);
            this.dropEatingLootCooldown = tag.getInt("EatingLootDropCooldown");
            if (tag.contains("ShouldDropItem")) {
                this.setToDropItem(tag.getBoolean("ShouldDropItem"));
            }
            if (tag.contains("IsLit")) {
                this.setLit(tag.getBoolean("IsLit"));
            }
            if (tag.contains("PikeHeldItem")) {
                this.startUsingItem(InteractionHand.MAIN_HAND);
                this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)tag.getString("PikeHeldItem")))));
            }
        }
    }

    @Nullable
    public LivingEntity getCaughtEntity() {
        List passengers = this.getPassengers();
        if (!passengers.isEmpty()) {
            Entity passenger = (Entity)passengers.get(0);
            return passenger instanceof AbstractFish || passenger instanceof Animal ? (LivingEntity)passenger : null;
        }
        return null;
    }

    public boolean hasCaughtEntity() {
        return this.getCaughtEntity() != null;
    }

    public void spitOutItem(ItemStack stackIn) {
        if (!stackIn.isEmpty() && !this.level().isClientSide) {
            ItemEntity itementity = new ItemEntity(this.level(), this.getX() + this.getLookAngle().x, this.getY() + 1.0, this.getZ() + this.getLookAngle().z, stackIn);
            itementity.setPickUpDelay(40);
            itementity.setThrower((Entity)this);
            this.playSound((SoundEvent)UASoundEvents.PIKE_SPIT.get(), 1.0f, 1.0f);
            this.level().addFreshEntity((Entity)itementity);
            this.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
        }
    }

    private boolean canEatItem(ItemStack itemstack) {
        return itemstack.is(ItemTags.FISHES);
    }

    public boolean isPickerelweedNearby() {
        return this.getNearbyPickerelweeds().size() > 0;
    }

    public boolean isHidingInPickerelweed() {
        return this.getCommandSenderWorld().getBlockState(this.blockPosition()).getBlock() instanceof PickerelweedPlantBlock || this.getCommandSenderWorld().getBlockState(this.blockPosition()).getBlock() instanceof PickerelweedDoublePlantBlock;
    }

    public List<BlockPos> getNearbyPickerelweeds() {
        ArrayList pickerelweeds = Lists.newArrayList();
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        int yy = this.blockPosition().getY() - 6;
        while ((double)yy <= this.getY() + 6.0) {
            int xx = this.blockPosition().getX() - 12;
            while ((double)xx <= this.getX() + 12.0) {
                int zz = this.blockPosition().getZ() - 12;
                while ((double)zz <= this.getZ() + 12.0) {
                    mutable.set(xx, yy, zz);
                    Block block = this.level().getBlockState((BlockPos)mutable).getBlock();
                    if (block instanceof PickerelweedPlantBlock || block instanceof PickerelweedDoublePlantBlock) {
                        pickerelweeds.add(mutable);
                    }
                    ++zz;
                }
                ++xx;
            }
            ++yy;
        }
        return pickerelweeds;
    }

    private List<ItemStack> generateFishingLoot() {
        LootParams.Builder builder = new LootParams.Builder((ServerLevel)this.level()).withParameter(LootContextParams.ORIGIN, (Object)this.position()).withParameter(LootContextParams.TOOL, (Object)new ItemStack((ItemLike)Items.FISHING_ROD)).withLuck(2.0f);
        builder.withParameter(LootContextParams.ATTACKING_ENTITY, (Object)this).withParameter(LootContextParams.THIS_ENTITY, (Object)this);
        LootTable loottable = this.level().getServer().reloadableRegistries().getLootTable(this.getRandom().nextFloat() >= 0.1f ? BuiltInLootTables.FISHING_JUNK : BuiltInLootTables.FISHING_TREASURE);
        return loottable.getRandomItems(builder.create(LootContextParamSets.FISHING));
    }

    public int getMaxSpawnClusterSize() {
        return 3;
    }

    public boolean canPickUpLoot() {
        return this.isInWater() && super.canPickUpLoot();
    }

    protected float getEquipmentDropChance(EquipmentSlot p_205712_1_) {
        return this.shouldDropItem() ? 100.0f : 0.0f;
    }

    public boolean canTakeItem(ItemStack stack) {
        EquipmentSlot slot = this.getEquipmentSlotForItem(stack);
        if (!this.getItemBySlot(slot).isEmpty()) {
            return false;
        }
        return slot == EquipmentSlot.MAINHAND && super.canTakeItem(stack);
    }

    protected void pickUpItem(ItemEntity itemEntity) {
        ItemStack itemstack = itemEntity.getItem();
        if (this.canHoldItem(itemstack) && !this.getItemBySlot(EquipmentSlot.MAINHAND).is(ItemTags.FISHES)) {
            int i = itemstack.getCount();
            if (i > 1) {
                this.spawnItem(itemstack.split(i - 1));
            }
            this.spitOutItem(this.getItemBySlot(EquipmentSlot.MAINHAND));
            this.setItemSlot(EquipmentSlot.MAINHAND, itemstack.split(1));
            this.take((Entity)itemEntity, itemstack.getCount());
            itemEntity.discard();
            this.eatTicks = 0;
        }
    }

    private void spawnItem(ItemStack stack) {
        this.level().addFreshEntity((Entity)new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), stack));
    }

    public void take(Entity entityIn, int quantity) {
        super.take(entityIn, quantity);
        this.setToDropItem(true);
    }

    public void positionRider(Entity passenger, Entity.MoveFunction function) {
        if (passenger instanceof AbstractFish || passenger instanceof Animal) {
            float distance = 0.7f;
            double dx = Math.cos((double)(this.getYRot() + 90.0f) * Math.PI / 180.0) * (double)distance;
            double dz = Math.sin((double)(this.getYRot() + 90.0f) * Math.PI / 180.0) * (double)distance;
            Vec3 riderPos = new Vec3(this.getX() + dx, this.getY() + (double)this.getDimensions(this.getPose()).height() * 0.075 + this.getFirstPassenger().getVehicleAttachmentPoint((Entity)this).y(), this.getZ() + dz);
            function.accept(passenger, riderPos.x, riderPos.y, riderPos.z);
        } else {
            super.positionRider(passenger);
        }
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)UAItems.PIKE_SPAWN_EGG.get());
    }

    public EntityDimensions getDefaultDimensions(Pose poseIn) {
        return super.getDefaultDimensions(poseIn).scale(((PikeVariant)this.getVariant().value()).size() + 0.2f);
    }

    public boolean isLit() {
        return (Boolean)this.entityData.get(LIT);
    }

    private void setLit(boolean lit) {
        this.entityData.set(LIT, (Object)lit);
    }

    public boolean isMoving() {
        return (Boolean)this.entityData.get(MOVING);
    }

    private void setMoving(boolean moving) {
        this.entityData.set(MOVING, (Object)moving);
    }

    public int getAttackCooldown() {
        return (Integer)this.entityData.get(ATTACK_COOLDOWN);
    }

    public void setAttackCooldown(int ticks) {
        this.entityData.set(ATTACK_COOLDOWN, (Object)ticks);
    }

    public boolean shouldDropItem() {
        return (Boolean)this.entityData.get(DROP_ITEM);
    }

    public void setToDropItem(boolean bool) {
        this.entityData.set(DROP_ITEM, (Object)bool);
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)UASoundEvents.PIKE_AMBIENT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)UASoundEvents.PIKE_DEATH.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return (SoundEvent)UASoundEvents.PIKE_HURT.get();
    }

    protected SoundEvent getFlopSound() {
        return (SoundEvent)UASoundEvents.PIKE_FLOP.get();
    }

    protected void playStepSound(BlockPos p_27482_, BlockState p_27483_) {
    }

    protected SoundEvent getSwimSound() {
        return SoundEvents.FISH_SWIM;
    }

    public void setVariant(Holder<PikeVariant> variant) {
        this.entityData.set(VARIANT, variant);
    }

    public Holder<PikeVariant> getVariant() {
        return (Holder)this.entityData.get(VARIANT);
    }

    static class MoveHelperController
    extends MoveControl {
        private final Pike pike;

        MoveHelperController(Pike pike) {
            super((Mob)pike);
            this.pike = pike;
        }

        public void tick() {
            if (this.pike.isEyeInFluid(FluidTags.WATER)) {
                this.pike.setDeltaMovement(this.pike.getDeltaMovement().add(0.0, 0.001, 0.0));
            }
            if (this.operation == MoveControl.Operation.MOVE_TO && !this.pike.getNavigation().isDone()) {
                double d0 = this.wantedX - this.pike.getX();
                double d1 = this.wantedY - this.pike.getY();
                double d2 = this.wantedZ - this.pike.getZ();
                double d3 = Mth.sqrt((float)((float)(d0 * d0 + d1 * d1 + d2 * d2)));
                d1 /= d3;
                float f = (float)(Mth.atan2((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                this.pike.setYRot(this.rotlerp(this.pike.getYRot(), f, 90.0f));
                this.pike.yBodyRot = this.pike.getYRot();
                float f1 = (float)(this.speedModifier * this.pike.getAttribute(Attributes.MOVEMENT_SPEED).getValue());
                this.pike.setSpeed(Mth.lerp((float)0.125f, (float)this.pike.getSpeed(), (float)f1));
                this.pike.setDeltaMovement(this.pike.getDeltaMovement().add(0.0, (double)this.pike.getSpeed() * d1 * 0.04, 0.0));
                this.pike.setMoving(true);
            } else {
                if (this.pike.getVariant().is(UAPikeVariants.SUPERCHARGED)) {
                    this.pike.setSpeed(0.0f);
                }
                this.pike.setMoving(false);
            }
        }
    }

    static class PikeData
    implements SpawnGroupData {
        public final Holder<PikeVariant> type;

        public PikeData(Holder<PikeVariant> type) {
            this.type = type;
        }
    }
}

