/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.common.entity.ai.goal.thrasher;

import com.teamabnormals.blueprint.core.api.AdvancedRandomPos;
import com.teamabnormals.upgrade_aquatic.common.entity.monster.Thrasher;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;

public class ThrasherRandomSwimGoal
extends RandomSwimmingGoal {
    private final Thrasher thrasher;

    public ThrasherRandomSwimGoal(Thrasher thrasher, double speed, int chance) {
        super((PathfinderMob)thrasher, speed, chance);
        this.thrasher = thrasher;
    }

    public boolean canUse() {
        Vec3 vec3d;
        if (!this.forceTrigger) {
            if (this.thrasher.getNoActionTime() >= 100) {
                return false;
            }
            if (this.thrasher.getRandom().nextInt(this.interval) != 0) {
                return false;
            }
        }
        if ((vec3d = this.getPosition()) == null) {
            return false;
        }
        this.wantedX = vec3d.x;
        this.wantedY = vec3d.y;
        this.wantedZ = vec3d.z;
        this.forceTrigger = false;
        return true;
    }

    public boolean canContinueToUse() {
        return super.canContinueToUse();
    }

    @Nullable
    protected Vec3 getPosition() {
        Vec3 vec3d = AdvancedRandomPos.findRandomTarget((PathfinderMob)this.mob, (int)15, (int)8, (!this.thrasher.getPassengers().isEmpty() ? 1 : 0) != 0);
        int i = 0;
        while (vec3d != null && !this.mob.level().getBlockState(BlockPos.containing((Position)vec3d)).isPathfindable(PathComputationType.WATER) && i++ < 10) {
            vec3d = AdvancedRandomPos.findRandomTarget((PathfinderMob)this.mob, (int)10, (int)8, (!this.thrasher.getPassengers().isEmpty() ? 1 : 0) != 0);
        }
        return vec3d;
    }
}

