/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.common.entity.ai.goal.thrasher;

import com.teamabnormals.upgrade_aquatic.common.entity.monster.Thrasher;
import java.util.EnumSet;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.phys.AABB;

public class ThrasherFindDetectionPointGoal
extends Goal {
    public Thrasher thrasher;
    private LivingEntity foundTarget;
    private BlockPos foundPos;
    private int ticksPassed;

    public ThrasherFindDetectionPointGoal(Thrasher thrasher) {
        this.thrasher = thrasher;
        this.setFlags(EnumSet.of(Goal.Flag.TARGET));
    }

    public boolean canUse() {
        boolean flag;
        boolean bl = flag = !this.thrasher.isStunned() && this.thrasher.getRandom().nextFloat() < 0.05f;
        if (flag) {
            this.findNearestTarget();
            return this.foundTarget != null && this.thrasher.getTicksSinceLastSonarFire() > 55 && Thrasher.ENEMY_MATCHER.test((Entity)this.foundTarget);
        }
        return false;
    }

    public boolean canContinueToUse() {
        return !this.thrasher.isStunned() && this.thrasher.getPossibleDetectionPoint() == null && this.ticksPassed < 10;
    }

    public void stop() {
        if (this.foundPos != null && !this.thrasher.isStunned()) {
            this.thrasher.setPossibleDetectionPoint(Optional.of(this.foundPos));
        }
    }

    public void tick() {
        ++this.ticksPassed;
        RandomSource rand = this.thrasher.getRandom();
        this.foundPos = this.foundTarget.blockPosition().offset(rand.nextInt(2), rand.nextInt(2), rand.nextInt(2));
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    private void findNearestTarget() {
        this.foundTarget = this.thrasher.level().getNearestEntity(this.thrasher.level().getEntitiesOfClass(LivingEntity.class, this.getTargetableArea(32.0), Thrasher.ENEMY_MATCHER), TargetingConditions.forCombat().range(this.getTargetDistance()).selector(null), (LivingEntity)this.thrasher, this.thrasher.getX(), this.thrasher.getY() + (double)this.thrasher.getEyeHeight(), this.thrasher.getZ());
    }

    private double getTargetDistance() {
        AttributeInstance iattributeinstance = this.thrasher.getAttribute(Attributes.FOLLOW_RANGE);
        return iattributeinstance == null ? 16.0 : iattributeinstance.getValue();
    }

    private AABB getTargetableArea(double targetDistance) {
        return this.thrasher.getBoundingBox().inflate(targetDistance, 4.0, targetDistance);
    }
}

