/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.common.entity.ai.goal.pike;

import com.teamabnormals.upgrade_aquatic.common.entity.animal.Pike;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;

public final class PikeSwimToItemsGoal
extends Goal {
    private final Pike pike;

    public PikeSwimToItemsGoal(Pike pike) {
        this.pike = pike;
    }

    public boolean canUse() {
        List list = this.pike.level().getEntitiesOfClass(ItemEntity.class, this.pike.getBoundingBox().inflate(8.0, 8.0, 8.0), Pike.ITEM_SELECTOR);
        return !list.isEmpty() || !this.pike.getItemBySlot(EquipmentSlot.MAINHAND).isEmpty();
    }

    public void start() {
        this.moveTowardsNearestItem();
    }

    public void tick() {
        if (this.pike.getItemBySlot(EquipmentSlot.MAINHAND).isEmpty()) {
            this.moveTowardsNearestItem();
        }
    }

    private void moveTowardsNearestItem() {
        List list = this.pike.level().getEntitiesOfClass(ItemEntity.class, this.pike.getBoundingBox().inflate(8.0, 8.0, 8.0), Pike.ITEM_SELECTOR);
        if (!list.isEmpty()) {
            this.pike.getNavigation().moveTo((Entity)list.get(0), (double)1.2f);
        }
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }
}

