/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.common.effect;

import com.teamabnormals.upgrade_aquatic.common.entity.monster.Flare;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.ServerStatsCounter;
import net.minecraft.stats.Stats;
import net.minecraft.world.effect.InstantenousMobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.entity.player.Player;

public class RestfulnessMobEffect
extends InstantenousMobEffect {
    public RestfulnessMobEffect() {
        super(MobEffectCategory.BENEFICIAL, 11830901);
    }

    public boolean applyEffectTick(LivingEntity entity, int amplifier) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            ServerStatsCounter statisticsManager = serverPlayer.getStats();
            statisticsManager.increment((Player)serverPlayer, Stats.CUSTOM.get((Object)Stats.TIME_SINCE_REST), -(24000 * (amplifier + 1)));
        } else if (entity instanceof Phantom) {
            entity.hurt(entity.damageSources().magic(), Float.MAX_VALUE);
        } else if (entity instanceof Flare) {
            Phantom phantom = (Phantom)EntityType.PHANTOM.create(entity.level());
            phantom.moveTo(entity.getX(), entity.getY(), entity.getZ(), entity.getYRot(), entity.getXRot());
            phantom.setNoAi(((Mob)entity).isNoAi());
            if (entity.hasCustomName()) {
                phantom.setCustomName(entity.getCustomName());
                phantom.setCustomNameVisible(entity.isCustomNameVisible());
            }
            phantom.setHealth(entity.getHealth());
            if (phantom.getHealth() > 0.0f) {
                entity.level().addFreshEntity((Entity)phantom);
                entity.discard();
            }
            entity.discard();
        }
        return true;
    }
}

