/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.common.effect;

import com.teamabnormals.upgrade_aquatic.common.entity.monster.Flare;
import com.teamabnormals.upgrade_aquatic.core.registry.UACriteriaTriggers;
import com.teamabnormals.upgrade_aquatic.core.registry.UAEntityTypes;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.ServerStatsCounter;
import net.minecraft.stats.Stats;
import net.minecraft.world.effect.InstantenousMobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.entity.player.Player;

public class InsomniaMobEffect
extends InstantenousMobEffect {
    public InsomniaMobEffect() {
        super(MobEffectCategory.HARMFUL, 10515892);
    }

    public boolean applyEffectTick(LivingEntity entity, int amplifier) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer playerMP = (ServerPlayer)entity;
            ServerStatsCounter statisticsManager = playerMP.getStats();
            statisticsManager.increment((Player)playerMP, Stats.CUSTOM.get((Object)Stats.TIME_SINCE_REST), 24000 * (amplifier + 1));
            return true;
        }
        if (entity instanceof Phantom) {
            Player player;
            Flare flare = (Flare)((EntityType)UAEntityTypes.FLARE.get()).create(entity.level());
            flare.moveTo(entity.getX(), entity.getY(), entity.getZ(), entity.getYRot(), entity.getXRot());
            flare.setNoAi(((Mob)entity).isNoAi());
            if (entity.hasCustomName()) {
                flare.setCustomName(entity.getCustomName());
                flare.setCustomNameVisible(entity.isCustomNameVisible());
            }
            flare.setHealth(entity.getHealth());
            if (flare.getHealth() > 0.0f) {
                entity.level().addFreshEntity((Entity)flare);
                entity.discard();
            }
            if ((player = entity.getCommandSenderWorld().getNearestPlayer((Entity)entity, 11.0)) instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                if (player.isAlive() && !entity.level().isClientSide()) {
                    ((PlayerTrigger)UACriteriaTriggers.CONVERT_PHANTOM.get()).trigger(serverPlayer);
                }
            }
            return true;
        }
        if (entity instanceof Flare) {
            entity.hurt(entity.damageSources().magic(), Float.MAX_VALUE);
            return true;
        }
        return false;
    }
}

